.\" Start URL macro. Copied from an-ext.tmac for portability
.de UR
.  ds m1 \\$1\"
.  nh
.  if \\n(mH \{\
.    \" Start diversion in a new environment.
.    do ev URL-div
.    do di URL-div
.  \}
..
.\" End URL macro. Copied from an-ext.tmac for portability
.de UE
.  ie \\n(mH \{\
.    br
.    di
.    ev
.
.    \" Has there been one or more input lines for the link text?
.    ie \\n(dn \{\
.      do HTML-NS "<a href=""\\*(m1"">"
.      \" Yes, strip off final newline of diversion and emit it.
.      do chop URL-div
.      do URL-div
\c
.      do HTML-NS </a>
.    \}
.    el \
.      do HTML-NS "<a href=""\\*(m1"">\\*(m1</a>"
\&\\$*\"
.  \}
.  el \
\\*(la\\*(m1\\*(ra\\$*\"
.
.  hy \\n(HY
..
.TH ZABBIX_GET 1 "2022\-01\-06" Zabbix
.SH NAME
zabbix_get \- Zabbix get utility
.SH SYNOPSIS
.B zabbix_get \-s
.I host\-name\-or\-IP
.RB [ \-p
.IR port\-number ]
.RB [ \-I
.IR IP\-address ]
.RB [ \-t
.IR timeout ]
.BI \-k " item\-key"
.br
.B zabbix_get \-s
.I host\-name\-or\-IP
.RB [ \-p
.IR port\-number ]
.RB [ \-I
.IR IP\-address ]
.RB [ \-t
.IR timeout ]
.B \-\-tls\-connect
.B cert
.B \-\-tls\-ca\-file
.IR CA\-file
.RB [ \-\-tls\-crl\-file
.IR CRL\-file ]
.RB [ \-\-tls\-agent\-cert\-issuer
.IR cert\-issuer ]
.RB [ \-\-tls\-agent\-cert\-subject
.IR cert\-subject ]
.B \-\-tls\-cert\-file
.IR cert\-file
.B \-\-tls\-key\-file
.IR key\-file
.RB [ \-\-tls\-cipher13
.IR cipher\-string ]
.RB [ \-\-tls\-cipher
.IR cipher\-string ]
.BI \-k " item\-key"
.br
.B zabbix_get \-s
.I host\-name\-or\-IP
.RB [ \-p
.IR port\-number ]
.RB [ \-I
.IR IP\-address ]
.RB [ \-t
.IR timeout ]
.B \-\-tls\-connect
.B psk
.B \-\-tls\-psk\-identity
.IR PSK\-identity
.B \-\-tls\-psk\-file
.IR PSK\-file
.RB [ \-\-tls\-cipher13
.IR cipher\-string ]
.RB [ \-\-tls\-cipher
.IR cipher\-string ]
.BI \-k " item\-key"
.br
.B zabbix_get \-h
.br
.B zabbix_get \-V
.SH DESCRIPTION
.B zabbix_get
is a command line utility for getting data from Zabbix agent.
.SH OPTIONS
.IP "\fB\-s\fR, \fB\-\-host\fR \fIhost\-name\-or\-IP\fR"
Specify host name or IP address of a host.
.IP "\fB\-p\fR, \fB\-\-port\fR \fIport\-number\fR"
Specify port number of agent running on the host.
Default is 10050.
.IP "\fB\-I\fR, \fB\-\-source\-address\fR \fIIP\-address\fR"
Specify source IP address.
.IP "\fB\-t\fR, \fB\-\-timeout\fR \fIseconds\fR"
Specify timeout. Valid range: 1\-600 seconds (default: 30)
.IP "\fB\-k\fR, \fB\-\-key\fR \fIitem\-key\fR"
Specify key of item to retrieve value for.
.IP "\fB\-P\fR, \fB\-\-protocol\fR \fIvalue\fR"
Protocol used to communicate with agent. Values:\fR
.SS
.RS 12
.TP 12
.B auto
connect using JSON protocol, fallback and retry with plaintext protocol (default)
.RE
.RS 12
.TP 12
.B json
connect using JSON protocol
.RE
.RS 12
.TP 12
.B plaintext
connect using plaintext protocol where just item key is sent (6.4.x and older releases)
.RE
.RE
.IP "\fB\-\-tls\-connect\fR \fIvalue\fR"
How to connect to agent. Values:\fR
.SS
.RS 12
.TP 12
.B unencrypted
connect without encryption (default)
.RE
.RS 12
.TP 12
.B psk
connect using TLS and a pre-shared key
.RE
.RS 12
.TP 12
.B cert
connect using TLS and a certificate
.RE
.RE
.IP "\fB\-\-tls\-ca\-file\fR \fICA\-file\fR"
Full pathname of a file containing the top-level CA(s) certificates for peer certificate verification.
.IP "\fB\-\-tls\-crl\-file\fR \fICRL\-file\fR"
Full pathname of a file containing revoked certificates.
.IP "\fB\-\-tls\-agent\-cert\-issuer\fR \fIcert\-issuer\fR"
Allowed agent certificate issuer.
.IP "\fB\-\-tls\-agent\-cert\-subject\fR \fIcert\-subject\fR"
Allowed agent certificate subject.
.IP "\fB\-\-tls\-cert\-file\fR \fIcert\-file\fR"
Full pathname of a file containing the certificate or certificate chain.
.IP "\fB\-\-tls\-key\-file\fR \fIkey\-file\fR"
Full pathname of a file containing the private key.
.IP "\fB\-\-tls\-psk\-identity\fR \fIPSK\-identity\fR"
PSK\-identity string.
.IP "\fB\-\-tls\-psk\-file\fR \fIPSK\-file\fR"
Full pathname of a file containing the pre-shared key.
.IP "\fB\-\-tls\-cipher13\fR \fIcipher\-string\fR"
Cipher string for OpenSSL 1.1.1 or newer for TLS 1.3. Override the default ciphersuite selection criteria. This option is not available if OpenSSL version is less than 1.1.1.
.IP "\fB\-\-tls\-cipher\fR \fIcipher\-string\fR"
GnuTLS priority string (for TLS 1.2 and up) or OpenSSL cipher string (only for TLS 1.2). Override the default ciphersuite selection criteria.
.IP "\fB\-h\fR, \fB\-\-help\fR"
Display this help and exit.
.IP "\fB\-V\fR, \fB\-\-version\fR"
Output version information and exit.
.SH EXIT STATUS
The exit status is 0 if zabbix_get successfully retrieves a value from the Zabbix agent. If value retrieval failed, the exit status is 1.
.SH "EXAMPLES"
\fBzabbix_get \-s 127.0.0.1 \-p 10050 \-k "system.cpu.load[all,avg1]"\fR
.br
\fBzabbix_get \-s 127.0.0.1 \-p 10050 \-k "system.cpu.load[all,avg1]" \-\-tls\-connect cert \-\-tls\-ca\-file /home/zabbix/zabbix_ca_file \-\-tls\-agent\-cert\-issuer "CN=Signing CA,OU=IT operations,O=Example Corp,DC=example,DC=com" \-\-tls\-agent\-cert\-subject "CN=server1,OU=IT operations,O=Example Corp,DC=example,DC=com" \-\-tls\-cert\-file /home/zabbix/zabbix_get.crt \-\-tls\-key\-file /home/zabbix/zabbix_get.key
.br
\fBzabbix_get \-s 127.0.0.1 \-p 10050 \-k "system.cpu.load[all,avg1]" \-\-tls\-connect psk \-\-tls\-psk\-identity "PSK ID Zabbix agentd" \-\-tls\-psk\-file /home/zabbix/zabbix_agentd.psk\fR
.SH "SEE ALSO"
.UR https://www.zabbix.com/manuals
Documentation
.UE
.PP
.BR zabbix_agentd (8),
.BR zabbix_proxy (8),
.BR zabbix_sender (1),
.BR zabbix_server (8),
.BR zabbix_js (1),
.BR zabbix_agent2 (8),
.BR zabbix_web_service (8)
