VIMTUTOR(1)                 General Commands Manual                VIMTUTOR(1)

NAME
       vimtutor - the Vim tutor

SYNOPSIS
       vimtutor  [-l | --language ISO639] [-c | --chapter NUMBER] [-g | --gui]
       [ISO639]
       vimtutor [-h | --help]
       vimtutor [--list]

DESCRIPTION
       Vimtutor starts the Vim tutor.

       The Vimtutor is useful for people that want to learn  their  first  Vim
       commands.   The  optional  [ISO639] argument is the two or three letter
       name of a language, like "it" or "es".

       Vimtutor only opens temporary copies of the original tutor files, there
       is no danger of overwriting the lessons.

       Vim is always started in Vi nocompatible mode.

OPTIONS
       -l, --language ISO639
              Set the two or three letter  language  code.  E.g.  'it',  'es',
              'bar'.   Defaults  to  language  of locale if available, else to
              English.

       -c, --chapter NUMBER
              Set the chapter number. Defaults to chapter one.

       -g, --gui
              Start vimtutor in the GUI version of vim if available, otherwise
              fallback to console vim.

       -h, --help
              Display usage information.

       --list Display chapters and languages.

EXAMPLES
       To start vimtutor in German on chapter one:

              vimtutor de

       In English on chapter two:

              vimtutor -c2

       Longform command for Bavarian in the GUI on chapter one:

              vimtutor --language bar --chapter 1 --gui

FILES
       /usr/local/share/vim/vim??/tutor/tutor1[.language]
                      The Vimtutor chapter one text file(s).

       /usr/local/share/vim/vim??/tutor/tutor2[.language]
                      The Vimtutor chapter two text file(s).

       /usr/local/share/vim/vim??/tutor/tutor.vim
                      The Vim script used to copy the Vimtutor text file.

AUTHOR
       The Vi Tutorial was originally written for Vi by Michael C. Pierce  and
       Robert  K.  Ware,  Colorado  School  of  Mines  using ideas supplied by
       Charles Smith, Colorado  State  University.   E-mail:  bware@mines.col‐
       orado.edu (now invalid).

       Modified for Vim by Bram Moolenaar.

       Translation contributors are listed in the tutor files.

SEE ALSO
       vim(1)

                               2024 December 03                    VIMTUTOR(1)
