// Copyright 2022 Oliver Smith, Martijn Braam
// Copyright 2024-2025 Dylan Van Assche
// SPDX-License-Identifier: MPL-2.0

// Set up autoconfig (we use it to copy/update userChrome.css into profile dir)
pref('general.config.filename', "mobile-config-autoconfig.js");
pref('general.config.obscure_value', 0);
pref('general.config.sandbox_enabled', false);

// Enable android-style pinch-to-zoom
pref('dom.w3c.touch_events.enabled', true);
pref('apz.allow_zooming', true);
pref('apz.allow_double_tap_zooming', true);

// Allow UI customizations with userChrome.css and userContent.css
pref('toolkit.legacyUserProfileCustomizations.stylesheets', true);

// Disable search suggestions
pref('browser.search.suggest.enabled', false);

// Disable cosmetic animations, save CPU
pref('toolkit.cosmeticAnimations.enabled', false);

// Disable download animations, save CPU
pref('browser.download.animateNotifications', false);

// Enable touch density
pref('browser.uidensity', 2);

// Only icons in the unifiedtoolbar
pref('toolbar.unifiedtoolbar.buttonstyle', 2);
