# frozen_string_literal: true

require_relative "lib/async/http/version"

Gem::Specification.new do |spec|
	spec.name = "async-http"
	spec.version = Async::HTTP::VERSION
	
	spec.summary = "A HTTP client and server library."
	spec.authors = ["Samuel Williams", "Brian Morearty", "Bruno Sutic", "Janko Marohnić", "Thomas Morgan", "Adam Daniels", "Igor Sidorov", "William T. Nelson", "Anton Zhuravsky", "Cyril Roelandt", "Denis Talakevich", "Hal Brodigan", "Ian Ker-Seymer", "Jean Boussier", "Josh Huber", "Marco Concetto Rudilosso", "Olle Jonsson", "Orgad Shaneh", "Sam Shadwell", "Stefan Wrobel", "Tim Meusel", "Trevor Turk", "Viacheslav Koval", "Yuuji Yaginuma", "dependabot[bot]"]
	spec.license = "MIT"
	
	spec.cert_chain  = ["release.cert"]
	spec.signing_key = File.expand_path("~/.gem/release.pem")
	
	spec.homepage = "https://github.com/socketry/async-http"
	
	spec.metadata = {
		"documentation_uri" => "https://socketry.github.io/async-http/",
		"source_code_uri" => "https://github.com/socketry/async-http.git",
	}
	
	spec.files = Dir.glob(["{bake,context,lib}/**/*", "*.md"], File::FNM_DOTMATCH, base: __dir__)
	
	spec.required_ruby_version = ">= 3.2"
	
	spec.add_dependency "async", ">= 2.10.2"
	spec.add_dependency "async-pool", "~> 0.11"
	spec.add_dependency "io-endpoint", "~> 0.14"
	spec.add_dependency "io-stream", "~> 0.6"
	spec.add_dependency "metrics", "~> 0.12"
	spec.add_dependency "protocol-http", "~> 0.58"
	spec.add_dependency "protocol-http1", "~> 0.36"
	spec.add_dependency "protocol-http2", "~> 0.22"
	spec.add_dependency "protocol-url", "~> 0.2"
	spec.add_dependency "traces", "~> 0.10"
end
