<!-- markdownlint-disable first-line-h1 -->
### Changes in this release

#### Ubuntu 18.04 end-of-life announcement

Support for Ubuntu 18.04 ends in this release. Future releases of ROCm will not provide prebuilt
packages for Ubuntu 18.04.

#### HIP runtime

##### Fixes

* A bug was discovered in the HIP graph capture implementation in the ROCm v5.2.0 release. If the
  same kernel is called twice (with different argument values) in a graph capture, the implementation
  only kept the argument values for the second kernel call.

* A bug was introduced in the hiprtc implementation in the ROCm v5.2.0 release. This bug caused the
  `hiprtcGetLoweredName` call to fail for named expressions with whitespace in it.

Example:

The named expression `my_sqrt<complex<double>>` passed but `my_sqrt<complex<double >>`
failed.

#### RCCL

##### Additions

Compatibility with NCCL 2.12.10

* Packages for test and benchmark executables on all supported OSes using CPack

* Added custom signal handler - opt-in with RCCL_ENABLE_SIGNALHANDLER=1

  * Additional details provided if Binary File Descriptor library (BFD) is pre-installed.

* Added experimental support for using multiple ranks per device

  * Requires using a new interface to create communicator (ncclCommInitRankMulti), refer to the
    interface documentation for details.

  * To avoid potential deadlocks, user might have to set an environment variables increasing the
    number of hardware queues. For example,

```sh
export GPU_MAX_HW_QUEUES=16
```

* Added support for reusing ports in NET/IB channels

  * Opt-in with NCCL_IB_SOCK_CLIENT_PORT_REUSE=1 and NCCL_IB_SOCK_SERVER_PORT_REUSE=1

  * When "Call to bind failed: Address already in use" error happens in large-scale AlltoAll (for example,
    \>=64 MI200 nodes), users are suggested to opt-in either one or both of the options to resolve the
    massive port usage issue

  * Avoid using NCCL_IB_SOCK_SERVER_PORT_REUSE when NCCL_NCHANNELS_PER_NET_PEER is tuned
    \>1

##### Removals

* Removed experimental clique-based kernels

#### Development tools

No notable changes in this release for development tools, including the compiler, profiler, and
debugger deployment and management tools

No notable changes in this release for deployment and management tools.

For release information for older ROCm releases, refer to
<https://github.com/ROCm/ROCm/blob/master/CHANGELOG.md>
