<div align="center">
  <img src="data/icons/hicolor/scalable/apps/page.tesk.Refine.svg" width="128" height="128">

  # Refine

  Tweak various aspects of GNOME

  <img width="922" src="data/screenshots/1.png">
</div>

## Contributing

This project follows the [GNOME Code of Conduct](https://wiki.gnome.org/Foundation/CodeOfConduct).

## Development

### Flatpak

Add the [GNOME Nightly](https://wiki.gnome.org/Apps/Nightly) repository:

**System**

```bash
flatpak remote-add --if-not-exists gnome-nightly https://nightly.gnome.org/gnome-nightly.flatpakrepo
```

**User**

```bash
flatpak remote-add --if-not-exists --user gnome-nightly https://nightly.gnome.org/gnome-nightly.flatpakrepo
```

#### GNOME Builder

The recommended method is to use GNOME Builder:

1. Install [GNOME Builder](https://apps.gnome.org/app/org.gnome.Builder/) from Flathub
2. Open Builder and select "Clone Repository…"
3. Clone `https://gitlab.gnome.org/TheEvilSkeleton/Refine.git` (or your fork)
4. Press "Run Project" (▶) at the top, or `Ctrl`+`Shift`+`[Spacebar]`.

#### Flatpak Builder

1. Install [`org.flatpak.Builder`](https://github.com/flathub/org.flatpak.Builder) from Flathub

   ```bash
   flatpak install org.flatpak.Builder
   ```

2. Clone the repository (or your fork)

   ```bash
   git clone https://gitlab.gnome.org/TheEvilSkeleton/Refine.git
   ```

3. To build, run the following in a terminal from the root of the repository:

   ```bash
   flatpak run org.flatpak.Builder --force-clean --install --user build-dir build-aux/page.tesk.Refine.Devel.json
   ```

4. To launch Refine, run:

   ```bash
   flatpak run page.tesk.Refine.Devel
   ```

### Meson

You can build and install on your host system by directly using the Meson buildsystem:

1. Install `blueprint-compiler`
2. Run the following commands (with `/usr` prefix):

   ```bash
   meson --prefix=/usr build
   ninja -C build
   sudo ninja -C build install
   ```
