% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml_url.R
\name{url_absolute}
\alias{url_absolute}
\alias{url_relative}
\title{Convert between relative and absolute urls.}
\usage{
url_absolute(x, base)

url_relative(x, base)
}
\arguments{
\item{x}{A character vector of urls relative to that base}

\item{base}{A string giving a base url.}
}
\value{
A character vector of urls
}
\description{
Convert between relative and absolute urls.
}
\examples{
url_absolute(c(".", "..", "/", "/x"), "http://hadley.nz/a/b/c/d")

url_relative("http://hadley.nz/a/c", "http://hadley.nz")
url_relative("http://hadley.nz/a/c", "http://hadley.nz/")
url_relative("http://hadley.nz/a/c", "http://hadley.nz/a/b")
url_relative("http://hadley.nz/a/c", "http://hadley.nz/a/b/")
}
\seealso{
\code{\link{xml_url}} to retrieve the URL associated with a document
}
