% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{SingleSpatialPlot}
\alias{SingleSpatialPlot}
\title{Base plotting function for all Spatial plots}
\usage{
SingleSpatialPlot(
  data,
  image,
  cols = NULL,
  image.alpha = 1,
  image.scale = "lowres",
  pt.alpha = NULL,
  crop = TRUE,
  pt.size.factor = NULL,
  shape = 21,
  stroke = NA,
  col.by = NULL,
  alpha.by = NULL,
  cells.highlight = NULL,
  cols.highlight = c("#DE2D26", "grey50"),
  geom = c("spatial", "interactive", "poly", "poly_starmap"),
  na.value = "grey50",
  plot_segmentations = FALSE
)
}
\arguments{
\item{data}{Data.frame with info to be plotted}

\item{image}{\code{SpatialImage} object to be plotted}

\item{cols}{Vector of colors, each color corresponds to an identity class.
This may also be a single character
or numeric value corresponding to a palette as specified by
\code{\link[RColorBrewer]{brewer.pal.info}}. By default, ggplot2 assigns
colors}

\item{image.alpha}{Adjust the opacity of the background images. Set to 0 to
remove.}

\item{image.scale}{Choose the scale factor ("lowres"/"hires") to apply in
order to matchthe plot with the specified `image` - defaults to "lowres"}

\item{pt.alpha}{Adjust the opacity of the points if plotting a
\code{SpatialDimPlot}}

\item{crop}{Crop the plot in to focus on points plotted. Set to \code{FALSE}
to show entire background image.}

\item{pt.size.factor}{Sets the size of the points relative to spot.radius}

\item{shape}{Control the shape of the spots - same as the ggplot2 parameter.
The default is 21, which plots cirlces - use 22 to plot squares.}

\item{stroke}{Control the width of the border around the spots}

\item{col.by}{Mapping variable for the point color}

\item{alpha.by}{Mapping variable for the point alpha value}

\item{cells.highlight}{A list of character or numeric vectors of cells to
highlight. If only one group of cells desired, can simply pass a vector
instead of a list. If set, colors selected cells to the color(s) in
cols.highlight}

\item{cols.highlight}{A vector of colors to highlight the cells as; ordered
the same as the groups in cells.highlight; last color corresponds to
unselected cells.}

\item{geom}{Switch between normal spatial geom and geom to enable hover
functionality}

\item{na.value}{Color for spots with NA values}

\item{plot_segmentations}{Define whether plot should plot centroids or segmentations}
}
\value{
A ggplot2 object
}
\description{
Base plotting function for all Spatial plots
}
\keyword{internal}
