% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breaks.R
\name{breaks_extended}
\alias{breaks_extended}
\alias{extended_breaks}
\title{Automatic breaks for numeric axes}
\usage{
breaks_extended(n = 5, ...)
}
\arguments{
\item{n}{Desired number of breaks. You may get slightly more or fewer
breaks that requested.}

\item{...}{other arguments passed on to \code{\link[labeling:extended]{labeling::extended()}}}
}
\value{
All \code{breaks_()} functions return a function for generating breaks. These
functions takes, as their first argument a vector of values that represent
the data range to provide breaks for. Some will optionally take a second
argument that allows you to specify the number of breaks to recieve.
}
\description{
Uses Wilkinson's extended breaks algorithm as implemented in the
\pkg{labeling} package.
}
\examples{
demo_continuous(c(0, 10))
demo_continuous(c(0, 10), breaks = breaks_extended(3))
demo_continuous(c(0, 10), breaks = breaks_extended(10))
}
\references{
Talbot, J., Lin, S., Hanrahan, P. (2010) An Extension of
Wilkinson's Algorithm for Positioning Tick Labels on Axes, InfoVis
2010 \url{http://vis.stanford.edu/files/2010-TickLabels-InfoVis.pdf}.
}
