% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_student_t.R
\name{dist_student_t}
\alias{dist_student_t}
\title{The (non-central) location-scale Student t Distribution}
\usage{
dist_student_t(df, mu = 0, sigma = 1, ncp = NULL)
}
\arguments{
\item{df}{degrees of freedom (\eqn{> 0}, maybe non-integer).  \code{df
      = Inf} is allowed.}

\item{mu}{The location parameter of the distribution.
If \code{ncp == 0} (or \code{NULL}), this is the median.}

\item{sigma}{The scale parameter of the distribution.}

\item{ncp}{non-centrality parameter \eqn{\delta}{delta};
    currently except for \code{rt()}, accurate only for \code{abs(ncp) <= 37.62}.
    If omitted, use the central t distribution.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The Student's T distribution is closely related to the \code{\link[=Normal]{Normal()}}
distribution, but has heavier tails. As \eqn{\nu} increases to \eqn{\infty},
the Student's T converges to a Normal. The T distribution appears
repeatedly throughout classic frequentist hypothesis testing when
comparing group means.
}
\details{
We recommend reading this documentation on \href{https://pkg.mitchelloharawild.com/distributional/reference/dist_student_t.html}{pkgdown} which renders math nicely.
\url{https://pkg.mitchelloharawild.com/distributional/reference/dist_student_t.html}

In the following, let \eqn{X} be a location-scale Student's T random variable with
\code{df} = \eqn{\nu}, \code{mu} = \eqn{\mu}, \code{sigma} = \eqn{\sigma}, and
\code{ncp} = \eqn{\delta} (non-centrality parameter).

If \eqn{Z} follows a standard Student's T distribution (with \code{df} = \eqn{\nu}
and \code{ncp} = \eqn{\delta}), then \eqn{X = \mu + \sigma Z}.

\strong{Support}: \eqn{R}, the set of all real numbers

\strong{Mean}:

For the central distribution (\code{ncp} = 0 or \code{NULL}):

\deqn{
    E(X) = \mu
  }{
    E(X) = \mu
  }

for \eqn{\nu > 1}, and undefined otherwise.

For the non-central distribution (\code{ncp} \eqn{\neq} 0):

\deqn{
    E(X) = \mu + \delta \sqrt{\frac{\nu}{2}} \frac{\Gamma((\nu-1)/2)}{\Gamma(\nu/2)} \sigma
  }{
    E(X) = \mu + \delta \sqrt(\nu / 2) \Gamma((\nu-1)/2) / \Gamma(\nu/2) \sigma
  }

for \eqn{\nu > 1}, and undefined otherwise.

\strong{Variance}:

For the central distribution (\code{ncp} = 0 or \code{NULL}):

\deqn{
    \mathrm{Var}(X) = \frac{\nu}{\nu - 2} \sigma^2
  }{
    Var(X) = \nu / (\nu - 2) \sigma^2
  }

for \eqn{\nu > 2}. Undefined if \eqn{\nu \le 1}, infinite when \eqn{1 < \nu \le 2}.

For the non-central distribution (\code{ncp} \eqn{\neq} 0):

\deqn{
    \mathrm{Var}(X) = \left[\frac{\nu(1+\delta^2)}{\nu-2} - \left(\delta \sqrt{\frac{\nu}{2}} \frac{\Gamma((\nu-1)/2)}{\Gamma(\nu/2)}\right)^2\right] \sigma^2
  }{
    Var(X) = [(\nu(1+\delta^2))/(\nu-2) - (\delta \sqrt(\nu / 2) \Gamma((\nu-1)/2) / \Gamma(\nu/2))^2] \sigma^2
  }

for \eqn{\nu > 2}. Undefined if \eqn{\nu \le 1}, infinite when \eqn{1 < \nu \le 2}.

\strong{Probability density function (p.d.f)}:

For the central distribution (\code{ncp} = 0 or \code{NULL}), the standard
t distribution with \code{df} = \eqn{\nu} has density:

\deqn{
    f_Z(z) = \frac{\Gamma((\nu + 1)/2)}{\sqrt{\pi \nu} \Gamma(\nu/2)} \left(1 + \frac{z^2}{\nu} \right)^{- (\nu + 1)/2}
  }{
    f_Z(z) = \Gamma((\nu + 1) / 2) / (\sqrt(\pi \nu) \Gamma(\nu / 2)) (1 + z^2 / \nu)^(- (\nu + 1) / 2)
  }

The location-scale version with \code{mu} = \eqn{\mu} and \code{sigma} = \eqn{\sigma}
has density:

\deqn{
    f(x) = \frac{1}{\sigma} f_Z\left(\frac{x - \mu}{\sigma}\right)
  }{
    f(x) = (1/\sigma) f_Z((x - \mu) / \sigma)
  }

For the non-central distribution (\code{ncp} \eqn{\neq} 0), the density is
computed numerically via \code{\link[stats:TDist]{stats::dt()}}.

\strong{Cumulative distribution function (c.d.f)}:

For the central distribution (\code{ncp} = 0 or \code{NULL}), the cumulative
distribution function is computed numerically via \code{\link[stats:TDist]{stats::pt()}}, which
uses the relationship to the incomplete beta function:

\deqn{
    F_\nu(t) = \frac{1}{2} I_x\left(\frac{\nu}{2}, \frac{1}{2}\right)
  }{
    F_\nu(t) = (1/2) I_x(\nu/2, 1/2)
  }

for \eqn{t \le 0}, where \eqn{x = \nu/(\nu + t^2)} and \eqn{I_x(a,b)} is
the incomplete beta function (\code{\link[stats:Beta]{stats::pbeta()}}). For \eqn{t \ge 0}:

\deqn{
    F_\nu(t) = 1 - \frac{1}{2} I_x\left(\frac{\nu}{2}, \frac{1}{2}\right)
  }{
    F_\nu(t) = 1 - (1/2) I_x(\nu/2, 1/2)
  }

The location-scale version is: \eqn{F(x) = F_\nu((x - \mu)/\sigma)}.

For the non-central distribution (\code{ncp} \eqn{\neq} 0), the cumulative
distribution function is computed numerically via \code{\link[stats:TDist]{stats::pt()}}.

\strong{Moment generating function (m.g.f)}:

Does not exist in closed form. Moments are computed using the formulas
for mean and variance above where available.
}
\examples{
dist <- dist_student_t(df = c(1,2,5), mu = c(0,1,2), sigma = c(1,2,3))

dist
mean(dist)
variance(dist)

generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)

}
\seealso{
\link[stats:TDist]{stats::TDist}
}
