---
myst:
  html_meta:
    "description lang=en": |
      Documentation of the recurring-ical-events library for Python.
---

# Python recurring ICal events

```{eval-rst}
.. image:: https://github.com/niccokunzmann/python-recurring-ical-events/actions/workflows/tests.yml/badge.svg
   :target: https://github.com/niccokunzmann/python-recurring-ical-events/actions/workflows/tests.yml
   :alt: GitHub CI build and test status
.. image:: https://badge.fury.io/py/recurring-ical-events.svg
   :target: https://pypi.python.org/pypi/recurring-ical-events
   :alt: Python Package Version on Pypi
.. image:: https://img.shields.io/pypi/dm/recurring-ical-events.svg
   :target: https://pypi.org/project/recurring-ical-events/#files
   :alt: Downloads from Pypi
.. image:: https://img.shields.io/opencollective/all/open-web-calendar?label=support%20on%20open%20collective
   :target: https://opencollective.com/open-web-calendar/
   :alt: Support on Open Collective
.. image:: https://img.shields.io/github/issues/niccokunzmann/python-recurring-ical-events?logo=github&label=issues%20seek%20funding&color=%230062ff
   :target: https://polar.sh/niccokunzmann/python-recurring-ical-events
   :alt: issues seek funding
```

Query [ICS calendars](https://icalendar.readthedocs.io) for occurrences of events, todos, journal entries and alarms.

ICal has some complexity to it:
Events, TODOs, Journal entries and Alarms can be repeated, removed from the feed and edited later on.
This tool takes care of these complexities.

Let's put our expertise together and build the solution solves ICalendar scheduling for Python!

## User Guide

Information about usage.

```{toctree}
:maxdepth: 2

user-guide/index
user-guide/examples
```


## Community

Information about contributing.

```{toctree}
:maxdepth: 2

community/index
community/media
community/maintenance
```

```{toctree}
:maxdepth: 1

security_policy
```

## Reference

This is reference material for information.

```{toctree}
:maxdepth: 2

reference/api
reference/architecture
reference/compatibility
reference/dependencies
reference/documentation
reference/related-projects
reference/research

```

```{toctree}
:maxdepth: 1

changelog
reference/license
```
