# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
import json
from typing import Any, Callable, IO, Optional, TypeVar, Union, overload

from azure.core import PipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models1
from .._configuration import SearchClientConfiguration
from .._utils.model_base import SdkJSONEncoder, _deserialize, _failsafe_deserialize
from .._utils.serialization import Serializer
from .._utils.utils import ClientMixinABC

JSON = MutableMapping[str, Any]
_Unset: Any = object()
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_search_get_document_count_request(index_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-11-01-preview"))
    accept = _headers.pop("Accept", "application/json;odata.metadata=none")

    # Construct URL
    _url = "/indexes('{indexName}')/docs/$count"
    path_format_arguments = {
        "indexName": _SERIALIZER.url("index_name", index_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_search_search_get_request(  # pylint: disable=too-many-locals,too-many-statements,too-many-branches
    index_name: str,
    *,
    query_source_authorization: Optional[str] = None,
    enable_elevated_read: Optional[bool] = None,
    search_text: Optional[str] = None,
    include_total_result_count: Optional[bool] = None,
    facets: Optional[list[str]] = None,
    filter: Optional[str] = None,
    highlight_fields: Optional[list[str]] = None,
    highlight_post_tag: Optional[str] = None,
    highlight_pre_tag: Optional[str] = None,
    minimum_coverage: Optional[float] = None,
    order_by: Optional[list[str]] = None,
    query_type: Optional[Union[str, _models1.QueryType]] = None,
    scoring_parameters: Optional[list[str]] = None,
    scoring_profile: Optional[str] = None,
    search_fields: Optional[list[str]] = None,
    search_mode: Optional[Union[str, _models1.SearchMode]] = None,
    scoring_statistics: Optional[Union[str, _models1.ScoringStatistics]] = None,
    session_id: Optional[str] = None,
    select: Optional[list[str]] = None,
    skip: Optional[int] = None,
    top: Optional[int] = None,
    semantic_configuration: Optional[str] = None,
    semantic_error_handling: Optional[Union[str, _models1.SemanticErrorMode]] = None,
    semantic_max_wait_in_milliseconds: Optional[int] = None,
    answers: Optional[Union[str, _models1.QueryAnswerType]] = None,
    captions: Optional[Union[str, _models1.QueryCaptionType]] = None,
    semantic_query: Optional[str] = None,
    query_rewrites: Optional[Union[str, _models1.QueryRewritesType]] = None,
    debug: Optional[Union[str, _models1.QueryDebugMode]] = None,
    query_language: Optional[Union[str, _models1.QueryLanguage]] = None,
    speller: Optional[Union[str, _models1.QuerySpellerType]] = None,
    semantic_fields: Optional[list[str]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-11-01-preview"))
    accept = _headers.pop("Accept", "application/json;odata.metadata=none")

    # Construct URL
    _url = "/indexes('{indexName}')/docs"
    path_format_arguments = {
        "indexName": _SERIALIZER.url("index_name", index_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if search_text is not None:
        _params["search"] = _SERIALIZER.query("search_text", search_text, "str")
    if include_total_result_count is not None:
        _params["$count"] = _SERIALIZER.query("include_total_result_count", include_total_result_count, "bool")
    if facets is not None:
        _params["facet"] = [_SERIALIZER.query("facets", q, "str") if q is not None else "" for q in facets]
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if highlight_fields is not None:
        _params["highlight"] = _SERIALIZER.query("highlight_fields", highlight_fields, "[str]", div=",")
    if highlight_post_tag is not None:
        _params["highlightPostTag"] = _SERIALIZER.query("highlight_post_tag", highlight_post_tag, "str")
    if highlight_pre_tag is not None:
        _params["highlightPreTag"] = _SERIALIZER.query("highlight_pre_tag", highlight_pre_tag, "str")
    if minimum_coverage is not None:
        _params["minimumCoverage"] = _SERIALIZER.query("minimum_coverage", minimum_coverage, "float")
    if order_by is not None:
        _params["$orderby"] = _SERIALIZER.query("order_by", order_by, "[str]", div=",")
    if query_type is not None:
        _params["queryType"] = _SERIALIZER.query("query_type", query_type, "str")
    if scoring_parameters is not None:
        _params["scoringParameter"] = [
            _SERIALIZER.query("scoring_parameters", q, "str") if q is not None else "" for q in scoring_parameters
        ]
    if scoring_profile is not None:
        _params["scoringProfile"] = _SERIALIZER.query("scoring_profile", scoring_profile, "str")
    if search_fields is not None:
        _params["searchFields"] = _SERIALIZER.query("search_fields", search_fields, "[str]", div=",")
    if search_mode is not None:
        _params["searchMode"] = _SERIALIZER.query("search_mode", search_mode, "str")
    if scoring_statistics is not None:
        _params["scoringStatistics"] = _SERIALIZER.query("scoring_statistics", scoring_statistics, "str")
    if session_id is not None:
        _params["sessionId"] = _SERIALIZER.query("session_id", session_id, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")
    if skip is not None:
        _params["$skip"] = _SERIALIZER.query("skip", skip, "int")
    if top is not None:
        _params["$top"] = _SERIALIZER.query("top", top, "int")
    if semantic_configuration is not None:
        _params["semanticConfiguration"] = _SERIALIZER.query("semantic_configuration", semantic_configuration, "str")
    if semantic_error_handling is not None:
        _params["semanticErrorHandling"] = _SERIALIZER.query("semantic_error_handling", semantic_error_handling, "str")
    if semantic_max_wait_in_milliseconds is not None:
        _params["semanticMaxWaitInMilliseconds"] = _SERIALIZER.query(
            "semantic_max_wait_in_milliseconds", semantic_max_wait_in_milliseconds, "int"
        )
    if answers is not None:
        _params["answers"] = _SERIALIZER.query("answers", answers, "str")
    if captions is not None:
        _params["captions"] = _SERIALIZER.query("captions", captions, "str")
    if semantic_query is not None:
        _params["semanticQuery"] = _SERIALIZER.query("semantic_query", semantic_query, "str")
    if query_rewrites is not None:
        _params["queryRewrites"] = _SERIALIZER.query("query_rewrites", query_rewrites, "str")
    if debug is not None:
        _params["debug"] = _SERIALIZER.query("debug", debug, "str")
    if query_language is not None:
        _params["queryLanguage"] = _SERIALIZER.query("query_language", query_language, "str")
    if speller is not None:
        _params["speller"] = _SERIALIZER.query("speller", speller, "str")
    if semantic_fields is not None:
        _params["semanticFields"] = _SERIALIZER.query("semantic_fields", semantic_fields, "[str]", div=",")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if query_source_authorization is not None:
        _headers["x-ms-query-source-authorization"] = _SERIALIZER.header(
            "query_source_authorization", query_source_authorization, "str"
        )
    if enable_elevated_read is not None:
        _headers["x-ms-enable-elevated-read"] = _SERIALIZER.header("enable_elevated_read", enable_elevated_read, "bool")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_search_search_post_request(
    index_name: str,
    *,
    query_source_authorization: Optional[str] = None,
    enable_elevated_read: Optional[bool] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-11-01-preview"))
    accept = _headers.pop("Accept", "application/json;odata.metadata=none")

    # Construct URL
    _url = "/indexes('{indexName}')/docs/search.post.search"
    path_format_arguments = {
        "indexName": _SERIALIZER.url("index_name", index_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if query_source_authorization is not None:
        _headers["x-ms-query-source-authorization"] = _SERIALIZER.header(
            "query_source_authorization", query_source_authorization, "str"
        )
    if enable_elevated_read is not None:
        _headers["x-ms-enable-elevated-read"] = _SERIALIZER.header("enable_elevated_read", enable_elevated_read, "bool")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_search_get_document_request(
    key: str,
    index_name: str,
    *,
    query_source_authorization: Optional[str] = None,
    enable_elevated_read: Optional[bool] = None,
    selected_fields: Optional[list[str]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-11-01-preview"))
    accept = _headers.pop("Accept", "application/json;odata.metadata=none")

    # Construct URL
    _url = "/indexes('{indexName}')/docs('{key}')"
    path_format_arguments = {
        "key": _SERIALIZER.url("key", key, "str"),
        "indexName": _SERIALIZER.url("index_name", index_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if selected_fields is not None:
        _params["$select"] = _SERIALIZER.query("selected_fields", selected_fields, "[str]", div=",")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if query_source_authorization is not None:
        _headers["x-ms-query-source-authorization"] = _SERIALIZER.header(
            "query_source_authorization", query_source_authorization, "str"
        )
    if enable_elevated_read is not None:
        _headers["x-ms-enable-elevated-read"] = _SERIALIZER.header("enable_elevated_read", enable_elevated_read, "bool")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_search_suggest_get_request(
    index_name: str,
    *,
    search_text: str,
    suggester_name: str,
    filter: Optional[str] = None,
    use_fuzzy_matching: Optional[bool] = None,
    highlight_post_tag: Optional[str] = None,
    highlight_pre_tag: Optional[str] = None,
    minimum_coverage: Optional[float] = None,
    order_by: Optional[list[str]] = None,
    search_fields: Optional[list[str]] = None,
    select: Optional[list[str]] = None,
    top: Optional[int] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-11-01-preview"))
    accept = _headers.pop("Accept", "application/json;odata.metadata=none")

    # Construct URL
    _url = "/indexes('{indexName}')/docs/search.suggest"
    path_format_arguments = {
        "indexName": _SERIALIZER.url("index_name", index_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    _params["search"] = _SERIALIZER.query("search_text", search_text, "str")
    _params["suggesterName"] = _SERIALIZER.query("suggester_name", suggester_name, "str")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if use_fuzzy_matching is not None:
        _params["fuzzy"] = _SERIALIZER.query("use_fuzzy_matching", use_fuzzy_matching, "bool")
    if highlight_post_tag is not None:
        _params["highlightPostTag"] = _SERIALIZER.query("highlight_post_tag", highlight_post_tag, "str")
    if highlight_pre_tag is not None:
        _params["highlightPreTag"] = _SERIALIZER.query("highlight_pre_tag", highlight_pre_tag, "str")
    if minimum_coverage is not None:
        _params["minimumCoverage"] = _SERIALIZER.query("minimum_coverage", minimum_coverage, "float")
    if order_by is not None:
        _params["$orderby"] = _SERIALIZER.query("order_by", order_by, "[str]", div=",")
    if search_fields is not None:
        _params["searchFields"] = _SERIALIZER.query("search_fields", search_fields, "[str]", div=",")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")
    if top is not None:
        _params["$top"] = _SERIALIZER.query("top", top, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_search_suggest_post_request(index_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-11-01-preview"))
    accept = _headers.pop("Accept", "application/json;odata.metadata=none")

    # Construct URL
    _url = "/indexes('{indexName}')/docs/search.post.suggest"
    path_format_arguments = {
        "indexName": _SERIALIZER.url("index_name", index_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_search_index_request(index_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-11-01-preview"))
    accept = _headers.pop("Accept", "application/json;odata.metadata=none")

    # Construct URL
    _url = "/indexes('{indexName}')/docs/search.index"
    path_format_arguments = {
        "indexName": _SERIALIZER.url("index_name", index_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_search_autocomplete_get_request(
    index_name: str,
    *,
    search_text: str,
    suggester_name: str,
    autocomplete_mode: Optional[Union[str, _models1.AutocompleteMode]] = None,
    filter: Optional[str] = None,
    use_fuzzy_matching: Optional[bool] = None,
    highlight_post_tag: Optional[str] = None,
    highlight_pre_tag: Optional[str] = None,
    minimum_coverage: Optional[float] = None,
    search_fields: Optional[list[str]] = None,
    top: Optional[int] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-11-01-preview"))
    accept = _headers.pop("Accept", "application/json;odata.metadata=none")

    # Construct URL
    _url = "/indexes('{indexName}')/docs/search.autocomplete"
    path_format_arguments = {
        "indexName": _SERIALIZER.url("index_name", index_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    _params["search"] = _SERIALIZER.query("search_text", search_text, "str")
    _params["suggesterName"] = _SERIALIZER.query("suggester_name", suggester_name, "str")
    if autocomplete_mode is not None:
        _params["autocompleteMode"] = _SERIALIZER.query("autocomplete_mode", autocomplete_mode, "str")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if use_fuzzy_matching is not None:
        _params["fuzzy"] = _SERIALIZER.query("use_fuzzy_matching", use_fuzzy_matching, "bool")
    if highlight_post_tag is not None:
        _params["highlightPostTag"] = _SERIALIZER.query("highlight_post_tag", highlight_post_tag, "str")
    if highlight_pre_tag is not None:
        _params["highlightPreTag"] = _SERIALIZER.query("highlight_pre_tag", highlight_pre_tag, "str")
    if minimum_coverage is not None:
        _params["minimumCoverage"] = _SERIALIZER.query("minimum_coverage", minimum_coverage, "float")
    if search_fields is not None:
        _params["searchFields"] = _SERIALIZER.query("search_fields", search_fields, "[str]", div=",")
    if top is not None:
        _params["$top"] = _SERIALIZER.query("top", top, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_search_autocomplete_post_request(index_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-11-01-preview"))
    accept = _headers.pop("Accept", "application/json;odata.metadata=none")

    # Construct URL
    _url = "/indexes('{indexName}')/docs/search.post.autocomplete"
    path_format_arguments = {
        "indexName": _SERIALIZER.url("index_name", index_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class _SearchClientOperationsMixin(
    ClientMixinABC[PipelineClient[HttpRequest, HttpResponse], SearchClientConfiguration]
):

    @distributed_trace
    def get_document_count(self, **kwargs: Any) -> int:
        """Queries the number of documents in the index.

        :return: int
        :rtype: int
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[int] = kwargs.pop("cls", None)

        _request = build_search_get_document_count_request(
            index_name=self._config.index_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models1.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(int, response.text())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def _search_get(  # pylint: disable=too-many-locals
        self,
        *,
        query_source_authorization: Optional[str] = None,
        enable_elevated_read: Optional[bool] = None,
        search_text: Optional[str] = None,
        include_total_result_count: Optional[bool] = None,
        facets: Optional[list[str]] = None,
        filter: Optional[str] = None,
        highlight_fields: Optional[list[str]] = None,
        highlight_post_tag: Optional[str] = None,
        highlight_pre_tag: Optional[str] = None,
        minimum_coverage: Optional[float] = None,
        order_by: Optional[list[str]] = None,
        query_type: Optional[Union[str, _models1.QueryType]] = None,
        scoring_parameters: Optional[list[str]] = None,
        scoring_profile: Optional[str] = None,
        search_fields: Optional[list[str]] = None,
        search_mode: Optional[Union[str, _models1.SearchMode]] = None,
        scoring_statistics: Optional[Union[str, _models1.ScoringStatistics]] = None,
        session_id: Optional[str] = None,
        select: Optional[list[str]] = None,
        skip: Optional[int] = None,
        top: Optional[int] = None,
        semantic_configuration: Optional[str] = None,
        semantic_error_handling: Optional[Union[str, _models1.SemanticErrorMode]] = None,
        semantic_max_wait_in_milliseconds: Optional[int] = None,
        answers: Optional[Union[str, _models1.QueryAnswerType]] = None,
        captions: Optional[Union[str, _models1.QueryCaptionType]] = None,
        semantic_query: Optional[str] = None,
        query_rewrites: Optional[Union[str, _models1.QueryRewritesType]] = None,
        debug: Optional[Union[str, _models1.QueryDebugMode]] = None,
        query_language: Optional[Union[str, _models1.QueryLanguage]] = None,
        speller: Optional[Union[str, _models1.QuerySpellerType]] = None,
        semantic_fields: Optional[list[str]] = None,
        **kwargs: Any
    ) -> _models1.SearchDocumentsResult:
        """Searches for documents in the index.

        :keyword query_source_authorization: Token identifying the user for which the query is being
         executed. This token is used to enforce security restrictions on documents. Default value is
         None.
        :paramtype query_source_authorization: str
        :keyword enable_elevated_read: A value that enables elevated read that bypass document level
         permission checks for the query operation. Default value is None.
        :paramtype enable_elevated_read: bool
        :keyword search_text: A full-text search query expression; Use "*" or omit this parameter to
         match all documents. Default value is None.
        :paramtype search_text: str
        :keyword include_total_result_count: A value that specifies whether to fetch the total count of
         results. Default is false. Setting this value to true may have a performance impact. Note that
         the count returned is an approximation. Default value is None.
        :paramtype include_total_result_count: bool
        :keyword facets: The list of facet expressions to apply to the search query. Each facet
         expression contains a field name, optionally followed by a comma-separated list of name:value
         pairs. Default value is None.
        :paramtype facets: list[str]
        :keyword filter: The OData $filter expression to apply to the search query. Default value is
         None.
        :paramtype filter: str
        :keyword highlight_fields: The list of field names to use for hit highlights. Only searchable
         fields can be used for hit highlighting. Default value is None.
        :paramtype highlight_fields: list[str]
        :keyword highlight_post_tag: A string tag that is appended to hit highlights. Must be set with
         highlightPreTag. Default is &lt;/em&gt;. Default value is None.
        :paramtype highlight_post_tag: str
        :keyword highlight_pre_tag: A string tag that is prepended to hit highlights. Must be set with
         highlightPostTag. Default is &lt;em&gt;. Default value is None.
        :paramtype highlight_pre_tag: str
        :keyword minimum_coverage: A number between 0 and 100 indicating the percentage of the index
         that must be covered by a search query in order for the query to be reported as a success. This
         parameter can be useful for ensuring search availability even for services with only one
         replica. The default is 100. Default value is None.
        :paramtype minimum_coverage: float
        :keyword order_by: The list of OData $orderby expressions by which to sort the results. Each
         expression can be either a field name or a call to either the geo.distance() or the
         search.score() functions. Each expression can be followed by asc to indicate ascending, and
         desc to indicate descending. The default is ascending order. Ties will be broken by the match
         scores of documents. If no OrderBy is specified, the default sort order is descending by
         document match score. There can be at most 32 $orderby clauses. Default value is None.
        :paramtype order_by: list[str]
        :keyword query_type: A value that specifies the syntax of the search query. The default is
         'simple'. Use 'full' if your query uses the Lucene query syntax. Known values are: "simple",
         "full", and "semantic". Default value is None.
        :paramtype query_type: str or ~azure.search.documents.models.QueryType
        :keyword scoring_parameters: The list of parameter values to be used in scoring functions (for
         example, referencePointParameter) using the format name-values. For example, if the scoring
         profile defines a function with a parameter called 'mylocation' the parameter string would be
         "mylocation--122.2,44.8" (without the quotes). Default value is None.
        :paramtype scoring_parameters: list[str]
        :keyword scoring_profile: The name of a scoring profile to evaluate match scores for matching
         documents in order to sort the results. Default value is None.
        :paramtype scoring_profile: str
        :keyword search_fields: The list of field names to which to scope the full-text search. When
         using fielded search (fieldName:searchExpression) in a full Lucene query, the field names of
         each fielded search expression take precedence over any field names listed in this parameter.
         Default value is None.
        :paramtype search_fields: list[str]
        :keyword search_mode: A value that specifies whether any or all of the search terms must be
         matched in order to count the document as a match. Known values are: "any" and "all". Default
         value is None.
        :paramtype search_mode: str or ~azure.search.documents.models.SearchMode
        :keyword scoring_statistics: A value that specifies whether we want to calculate scoring
         statistics (such as document frequency) globally for more consistent scoring, or locally, for
         lower latency. Known values are: "local" and "global". Default value is None.
        :paramtype scoring_statistics: str or ~azure.search.documents.models.ScoringStatistics
        :keyword session_id: A value to be used to create a sticky session, which can help to get more
         consistent results. As long as the same sessionId is used, a best-effort attempt will be made
         to target the same replica set. Be wary that reusing the same sessionID values repeatedly can
         interfere with the load balancing of the requests across replicas and adversely affect the
         performance of the search service. The value used as sessionId cannot start with a '_'
         character. Default value is None.
        :paramtype session_id: str
        :keyword select: The list of fields to retrieve. If unspecified, all fields marked as
         retrievable in the schema are included. Default value is None.
        :paramtype select: list[str]
        :keyword skip: The number of search results to skip. This value cannot be greater than 100,000.
         If you need to scan documents in sequence, but cannot use $skip due to this limitation,
         consider using $orderby on a totally-ordered key and $filter with a range query instead.
         Default value is None.
        :paramtype skip: int
        :keyword top: The number of search results to retrieve. This can be used in conjunction with
         $skip to implement client-side paging of search results. If results are truncated due to
         server-side paging, the response will include a continuation token that can be used to issue
         another Search request for the next page of results. Default value is None.
        :paramtype top: int
        :keyword semantic_configuration: The name of the semantic configuration that lists which fields
         should be used for semantic ranking, captions, highlights, and answers. Default value is None.
        :paramtype semantic_configuration: str
        :keyword semantic_error_handling: Allows the user to choose whether a semantic call should fail
         completely, or to return partial results (default). Known values are: "partial" and "fail".
         Default value is None.
        :paramtype semantic_error_handling: str or ~azure.search.documents.models.SemanticErrorMode
        :keyword semantic_max_wait_in_milliseconds: Allows the user to set an upper bound on the amount
         of time it takes for semantic enrichment to finish processing before the request fails. Default
         value is None.
        :paramtype semantic_max_wait_in_milliseconds: int
        :keyword answers: This parameter is only valid if the query type is ``semantic``. If set, the
         query returns answers extracted from key passages in the highest ranked documents. The number
         of answers returned can be configured by appending the pipe character ``|`` followed by the
         ``count-<number of answers>`` option after the answers parameter value, such as
         ``extractive|count-3``. Default count is 1. The confidence threshold can be configured by
         appending the pipe character ``|`` followed by the ``threshold-<confidence threshold>`` option
         after the answers parameter value, such as ``extractive|threshold-0.9``. Default threshold is
         0.7. The maximum character length of answers can be configured by appending the pipe character
         '|' followed by the 'count-<number of maximum character length>', such as
         'extractive|maxcharlength-600'. Known values are: "none" and "extractive". Default value is
         None.
        :paramtype answers: str or ~azure.search.documents.models.QueryAnswerType
        :keyword captions: This parameter is only valid if the query type is ``semantic``. If set, the
         query returns captions extracted from key passages in the highest ranked documents. When
         Captions is set to ``extractive``, highlighting is enabled by default, and can be configured by
         appending the pipe character ``|`` followed by the ``highlight-<true/false>`` option, such as
         ``extractive|highlight-true``. Defaults to ``None``. The maximum character length of captions
         can be configured by appending the pipe character '|' followed by the 'count-<number of maximum
         character length>', such as 'extractive|maxcharlength-600'. Known values are: "none" and
         "extractive". Default value is None.
        :paramtype captions: str or ~azure.search.documents.models.QueryCaptionType
        :keyword semantic_query: Allows setting a separate search query that will be solely used for
         semantic reranking, semantic captions and semantic answers. Is useful for scenarios where there
         is a need to use different queries between the base retrieval and ranking phase, and the L2
         semantic phase. Default value is None.
        :paramtype semantic_query: str
        :keyword query_rewrites: When QueryRewrites is set to ``generative``, the query terms are sent
         to a generate model which will produce 10 (default) rewrites to help increase the recall of the
         request. The requested count can be configured by appending the pipe character ``|`` followed
         by the ``count-<number of rewrites>`` option, such as ``generative|count-3``. Defaults to
         ``None``. This parameter is only valid if the query type is ``semantic``. Known values are:
         "none" and "generative". Default value is None.
        :paramtype query_rewrites: str or ~azure.search.documents.models.QueryRewritesType
        :keyword debug: Enables a debugging tool that can be used to further explore your search
         results. Known values are: "disabled", "semantic", "vector", "queryRewrites", "innerHits", and
         "all". Default value is None.
        :paramtype debug: str or ~azure.search.documents.models.QueryDebugMode
        :keyword query_language: The language of the query. Known values are: "none", "en-us", "en-gb",
         "en-in", "en-ca", "en-au", "fr-fr", "fr-ca", "de-de", "es-es", "es-mx", "zh-cn", "zh-tw",
         "pt-br", "pt-pt", "it-it", "ja-jp", "ko-kr", "ru-ru", "cs-cz", "nl-be", "nl-nl", "hu-hu",
         "pl-pl", "sv-se", "tr-tr", "hi-in", "ar-sa", "ar-eg", "ar-ma", "ar-kw", "ar-jo", "da-dk",
         "no-no", "bg-bg", "hr-hr", "hr-ba", "ms-my", "ms-bn", "sl-sl", "ta-in", "vi-vn", "el-gr",
         "ro-ro", "is-is", "id-id", "th-th", "lt-lt", "uk-ua", "lv-lv", "et-ee", "ca-es", "fi-fi",
         "sr-ba", "sr-me", "sr-rs", "sk-sk", "nb-no", "hy-am", "bn-in", "eu-es", "gl-es", "gu-in",
         "he-il", "ga-ie", "kn-in", "ml-in", "mr-in", "fa-ae", "pa-in", "te-in", and "ur-pk". Default
         value is None.
        :paramtype query_language: str or ~azure.search.documents.models.QueryLanguage
        :keyword speller: Improve search recall by spell-correcting individual search query terms.
         Known values are: "none" and "lexicon". Default value is None.
        :paramtype speller: str or ~azure.search.documents.models.QuerySpellerType
        :keyword semantic_fields: The list of field names used for semantic ranking. Default value is
         None.
        :paramtype semantic_fields: list[str]
        :return: SearchDocumentsResult. The SearchDocumentsResult is compatible with MutableMapping
        :rtype: ~azure.search.documents.models.SearchDocumentsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models1.SearchDocumentsResult] = kwargs.pop("cls", None)

        _request = build_search_search_get_request(
            index_name=self._config.index_name,
            query_source_authorization=query_source_authorization,
            enable_elevated_read=enable_elevated_read,
            search_text=search_text,
            include_total_result_count=include_total_result_count,
            facets=facets,
            filter=filter,
            highlight_fields=highlight_fields,
            highlight_post_tag=highlight_post_tag,
            highlight_pre_tag=highlight_pre_tag,
            minimum_coverage=minimum_coverage,
            order_by=order_by,
            query_type=query_type,
            scoring_parameters=scoring_parameters,
            scoring_profile=scoring_profile,
            search_fields=search_fields,
            search_mode=search_mode,
            scoring_statistics=scoring_statistics,
            session_id=session_id,
            select=select,
            skip=skip,
            top=top,
            semantic_configuration=semantic_configuration,
            semantic_error_handling=semantic_error_handling,
            semantic_max_wait_in_milliseconds=semantic_max_wait_in_milliseconds,
            answers=answers,
            captions=captions,
            semantic_query=semantic_query,
            query_rewrites=query_rewrites,
            debug=debug,
            query_language=query_language,
            speller=speller,
            semantic_fields=semantic_fields,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 206]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models1.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models1.SearchDocumentsResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def _search_post(  # pylint: disable=too-many-locals
        self,
        *,
        query_source_authorization: Optional[str] = None,
        enable_elevated_read: Optional[bool] = None,
        content_type: str = "application/json",
        include_total_count: Optional[bool] = None,
        facets: Optional[list[str]] = None,
        filter: Optional[str] = None,
        highlight_fields: Optional[list[str]] = None,
        highlight_post_tag: Optional[str] = None,
        highlight_pre_tag: Optional[str] = None,
        minimum_coverage: Optional[float] = None,
        order_by: Optional[list[str]] = None,
        query_type: Optional[Union[str, _models1.QueryType]] = None,
        scoring_statistics: Optional[Union[str, _models1.ScoringStatistics]] = None,
        session_id: Optional[str] = None,
        scoring_parameters: Optional[list[str]] = None,
        scoring_profile: Optional[str] = None,
        debug: Optional[Union[str, _models1.QueryDebugMode]] = None,
        search_text: Optional[str] = None,
        search_fields: Optional[list[str]] = None,
        search_mode: Optional[Union[str, _models1.SearchMode]] = None,
        query_language: Optional[Union[str, _models1.QueryLanguage]] = None,
        query_speller: Optional[Union[str, _models1.QuerySpellerType]] = None,
        select: Optional[list[str]] = None,
        skip: Optional[int] = None,
        top: Optional[int] = None,
        semantic_configuration_name: Optional[str] = None,
        semantic_error_handling: Optional[Union[str, _models1.SemanticErrorMode]] = None,
        semantic_max_wait_in_milliseconds: Optional[int] = None,
        semantic_query: Optional[str] = None,
        answers: Optional[Union[str, _models1.QueryAnswerType]] = None,
        captions: Optional[Union[str, _models1.QueryCaptionType]] = None,
        query_rewrites: Optional[Union[str, _models1.QueryRewritesType]] = None,
        semantic_fields: Optional[list[str]] = None,
        vector_queries: Optional[list[_models1.VectorQuery]] = None,
        vector_filter_mode: Optional[Union[str, _models1.VectorFilterMode]] = None,
        hybrid_search: Optional[_models1.HybridSearch] = None,
        **kwargs: Any
    ) -> _models1.SearchDocumentsResult: ...
    @overload
    def _search_post(
        self,
        body: JSON,
        *,
        query_source_authorization: Optional[str] = None,
        enable_elevated_read: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models1.SearchDocumentsResult: ...
    @overload
    def _search_post(
        self,
        body: IO[bytes],
        *,
        query_source_authorization: Optional[str] = None,
        enable_elevated_read: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models1.SearchDocumentsResult: ...

    @distributed_trace
    def _search_post(  # pylint: disable=too-many-locals
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        query_source_authorization: Optional[str] = None,
        enable_elevated_read: Optional[bool] = None,
        include_total_count: Optional[bool] = None,
        facets: Optional[list[str]] = None,
        filter: Optional[str] = None,
        highlight_fields: Optional[list[str]] = None,
        highlight_post_tag: Optional[str] = None,
        highlight_pre_tag: Optional[str] = None,
        minimum_coverage: Optional[float] = None,
        order_by: Optional[list[str]] = None,
        query_type: Optional[Union[str, _models1.QueryType]] = None,
        scoring_statistics: Optional[Union[str, _models1.ScoringStatistics]] = None,
        session_id: Optional[str] = None,
        scoring_parameters: Optional[list[str]] = None,
        scoring_profile: Optional[str] = None,
        debug: Optional[Union[str, _models1.QueryDebugMode]] = None,
        search_text: Optional[str] = None,
        search_fields: Optional[list[str]] = None,
        search_mode: Optional[Union[str, _models1.SearchMode]] = None,
        query_language: Optional[Union[str, _models1.QueryLanguage]] = None,
        query_speller: Optional[Union[str, _models1.QuerySpellerType]] = None,
        select: Optional[list[str]] = None,
        skip: Optional[int] = None,
        top: Optional[int] = None,
        semantic_configuration_name: Optional[str] = None,
        semantic_error_handling: Optional[Union[str, _models1.SemanticErrorMode]] = None,
        semantic_max_wait_in_milliseconds: Optional[int] = None,
        semantic_query: Optional[str] = None,
        answers: Optional[Union[str, _models1.QueryAnswerType]] = None,
        captions: Optional[Union[str, _models1.QueryCaptionType]] = None,
        query_rewrites: Optional[Union[str, _models1.QueryRewritesType]] = None,
        semantic_fields: Optional[list[str]] = None,
        vector_queries: Optional[list[_models1.VectorQuery]] = None,
        vector_filter_mode: Optional[Union[str, _models1.VectorFilterMode]] = None,
        hybrid_search: Optional[_models1.HybridSearch] = None,
        **kwargs: Any
    ) -> _models1.SearchDocumentsResult:
        """Searches for documents in the index.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword query_source_authorization: Token identifying the user for which the query is being
         executed. This token is used to enforce security restrictions on documents. Default value is
         None.
        :paramtype query_source_authorization: str
        :keyword enable_elevated_read: A value that enables elevated read that bypass document level
         permission checks for the query operation. Default value is None.
        :paramtype enable_elevated_read: bool
        :keyword include_total_count: A value that specifies whether to fetch the total count of
         results. Default is false. Setting this value to true may have a performance impact. Note that
         the count returned is an approximation. Default value is None.
        :paramtype include_total_count: bool
        :keyword facets: The list of facet expressions to apply to the search query. Each facet
         expression contains a field name, optionally followed by a comma-separated list of name:value
         pairs. Default value is None.
        :paramtype facets: list[str]
        :keyword filter: The OData $filter expression to apply to the search query. Default value is
         None.
        :paramtype filter: str
        :keyword highlight_fields: The comma-separated list of field names to use for hit highlights.
         Only searchable fields can be used for hit highlighting. Default value is None.
        :paramtype highlight_fields: list[str]
        :keyword highlight_post_tag: A string tag that is appended to hit highlights. Must be set with
         highlightPreTag. Default is &lt;/em&gt;. Default value is None.
        :paramtype highlight_post_tag: str
        :keyword highlight_pre_tag: A string tag that is prepended to hit highlights. Must be set with
         highlightPostTag. Default is &lt;em&gt;. Default value is None.
        :paramtype highlight_pre_tag: str
        :keyword minimum_coverage: A number between 0 and 100 indicating the percentage of the index
         that must be covered by a search query in order for the query to be reported as a success. This
         parameter can be useful for ensuring search availability even for services with only one
         replica. The default is 100. Default value is None.
        :paramtype minimum_coverage: float
        :keyword order_by: The comma-separated list of OData $orderby expressions by which to sort the
         results. Each expression can be either a field name or a call to either the geo.distance() or
         the search.score() functions. Each expression can be followed by asc to indicate ascending, or
         desc to indicate descending. The default is ascending order. Ties will be broken by the match
         scores of documents. If no $orderby is specified, the default sort order is descending by
         document match score. There can be at most 32 $orderby clauses. Default value is None.
        :paramtype order_by: list[str]
        :keyword query_type: A value that specifies the syntax of the search query. The default is
         'simple'. Use 'full' if your query uses the Lucene query syntax. Known values are: "simple",
         "full", and "semantic". Default value is None.
        :paramtype query_type: str or ~azure.search.documents.models.QueryType
        :keyword scoring_statistics: A value that specifies whether we want to calculate scoring
         statistics (such as document frequency) globally for more consistent scoring, or locally, for
         lower latency. The default is 'local'. Use 'global' to aggregate scoring statistics globally
         before scoring. Using global scoring statistics can increase latency of search queries. Known
         values are: "local" and "global". Default value is None.
        :paramtype scoring_statistics: str or ~azure.search.documents.models.ScoringStatistics
        :keyword session_id: A value to be used to create a sticky session, which can help getting more
         consistent results. As long as the same sessionId is used, a best-effort attempt will be made
         to target the same replica set. Be wary that reusing the same sessionID values repeatedly can
         interfere with the load balancing of the requests across replicas and adversely affect the
         performance of the search service. The value used as sessionId cannot start with a '_'
         character. Default value is None.
        :paramtype session_id: str
        :keyword scoring_parameters: The list of parameter values to be used in scoring functions (for
         example, referencePointParameter) using the format name-values. For example, if the scoring
         profile defines a function with a parameter called 'mylocation' the parameter string would be
         "mylocation--122.2,44.8" (without the quotes). Default value is None.
        :paramtype scoring_parameters: list[str]
        :keyword scoring_profile: The name of a scoring profile to evaluate match scores for matching
         documents in order to sort the results. Default value is None.
        :paramtype scoring_profile: str
        :keyword debug: Enables a debugging tool that can be used to further explore your reranked
         results. Known values are: "disabled", "semantic", "vector", "queryRewrites", "innerHits", and
         "all". Default value is None.
        :paramtype debug: str or ~azure.search.documents.models.QueryDebugMode
        :keyword search_text: A full-text search query expression; Use "*" or omit this parameter to
         match all documents. Default value is None.
        :paramtype search_text: str
        :keyword search_fields: The comma-separated list of field names to which to scope the full-text
         search. When using fielded search (fieldName:searchExpression) in a full Lucene query, the
         field names of each fielded search expression take precedence over any field names listed in
         this parameter. Default value is None.
        :paramtype search_fields: list[str]
        :keyword search_mode: A value that specifies whether any or all of the search terms must be
         matched in order to count the document as a match. Known values are: "any" and "all". Default
         value is None.
        :paramtype search_mode: str or ~azure.search.documents.models.SearchMode
        :keyword query_language: A value that specifies the language of the search query. Known values
         are: "none", "en-us", "en-gb", "en-in", "en-ca", "en-au", "fr-fr", "fr-ca", "de-de", "es-es",
         "es-mx", "zh-cn", "zh-tw", "pt-br", "pt-pt", "it-it", "ja-jp", "ko-kr", "ru-ru", "cs-cz",
         "nl-be", "nl-nl", "hu-hu", "pl-pl", "sv-se", "tr-tr", "hi-in", "ar-sa", "ar-eg", "ar-ma",
         "ar-kw", "ar-jo", "da-dk", "no-no", "bg-bg", "hr-hr", "hr-ba", "ms-my", "ms-bn", "sl-sl",
         "ta-in", "vi-vn", "el-gr", "ro-ro", "is-is", "id-id", "th-th", "lt-lt", "uk-ua", "lv-lv",
         "et-ee", "ca-es", "fi-fi", "sr-ba", "sr-me", "sr-rs", "sk-sk", "nb-no", "hy-am", "bn-in",
         "eu-es", "gl-es", "gu-in", "he-il", "ga-ie", "kn-in", "ml-in", "mr-in", "fa-ae", "pa-in",
         "te-in", and "ur-pk". Default value is None.
        :paramtype query_language: str or ~azure.search.documents.models.QueryLanguage
        :keyword query_speller: A value that specifies the type of the speller to use to spell-correct
         individual search query terms. Known values are: "none" and "lexicon". Default value is None.
        :paramtype query_speller: str or ~azure.search.documents.models.QuerySpellerType
        :keyword select: The comma-separated list of fields to retrieve. If unspecified, all fields
         marked as retrievable in the schema are included. Default value is None.
        :paramtype select: list[str]
        :keyword skip: The number of search results to skip. This value cannot be greater than 100,000.
         If you need to scan documents in sequence, but cannot use skip due to this limitation, consider
         using orderby on a totally-ordered key and filter with a range query instead. Default value is
         None.
        :paramtype skip: int
        :keyword top: The number of search results to retrieve. This can be used in conjunction with
         $skip to implement client-side paging of search results. If results are truncated due to
         server-side paging, the response will include a continuation token that can be used to issue
         another Search request for the next page of results. Default value is None.
        :paramtype top: int
        :keyword semantic_configuration_name: The name of a semantic configuration that will be used
         when processing documents for queries of type semantic. Default value is None.
        :paramtype semantic_configuration_name: str
        :keyword semantic_error_handling: Allows the user to choose whether a semantic call should fail
         completely (default / current behavior), or to return partial results. Known values are:
         "partial" and "fail". Default value is None.
        :paramtype semantic_error_handling: str or ~azure.search.documents.models.SemanticErrorMode
        :keyword semantic_max_wait_in_milliseconds: Allows the user to set an upper bound on the amount
         of time it takes for semantic enrichment to finish processing before the request fails. Default
         value is None.
        :paramtype semantic_max_wait_in_milliseconds: int
        :keyword semantic_query: Allows setting a separate search query that will be solely used for
         semantic reranking, semantic captions and semantic answers. Is useful for scenarios where there
         is a need to use different queries between the base retrieval and ranking phase, and the L2
         semantic phase. Default value is None.
        :paramtype semantic_query: str
        :keyword answers: A value that specifies whether answers should be returned as part of the
         search response. Known values are: "none" and "extractive". Default value is None.
        :paramtype answers: str or ~azure.search.documents.models.QueryAnswerType
        :keyword captions: A value that specifies whether captions should be returned as part of the
         search response. Known values are: "none" and "extractive". Default value is None.
        :paramtype captions: str or ~azure.search.documents.models.QueryCaptionType
        :keyword query_rewrites: A value that specifies whether query rewrites should be generated to
         augment the search query. Known values are: "none" and "generative". Default value is None.
        :paramtype query_rewrites: str or ~azure.search.documents.models.QueryRewritesType
        :keyword semantic_fields: The comma-separated list of field names used for semantic ranking.
         Default value is None.
        :paramtype semantic_fields: list[str]
        :keyword vector_queries: The query parameters for vector and hybrid search queries. Default
         value is None.
        :paramtype vector_queries: list[~azure.search.documents.models.VectorQuery]
        :keyword vector_filter_mode: Determines whether or not filters are applied before or after the
         vector search is performed. Default is 'preFilter' for new indexes. Known values are:
         "postFilter", "preFilter", and "strictPostFilter". Default value is None.
        :paramtype vector_filter_mode: str or ~azure.search.documents.models.VectorFilterMode
        :keyword hybrid_search: The query parameters to configure hybrid search behaviors. Default
         value is None.
        :paramtype hybrid_search: ~azure.search.documents.models.HybridSearch
        :return: SearchDocumentsResult. The SearchDocumentsResult is compatible with MutableMapping
        :rtype: ~azure.search.documents.models.SearchDocumentsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models1.SearchDocumentsResult] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {
                "answers": answers,
                "captions": captions,
                "count": include_total_count,
                "debug": debug,
                "facets": facets,
                "filter": filter,
                "highlight": highlight_fields,
                "highlightPostTag": highlight_post_tag,
                "highlightPreTag": highlight_pre_tag,
                "hybridSearch": hybrid_search,
                "minimumCoverage": minimum_coverage,
                "orderby": order_by,
                "queryLanguage": query_language,
                "queryRewrites": query_rewrites,
                "queryType": query_type,
                "scoringParameters": scoring_parameters,
                "scoringProfile": scoring_profile,
                "scoringStatistics": scoring_statistics,
                "search": search_text,
                "searchFields": search_fields,
                "searchMode": search_mode,
                "select": select,
                "semanticConfiguration": semantic_configuration_name,
                "semanticErrorHandling": semantic_error_handling,
                "semanticFields": semantic_fields,
                "semanticMaxWaitInMilliseconds": semantic_max_wait_in_milliseconds,
                "semanticQuery": semantic_query,
                "sessionId": session_id,
                "skip": skip,
                "speller": query_speller,
                "top": top,
                "vectorFilterMode": vector_filter_mode,
                "vectorQueries": vector_queries,
            }
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_search_search_post_request(
            index_name=self._config.index_name,
            query_source_authorization=query_source_authorization,
            enable_elevated_read=enable_elevated_read,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 206]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models1.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models1.SearchDocumentsResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_document(
        self,
        key: str,
        *,
        query_source_authorization: Optional[str] = None,
        enable_elevated_read: Optional[bool] = None,
        selected_fields: Optional[list[str]] = None,
        **kwargs: Any
    ) -> _models1.LookupDocument:
        """Retrieves a document from the index.

        :param key: The key of the document to retrieve. Required.
        :type key: str
        :keyword query_source_authorization: Token identifying the user for which the query is being
         executed. This token is used to enforce security restrictions on documents. Default value is
         None.
        :paramtype query_source_authorization: str
        :keyword enable_elevated_read: A value that enables elevated read that bypass document level
         permission checks for the query operation. Default value is None.
        :paramtype enable_elevated_read: bool
        :keyword selected_fields: List of field names to retrieve for the document; Any field not
         retrieved will be missing from the returned document. Default value is None.
        :paramtype selected_fields: list[str]
        :return: LookupDocument. The LookupDocument is compatible with MutableMapping
        :rtype: ~azure.search.documents.models.LookupDocument
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models1.LookupDocument] = kwargs.pop("cls", None)

        _request = build_search_get_document_request(
            key=key,
            index_name=self._config.index_name,
            query_source_authorization=query_source_authorization,
            enable_elevated_read=enable_elevated_read,
            selected_fields=selected_fields,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models1.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models1.LookupDocument, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def _suggest_get(
        self,
        *,
        search_text: str,
        suggester_name: str,
        filter: Optional[str] = None,
        use_fuzzy_matching: Optional[bool] = None,
        highlight_post_tag: Optional[str] = None,
        highlight_pre_tag: Optional[str] = None,
        minimum_coverage: Optional[float] = None,
        order_by: Optional[list[str]] = None,
        search_fields: Optional[list[str]] = None,
        select: Optional[list[str]] = None,
        top: Optional[int] = None,
        **kwargs: Any
    ) -> _models1._models.SuggestDocumentsResult:
        """Suggests documents in the index that match the given partial query text.

        :keyword search_text: The search text to use to suggest documents. Must be at least 1
         character, and no more than 100 characters. Required.
        :paramtype search_text: str
        :keyword suggester_name: The name of the suggester as specified in the suggesters collection
         that's part of the index definition. Required.
        :paramtype suggester_name: str
        :keyword filter: An OData expression that filters the documents considered for suggestions.
         Default value is None.
        :paramtype filter: str
        :keyword use_fuzzy_matching: A value indicating whether to use fuzzy matching for the
         suggestions query. Default is false. When set to true, the query will find terms even if
         there's a substituted or missing character in the search text. While this provides a better
         experience in some scenarios, it comes at a performance cost as fuzzy suggestions queries are
         slower and consume more resources. Default value is None.
        :paramtype use_fuzzy_matching: bool
        :keyword highlight_post_tag: A string tag that is appended to hit highlights. Must be set with
         highlightPreTag. If omitted, hit highlighting of suggestions is disabled. Default value is
         None.
        :paramtype highlight_post_tag: str
        :keyword highlight_pre_tag: A string tag that is prepended to hit highlights. Must be set with
         highlightPostTag. If omitted, hit highlighting of suggestions is disabled. Default value is
         None.
        :paramtype highlight_pre_tag: str
        :keyword minimum_coverage: A number between 0 and 100 indicating the percentage of the index
         that must be covered by a suggestions query in order for the query to be reported as a success.
         This parameter can be useful for ensuring search availability even for services with only one
         replica. The default is 80. Default value is None.
        :paramtype minimum_coverage: float
        :keyword order_by: The list of OData $orderby expressions by which to sort the results. Each
         expression can be either a field name or a call to either the geo.distance() or the
         search.score() functions. Each expression can be followed by asc to indicate ascending, or desc
         to indicate descending. The default is ascending order. Ties will be broken by the match scores
         of documents. If no $orderby is specified, the default sort order is descending by document
         match score. There can be at most 32 $orderby clauses. Default value is None.
        :paramtype order_by: list[str]
        :keyword search_fields: The list of field names to search for the specified search text. Target
         fields must be included in the specified suggester. Default value is None.
        :paramtype search_fields: list[str]
        :keyword select: The list of fields to retrieve. If unspecified, only the key field will be
         included in the results. Default value is None.
        :paramtype select: list[str]
        :keyword top: The number of suggestions to retrieve. The value must be a number between 1 and
         100. The default is 5. Default value is None.
        :paramtype top: int
        :return: SuggestDocumentsResult. The SuggestDocumentsResult is compatible with MutableMapping
        :rtype: ~azure.search.documents.models._models.SuggestDocumentsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models1._models.SuggestDocumentsResult] = kwargs.pop("cls", None)

        _request = build_search_suggest_get_request(
            index_name=self._config.index_name,
            search_text=search_text,
            suggester_name=suggester_name,
            filter=filter,
            use_fuzzy_matching=use_fuzzy_matching,
            highlight_post_tag=highlight_post_tag,
            highlight_pre_tag=highlight_pre_tag,
            minimum_coverage=minimum_coverage,
            order_by=order_by,
            search_fields=search_fields,
            select=select,
            top=top,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models1.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(
                _models1._models.SuggestDocumentsResult, response.json()  # pylint: disable=protected-access
            )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def _suggest_post(
        self,
        *,
        search_text: str,
        suggester_name: str,
        content_type: str = "application/json",
        filter: Optional[str] = None,
        use_fuzzy_matching: Optional[bool] = None,
        highlight_post_tag: Optional[str] = None,
        highlight_pre_tag: Optional[str] = None,
        minimum_coverage: Optional[float] = None,
        order_by: Optional[list[str]] = None,
        search_fields: Optional[list[str]] = None,
        select: Optional[list[str]] = None,
        top: Optional[int] = None,
        **kwargs: Any
    ) -> _models1._models.SuggestDocumentsResult: ...
    @overload
    def _suggest_post(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models1._models.SuggestDocumentsResult: ...
    @overload
    def _suggest_post(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models1._models.SuggestDocumentsResult: ...

    @distributed_trace
    def _suggest_post(  # pylint: disable=too-many-locals
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        search_text: str = _Unset,
        suggester_name: str = _Unset,
        filter: Optional[str] = None,
        use_fuzzy_matching: Optional[bool] = None,
        highlight_post_tag: Optional[str] = None,
        highlight_pre_tag: Optional[str] = None,
        minimum_coverage: Optional[float] = None,
        order_by: Optional[list[str]] = None,
        search_fields: Optional[list[str]] = None,
        select: Optional[list[str]] = None,
        top: Optional[int] = None,
        **kwargs: Any
    ) -> _models1._models.SuggestDocumentsResult:
        """Suggests documents in the index that match the given partial query text.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword search_text: The search text to use to suggest documents. Must be at least 1
         character, and no more than 100 characters. Required.
        :paramtype search_text: str
        :keyword suggester_name: The name of the suggester as specified in the suggesters collection
         that's part of the index definition. Required.
        :paramtype suggester_name: str
        :keyword filter: An OData expression that filters the documents considered for suggestions.
         Default value is None.
        :paramtype filter: str
        :keyword use_fuzzy_matching: A value indicating whether to use fuzzy matching for the
         suggestion query. Default is false. When set to true, the query will find suggestions even if
         there's a substituted or missing character in the search text. While this provides a better
         experience in some scenarios, it comes at a performance cost as fuzzy suggestion searches are
         slower and consume more resources. Default value is None.
        :paramtype use_fuzzy_matching: bool
        :keyword highlight_post_tag: A string tag that is appended to hit highlights. Must be set with
         highlightPreTag. If omitted, hit highlighting of suggestions is disabled. Default value is
         None.
        :paramtype highlight_post_tag: str
        :keyword highlight_pre_tag: A string tag that is prepended to hit highlights. Must be set with
         highlightPostTag. If omitted, hit highlighting of suggestions is disabled. Default value is
         None.
        :paramtype highlight_pre_tag: str
        :keyword minimum_coverage: A number between 0 and 100 indicating the percentage of the index
         that must be covered by a suggestion query in order for the query to be reported as a success.
         This parameter can be useful for ensuring search availability even for services with only one
         replica. The default is 80. Default value is None.
        :paramtype minimum_coverage: float
        :keyword order_by: The comma-separated list of OData $orderby expressions by which to sort the
         results. Each expression can be either a field name or a call to either the geo.distance() or
         the search.score() functions. Each expression can be followed by asc to indicate ascending, or
         desc to indicate descending. The default is ascending order. Ties will be broken by the match
         scores of documents. If no $orderby is specified, the default sort order is descending by
         document match score. There can be at most 32 $orderby clauses. Default value is None.
        :paramtype order_by: list[str]
        :keyword search_fields: The comma-separated list of field names to search for the specified
         search text. Target fields must be included in the specified suggester. Default value is None.
        :paramtype search_fields: list[str]
        :keyword select: The comma-separated list of fields to retrieve. If unspecified, only the key
         field will be included in the results. Default value is None.
        :paramtype select: list[str]
        :keyword top: The number of suggestions to retrieve. This must be a value between 1 and 100.
         The default is 5. Default value is None.
        :paramtype top: int
        :return: SuggestDocumentsResult. The SuggestDocumentsResult is compatible with MutableMapping
        :rtype: ~azure.search.documents.models._models.SuggestDocumentsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models1._models.SuggestDocumentsResult] = kwargs.pop("cls", None)

        if body is _Unset:
            if search_text is _Unset:
                raise TypeError("missing required argument: search_text")
            if suggester_name is _Unset:
                raise TypeError("missing required argument: suggester_name")
            body = {
                "filter": filter,
                "fuzzy": use_fuzzy_matching,
                "highlightPostTag": highlight_post_tag,
                "highlightPreTag": highlight_pre_tag,
                "minimumCoverage": minimum_coverage,
                "orderby": order_by,
                "search": search_text,
                "searchFields": search_fields,
                "select": select,
                "suggesterName": suggester_name,
                "top": top,
            }
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_search_suggest_post_request(
            index_name=self._config.index_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models1.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(
                _models1._models.SuggestDocumentsResult, response.json()  # pylint: disable=protected-access
            )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def _index(
        self, batch: _models1.IndexDocumentsBatch, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models1._models.IndexDocumentsResult: ...
    @overload
    def _index(
        self, batch: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models1._models.IndexDocumentsResult: ...
    @overload
    def _index(
        self, batch: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models1._models.IndexDocumentsResult: ...

    @distributed_trace
    def _index(
        self, batch: Union[_models1.IndexDocumentsBatch, JSON, IO[bytes]], **kwargs: Any
    ) -> _models1._models.IndexDocumentsResult:
        """Sends a batch of document write actions to the index.

        :param batch: The batch of index actions. Is one of the following types: IndexDocumentsBatch,
         JSON, IO[bytes] Required.
        :type batch: ~azure.search.documents.models.IndexDocumentsBatch or JSON or IO[bytes]
        :return: IndexDocumentsResult. The IndexDocumentsResult is compatible with MutableMapping
        :rtype: ~azure.search.documents.models._models.IndexDocumentsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models1._models.IndexDocumentsResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(batch, (IOBase, bytes)):
            _content = batch
        else:
            _content = json.dumps(batch, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_search_index_request(
            index_name=self._config.index_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 207]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models1.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(
                _models1._models.IndexDocumentsResult, response.json()  # pylint: disable=protected-access
            )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def _autocomplete_get(
        self,
        *,
        search_text: str,
        suggester_name: str,
        autocomplete_mode: Optional[Union[str, _models1.AutocompleteMode]] = None,
        filter: Optional[str] = None,
        use_fuzzy_matching: Optional[bool] = None,
        highlight_post_tag: Optional[str] = None,
        highlight_pre_tag: Optional[str] = None,
        minimum_coverage: Optional[float] = None,
        search_fields: Optional[list[str]] = None,
        top: Optional[int] = None,
        **kwargs: Any
    ) -> _models1._models.AutocompleteResult:
        """Autocompletes incomplete query terms based on input text and matching terms in the index.

        :keyword search_text: The incomplete term which should be auto-completed. Required.
        :paramtype search_text: str
        :keyword suggester_name: The name of the suggester as specified in the suggesters collection
         that's part of the index definition. Required.
        :paramtype suggester_name: str
        :keyword autocomplete_mode: Specifies the mode for Autocomplete. The default is 'oneTerm'. Use
         'twoTerms' to get shingles and 'oneTermWithContext' to use the current context while producing
         auto-completed terms. Known values are: "oneTerm", "twoTerms", and "oneTermWithContext".
         Default value is None.
        :paramtype autocomplete_mode: str or ~azure.search.documents.models.AutocompleteMode
        :keyword filter: An OData expression that filters the documents used to produce completed terms
         for the Autocomplete result. Default value is None.
        :paramtype filter: str
        :keyword use_fuzzy_matching: A value indicating whether to use fuzzy matching for the
         autocomplete query. Default is false. When set to true, the query will find terms even if
         there's a substituted or missing character in the search text. While this provides a better
         experience in some scenarios, it comes at a performance cost as fuzzy autocomplete queries are
         slower and consume more resources. Default value is None.
        :paramtype use_fuzzy_matching: bool
        :keyword highlight_post_tag: A string tag that is appended to hit highlights. Must be set with
         highlightPreTag. If omitted, hit highlighting is disabled. Default value is None.
        :paramtype highlight_post_tag: str
        :keyword highlight_pre_tag: A string tag that is prepended to hit highlights. Must be set with
         highlightPostTag. If omitted, hit highlighting is disabled. Default value is None.
        :paramtype highlight_pre_tag: str
        :keyword minimum_coverage: A number between 0 and 100 indicating the percentage of the index
         that must be covered by an autocomplete query in order for the query to be reported as a
         success. This parameter can be useful for ensuring search availability even for services with
         only one replica. The default is 80. Default value is None.
        :paramtype minimum_coverage: float
        :keyword search_fields: The list of field names to consider when querying for auto-completed
         terms. Target fields must be included in the specified suggester. Default value is None.
        :paramtype search_fields: list[str]
        :keyword top: The number of auto-completed terms to retrieve. This must be a value between 1
         and 100. The default is 5. Default value is None.
        :paramtype top: int
        :return: AutocompleteResult. The AutocompleteResult is compatible with MutableMapping
        :rtype: ~azure.search.documents.models._models.AutocompleteResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models1._models.AutocompleteResult] = kwargs.pop("cls", None)

        _request = build_search_autocomplete_get_request(
            index_name=self._config.index_name,
            search_text=search_text,
            suggester_name=suggester_name,
            autocomplete_mode=autocomplete_mode,
            filter=filter,
            use_fuzzy_matching=use_fuzzy_matching,
            highlight_post_tag=highlight_post_tag,
            highlight_pre_tag=highlight_pre_tag,
            minimum_coverage=minimum_coverage,
            search_fields=search_fields,
            top=top,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models1.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(
                _models1._models.AutocompleteResult, response.json()  # pylint: disable=protected-access
            )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def _autocomplete_post(
        self,
        *,
        search_text: str,
        suggester_name: str,
        content_type: str = "application/json",
        autocomplete_mode: Optional[Union[str, _models1.AutocompleteMode]] = None,
        filter: Optional[str] = None,
        use_fuzzy_matching: Optional[bool] = None,
        highlight_post_tag: Optional[str] = None,
        highlight_pre_tag: Optional[str] = None,
        minimum_coverage: Optional[float] = None,
        search_fields: Optional[list[str]] = None,
        top: Optional[int] = None,
        **kwargs: Any
    ) -> _models1._models.AutocompleteResult: ...
    @overload
    def _autocomplete_post(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models1._models.AutocompleteResult: ...
    @overload
    def _autocomplete_post(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models1._models.AutocompleteResult: ...

    @distributed_trace
    def _autocomplete_post(  # pylint: disable=too-many-locals
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        search_text: str = _Unset,
        suggester_name: str = _Unset,
        autocomplete_mode: Optional[Union[str, _models1.AutocompleteMode]] = None,
        filter: Optional[str] = None,
        use_fuzzy_matching: Optional[bool] = None,
        highlight_post_tag: Optional[str] = None,
        highlight_pre_tag: Optional[str] = None,
        minimum_coverage: Optional[float] = None,
        search_fields: Optional[list[str]] = None,
        top: Optional[int] = None,
        **kwargs: Any
    ) -> _models1._models.AutocompleteResult:
        """Autocompletes incomplete query terms based on input text and matching terms in the index.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword search_text: The search text on which to base autocomplete results. Required.
        :paramtype search_text: str
        :keyword suggester_name: The name of the suggester as specified in the suggesters collection
         that's part of the index definition. Required.
        :paramtype suggester_name: str
        :keyword autocomplete_mode: Specifies the mode for Autocomplete. The default is 'oneTerm'. Use
         'twoTerms' to get shingles and 'oneTermWithContext' to use the current context while producing
         auto-completed terms. Known values are: "oneTerm", "twoTerms", and "oneTermWithContext".
         Default value is None.
        :paramtype autocomplete_mode: str or ~azure.search.documents.models.AutocompleteMode
        :keyword filter: An OData expression that filters the documents used to produce completed terms
         for the Autocomplete result. Default value is None.
        :paramtype filter: str
        :keyword use_fuzzy_matching: A value indicating whether to use fuzzy matching for the
         autocomplete query. Default is false. When set to true, the query will autocomplete terms even
         if there's a substituted or missing character in the search text. While this provides a better
         experience in some scenarios, it comes at a performance cost as fuzzy autocomplete queries are
         slower and consume more resources. Default value is None.
        :paramtype use_fuzzy_matching: bool
        :keyword highlight_post_tag: A string tag that is appended to hit highlights. Must be set with
         highlightPreTag. If omitted, hit highlighting is disabled. Default value is None.
        :paramtype highlight_post_tag: str
        :keyword highlight_pre_tag: A string tag that is prepended to hit highlights. Must be set with
         highlightPostTag. If omitted, hit highlighting is disabled. Default value is None.
        :paramtype highlight_pre_tag: str
        :keyword minimum_coverage: A number between 0 and 100 indicating the percentage of the index
         that must be covered by an autocomplete query in order for the query to be reported as a
         success. This parameter can be useful for ensuring search availability even for services with
         only one replica. The default is 80. Default value is None.
        :paramtype minimum_coverage: float
        :keyword search_fields: The comma-separated list of field names to consider when querying for
         auto-completed terms. Target fields must be included in the specified suggester. Default value
         is None.
        :paramtype search_fields: list[str]
        :keyword top: The number of auto-completed terms to retrieve. This must be a value between 1
         and 100. The default is 5. Default value is None.
        :paramtype top: int
        :return: AutocompleteResult. The AutocompleteResult is compatible with MutableMapping
        :rtype: ~azure.search.documents.models._models.AutocompleteResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models1._models.AutocompleteResult] = kwargs.pop("cls", None)

        if body is _Unset:
            if search_text is _Unset:
                raise TypeError("missing required argument: search_text")
            if suggester_name is _Unset:
                raise TypeError("missing required argument: suggester_name")
            body = {
                "autocompleteMode": autocomplete_mode,
                "filter": filter,
                "fuzzy": use_fuzzy_matching,
                "highlightPostTag": highlight_post_tag,
                "highlightPreTag": highlight_pre_tag,
                "minimumCoverage": minimum_coverage,
                "search": search_text,
                "searchFields": search_fields,
                "suggesterName": suggester_name,
                "top": top,
            }
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_search_autocomplete_post_request(
            index_name=self._config.index_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models1.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(
                _models1._models.AutocompleteResult, response.json()  # pylint: disable=protected-access
            )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
