# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping  # pylint: disable=import-error
from io import IOBase
import json
from typing import Any, AsyncIterator, Callable, IO, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core import AsyncPipelineClient
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.polling.async_base_polling import AsyncLROBasePolling
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._utils.model_base import Model as _Model, SdkJSONEncoder, _deserialize, _deserialize_xml  # pylint: disable=unused-import
from ..._utils.serialization import Deserializer, Serializer
from ..._utils.utils import prepare_multipart_form_data
from ...operations._operations import (
    build_data_create_static_image_request,
    build_data_crop_geo_json_request,
    build_data_crop_geo_json_with_dimensions_request,
    build_data_get_asset_statistics_request,
    build_data_get_bounds_request,
    build_data_get_class_map_legend_request,
    build_data_get_geo_json_statistics_request,
    build_data_get_info_geo_json_request,
    build_data_get_interval_legend_request,
    build_data_get_item_asset_details_request,
    build_data_get_legend_request,
    build_data_get_mosaics_assets_for_point_request,
    build_data_get_mosaics_assets_for_tile_request,
    build_data_get_mosaics_search_info_request,
    build_data_get_mosaics_tile_json_request,
    build_data_get_mosaics_tile_request,
    build_data_get_mosaics_wmts_capabilities_request,
    build_data_get_part_request,
    build_data_get_part_with_dimensions_request,
    build_data_get_point_request,
    build_data_get_preview_request,
    build_data_get_preview_with_format_request,
    build_data_get_static_image_request,
    build_data_get_tile_json_request,
    build_data_get_tile_matrix_definitions_request,
    build_data_get_tile_request,
    build_data_get_wmts_capabilities_request,
    build_data_list_available_assets_request,
    build_data_list_statistics_request,
    build_data_list_tile_matrices_request,
    build_data_register_mosaics_search_request,
    build_ingestion_cancel_all_operations_request,
    build_ingestion_cancel_operation_request,
    build_ingestion_create_request,
    build_ingestion_create_run_request,
    build_ingestion_create_source_request,
    build_ingestion_delete_request,
    build_ingestion_delete_source_request,
    build_ingestion_get_operation_request,
    build_ingestion_get_request,
    build_ingestion_get_run_request,
    build_ingestion_get_source_request,
    build_ingestion_list_managed_identities_request,
    build_ingestion_list_operations_request,
    build_ingestion_list_request,
    build_ingestion_list_runs_request,
    build_ingestion_list_sources_request,
    build_ingestion_replace_source_request,
    build_ingestion_update_request,
    build_shared_access_signature_get_sign_request,
    build_shared_access_signature_get_token_request,
    build_shared_access_signature_revoke_token_request,
    build_stac_add_mosaic_request,
    build_stac_create_collection_asset_request,
    build_stac_create_collection_request,
    build_stac_create_item_request,
    build_stac_create_or_replace_collection_request,
    build_stac_create_or_replace_item_request,
    build_stac_create_queryables_request,
    build_stac_create_render_option_request,
    build_stac_delete_collection_asset_request,
    build_stac_delete_collection_request,
    build_stac_delete_item_request,
    build_stac_delete_mosaic_request,
    build_stac_delete_queryable_request,
    build_stac_delete_render_option_request,
    build_stac_get_collection_configuration_request,
    build_stac_get_collection_queryables_request,
    build_stac_get_collection_request,
    build_stac_get_collection_thumbnail_request,
    build_stac_get_collections_request,
    build_stac_get_conformance_class_request,
    build_stac_get_item_collection_request,
    build_stac_get_item_request,
    build_stac_get_landing_page_request,
    build_stac_get_mosaic_request,
    build_stac_get_partition_type_request,
    build_stac_get_render_option_request,
    build_stac_get_tile_settings_request,
    build_stac_list_mosaics_request,
    build_stac_list_queryables_request,
    build_stac_list_render_options_request,
    build_stac_replace_collection_asset_request,
    build_stac_replace_mosaic_request,
    build_stac_replace_partition_type_request,
    build_stac_replace_queryable_request,
    build_stac_replace_render_option_request,
    build_stac_replace_tile_settings_request,
    build_stac_search_request,
    build_stac_update_item_request,
)
from .._configuration import PlanetaryComputerProClientConfiguration

JSON = MutableMapping[str, Any]
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, dict[str, Any]], Any]]
_Unset: Any = object()
List = list


class IngestionOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.planetarycomputer.aio.PlanetaryComputerProClient`'s
        :attr:`ingestion` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: PlanetaryComputerProClientConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def cancel_operation(self, operation_id: str, **kwargs: Any) -> None:
        """Cancel a running operation of a geo-catalog collection.

        :param operation_id: Operation id. Required.
        :type operation_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_ingestion_cancel_operation_request(
            operation_id=operation_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def cancel_all_operations(self, **kwargs: Any) -> None:
        """Cancel all running operations of a geo-catalog collection.

        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_ingestion_cancel_all_operations_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_operation(self, operation_id: str, **kwargs: Any) -> _models.Operation:
        """Get an operation of a geo-catalog collection.

        :param operation_id: Operation id. Required.
        :type operation_id: str
        :return: Operation. The Operation is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.Operation
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.Operation] = kwargs.pop("cls", None)

        _request = build_ingestion_get_operation_request(
            operation_id=operation_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Operation, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_operations(
        self,
        *,
        top: Optional[int] = None,
        skip: Optional[int] = None,
        collection_id: Optional[str] = None,
        status: Optional[Union[str, _models.OperationStatus]] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.Operation"]:
        """Get operations of a geo-catalog collection.

        :keyword top: The number of items to return. Default value is None.
        :paramtype top: int
        :keyword skip: The number of items to skip. Default value is None.
        :paramtype skip: int
        :keyword collection_id: Operation id used to filter the results. Default value is None.
        :paramtype collection_id: str
        :keyword status: Operation status used to filter the results. Known values are: "Pending",
         "Running", "Succeeded", "Canceled", "Canceling", and "Failed". Default value is None.
        :paramtype status: str or ~azure.planetarycomputer.models.OperationStatus
        :return: An iterator like instance of Operation
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.planetarycomputer.models.Operation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.Operation]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_ingestion_list_operations_request(
                    top=top,
                    skip=skip,
                    collection_id=collection_id,
                    status=status,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.Operation], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def create_run(self, collection_id: str, ingestion_id: str, **kwargs: Any) -> _models.IngestionRun:
        """Create a new run of an ingestion.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param ingestion_id: Ingestion id. Required.
        :type ingestion_id: str
        :return: IngestionRun. The IngestionRun is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.IngestionRun
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.IngestionRun] = kwargs.pop("cls", None)

        _request = build_ingestion_create_run_request(
            collection_id=collection_id,
            ingestion_id=ingestion_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["location"] = self._deserialize("str", response.headers.get("location"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.IngestionRun, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_run(self, collection_id: str, ingestion_id: str, run_id: str, **kwargs: Any) -> _models.IngestionRun:
        """Get a run of an ingestion.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param ingestion_id: Ingestion id. Required.
        :type ingestion_id: str
        :param run_id: Run id. Required.
        :type run_id: str
        :return: IngestionRun. The IngestionRun is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.IngestionRun
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.IngestionRun] = kwargs.pop("cls", None)

        _request = build_ingestion_get_run_request(
            collection_id=collection_id,
            ingestion_id=ingestion_id,
            run_id=run_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.IngestionRun, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_runs(
        self,
        collection_id: str,
        ingestion_id: str,
        *,
        top: Optional[int] = None,
        skip: Optional[int] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.IngestionRun"]:
        """Get the runs of an ingestion.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param ingestion_id: Ingestion id. Required.
        :type ingestion_id: str
        :keyword top: The number of items to return. Default value is None.
        :paramtype top: int
        :keyword skip: The number of items to skip. Default value is None.
        :paramtype skip: int
        :return: An iterator like instance of IngestionRun
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.planetarycomputer.models.IngestionRun]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.IngestionRun]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_ingestion_list_runs_request(
                    collection_id=collection_id,
                    ingestion_id=ingestion_id,
                    top=top,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.IngestionRun], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def create(
        self,
        collection_id: str,
        body: _models.IngestionDefinition,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.IngestionDefinition:
        """Create a new ingestion.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param body: Definition of the ingestion. Required.
        :type body: ~azure.planetarycomputer.models.IngestionDefinition
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: IngestionDefinition. The IngestionDefinition is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.IngestionDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self, collection_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.IngestionDefinition:
        """Create a new ingestion.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param body: Definition of the ingestion. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: IngestionDefinition. The IngestionDefinition is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.IngestionDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self, collection_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.IngestionDefinition:
        """Create a new ingestion.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param body: Definition of the ingestion. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: IngestionDefinition. The IngestionDefinition is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.IngestionDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create(
        self, collection_id: str, body: Union[_models.IngestionDefinition, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.IngestionDefinition:
        """Create a new ingestion.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param body: Definition of the ingestion. Is one of the following types: IngestionDefinition,
         JSON, IO[bytes] Required.
        :type body: ~azure.planetarycomputer.models.IngestionDefinition or JSON or IO[bytes]
        :return: IngestionDefinition. The IngestionDefinition is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.IngestionDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.IngestionDefinition] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_ingestion_create_request(
            collection_id=collection_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["location"] = self._deserialize("str", response.headers.get("location"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.IngestionDefinition, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    async def _delete_initial(self, collection_id: str, ingestion_id: str, **kwargs: Any) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_ingestion_delete_request(
            collection_id=collection_id,
            ingestion_id=ingestion_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["location"] = self._deserialize("str", response.headers.get("location"))
        response_headers["operation-location"] = self._deserialize("str", response.headers.get("operation-location"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_delete(self, collection_id: str, ingestion_id: str, **kwargs: Any) -> AsyncLROPoller[None]:
        """Delete an ingestion from a catalog. All runs of the ingestion will be deleted. Ingestion must
        not have any runs in progress or queued.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param ingestion_id: Ingestion id. Required.
        :type ingestion_id: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(
                collection_id=collection_id,
                ingestion_id=ingestion_id,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get(self, collection_id: str, ingestion_id: str, **kwargs: Any) -> _models.IngestionDefinition:
        """Get the definition of an ingestion.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param ingestion_id: Ingestion id. Required.
        :type ingestion_id: str
        :return: IngestionDefinition. The IngestionDefinition is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.IngestionDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.IngestionDefinition] = kwargs.pop("cls", None)

        _request = build_ingestion_get_request(
            collection_id=collection_id,
            ingestion_id=ingestion_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.IngestionDefinition, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list(
        self, collection_id: str, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> AsyncItemPaged["_models.IngestionDefinition"]:
        """Get ingestions of a catalog.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :keyword top: The number of items to return. Default value is None.
        :paramtype top: int
        :keyword skip: The number of items to skip. Default value is None.
        :paramtype skip: int
        :return: An iterator like instance of IngestionDefinition
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.planetarycomputer.models.IngestionDefinition]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.IngestionDefinition]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_ingestion_list_request(
                    collection_id=collection_id,
                    top=top,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.IngestionDefinition], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def update(
        self,
        collection_id: str,
        ingestion_id: str,
        body: _models.IngestionDefinition,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> _models.IngestionDefinition:
        """Update an existing ingestion.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param ingestion_id: Ingestion id. Required.
        :type ingestion_id: str
        :param body: Ingestion properties to update. Required.
        :type body: ~azure.planetarycomputer.models.IngestionDefinition
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: IngestionDefinition. The IngestionDefinition is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.IngestionDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        collection_id: str,
        ingestion_id: str,
        body: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> _models.IngestionDefinition:
        """Update an existing ingestion.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param ingestion_id: Ingestion id. Required.
        :type ingestion_id: str
        :param body: Ingestion properties to update. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: IngestionDefinition. The IngestionDefinition is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.IngestionDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        collection_id: str,
        ingestion_id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> _models.IngestionDefinition:
        """Update an existing ingestion.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param ingestion_id: Ingestion id. Required.
        :type ingestion_id: str
        :param body: Ingestion properties to update. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: IngestionDefinition. The IngestionDefinition is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.IngestionDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self,
        collection_id: str,
        ingestion_id: str,
        body: Union[_models.IngestionDefinition, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.IngestionDefinition:
        """Update an existing ingestion.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param ingestion_id: Ingestion id. Required.
        :type ingestion_id: str
        :param body: Ingestion properties to update. Is one of the following types:
         IngestionDefinition, JSON, IO[bytes] Required.
        :type body: ~azure.planetarycomputer.models.IngestionDefinition or JSON or IO[bytes]
        :return: IngestionDefinition. The IngestionDefinition is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.IngestionDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("content-type", None))
        cls: ClsType[_models.IngestionDefinition] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_ingestion_update_request(
            collection_id=collection_id,
            ingestion_id=ingestion_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.IngestionDefinition, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_source(
        self, body: _models.IngestionSource, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.IngestionSource:
        """Create a new ingestion source in a geo-catalog.

        :param body: Definition of the ingestion source. Required.
        :type body: ~azure.planetarycomputer.models.IngestionSource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: IngestionSource. The IngestionSource is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.IngestionSource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_source(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.IngestionSource:
        """Create a new ingestion source in a geo-catalog.

        :param body: Definition of the ingestion source. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: IngestionSource. The IngestionSource is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.IngestionSource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_source(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.IngestionSource:
        """Create a new ingestion source in a geo-catalog.

        :param body: Definition of the ingestion source. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: IngestionSource. The IngestionSource is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.IngestionSource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_source(
        self, body: Union[_models.IngestionSource, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.IngestionSource:
        """Create a new ingestion source in a geo-catalog.

        :param body: Definition of the ingestion source. Is one of the following types:
         IngestionSource, JSON, IO[bytes] Required.
        :type body: ~azure.planetarycomputer.models.IngestionSource or JSON or IO[bytes]
        :return: IngestionSource. The IngestionSource is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.IngestionSource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.IngestionSource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_ingestion_create_source_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["location"] = self._deserialize("str", response.headers.get("location"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.IngestionSource, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def replace_source(
        self, id: str, body: _models.IngestionSource, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.IngestionSource:
        """Update an existing ingestion source in a geo-catalog.

        :param id: Ingestion source id. Required.
        :type id: str
        :param body: Definition of the ingestion source. Required.
        :type body: ~azure.planetarycomputer.models.IngestionSource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: IngestionSource. The IngestionSource is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.IngestionSource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def replace_source(
        self, id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.IngestionSource:
        """Update an existing ingestion source in a geo-catalog.

        :param id: Ingestion source id. Required.
        :type id: str
        :param body: Definition of the ingestion source. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: IngestionSource. The IngestionSource is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.IngestionSource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def replace_source(
        self, id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.IngestionSource:
        """Update an existing ingestion source in a geo-catalog.

        :param id: Ingestion source id. Required.
        :type id: str
        :param body: Definition of the ingestion source. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: IngestionSource. The IngestionSource is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.IngestionSource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def replace_source(
        self, id: str, body: Union[_models.IngestionSource, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.IngestionSource:
        """Update an existing ingestion source in a geo-catalog.

        :param id: Ingestion source id. Required.
        :type id: str
        :param body: Definition of the ingestion source. Is one of the following types:
         IngestionSource, JSON, IO[bytes] Required.
        :type body: ~azure.planetarycomputer.models.IngestionSource or JSON or IO[bytes]
        :return: IngestionSource. The IngestionSource is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.IngestionSource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.IngestionSource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_ingestion_replace_source_request(
            id=id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["location"] = self._deserialize("str", response.headers.get("location"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.IngestionSource, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_source(self, id: str, **kwargs: Any) -> None:
        """Delete an ingestion source from a geo-catalog.

        :param id: Ingestion source id. Required.
        :type id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_ingestion_delete_source_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_source(self, id: str, **kwargs: Any) -> _models.IngestionSource:
        """Get an ingestion source in a geo-catalog.

        :param id: Ingestion source id. Required.
        :type id: str
        :return: IngestionSource. The IngestionSource is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.IngestionSource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.IngestionSource] = kwargs.pop("cls", None)

        _request = build_ingestion_get_source_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.IngestionSource, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_sources(
        self, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> AsyncItemPaged["_models.IngestionSourceSummary"]:
        """Get ingestion sources in a geo-catalog.

        :keyword top: The number of items to return. Default value is None.
        :paramtype top: int
        :keyword skip: The number of items to skip. Default value is None.
        :paramtype skip: int
        :return: An iterator like instance of IngestionSourceSummary
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.planetarycomputer.models.IngestionSourceSummary]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.IngestionSourceSummary]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_ingestion_list_sources_request(
                    top=top,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.IngestionSourceSummary], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_managed_identities(self, **kwargs: Any) -> AsyncItemPaged["_models.ManagedIdentityMetadata"]:
        """Get all managed identities with access to storage accounts configured for a geo-catalog.

        :return: An iterator like instance of ManagedIdentityMetadata
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.planetarycomputer.models.ManagedIdentityMetadata]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.ManagedIdentityMetadata]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_ingestion_list_managed_identities_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.ManagedIdentityMetadata], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class StacOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.planetarycomputer.aio.PlanetaryComputerProClient`'s
        :attr:`stac` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: PlanetaryComputerProClientConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def create_collection_asset(
        self, collection_id: str, body: _models.StacAssetData, **kwargs: Any
    ) -> _models.StacCollection:
        """Create Collection Asset.

        Create a new asset in the Collection metadata and write the associated file to managed storage.

        :param collection_id: STAC Collection ID. Required.
        :type collection_id: str
        :param body: Multi-part form data. Required.
        :type body: ~azure.planetarycomputer.models.StacAssetData
        :return: StacCollection. The StacCollection is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacCollection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_collection_asset(self, collection_id: str, body: JSON, **kwargs: Any) -> _models.StacCollection:
        """Create Collection Asset.

        Create a new asset in the Collection metadata and write the associated file to managed storage.

        :param collection_id: STAC Collection ID. Required.
        :type collection_id: str
        :param body: Multi-part form data. Required.
        :type body: JSON
        :return: StacCollection. The StacCollection is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacCollection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_collection_asset(
        self, collection_id: str, body: Union[_models.StacAssetData, JSON], **kwargs: Any
    ) -> _models.StacCollection:
        """Create Collection Asset.

        Create a new asset in the Collection metadata and write the associated file to managed storage.

        :param collection_id: STAC Collection ID. Required.
        :type collection_id: str
        :param body: Multi-part form data. Is either a StacAssetData type or a JSON type. Required.
        :type body: ~azure.planetarycomputer.models.StacAssetData or JSON
        :return: StacCollection. The StacCollection is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacCollection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.StacCollection] = kwargs.pop("cls", None)

        _body = body.as_dict() if isinstance(body, _Model) else body
        _file_fields: list[str] = ["file"]
        _data_fields: list[str] = ["data"]
        _files = prepare_multipart_form_data(_body, _file_fields, _data_fields)

        _request = build_stac_create_collection_asset_request(
            collection_id=collection_id,
            api_version=self._config.api_version,
            files=_files,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.StacCollection, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def replace_collection_asset(
        self, collection_id: str, asset_id: str, body: _models.StacAssetData, **kwargs: Any
    ) -> _models.StacCollection:
        """Update Collection Asset.

        Update an existing asset in a given collection.

        :param collection_id: STAC Collection ID. Required.
        :type collection_id: str
        :param asset_id: STAC Asset ID. Required.
        :type asset_id: str
        :param body: Multi-part form data. Required.
        :type body: ~azure.planetarycomputer.models.StacAssetData
        :return: StacCollection. The StacCollection is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacCollection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def replace_collection_asset(
        self, collection_id: str, asset_id: str, body: JSON, **kwargs: Any
    ) -> _models.StacCollection:
        """Update Collection Asset.

        Update an existing asset in a given collection.

        :param collection_id: STAC Collection ID. Required.
        :type collection_id: str
        :param asset_id: STAC Asset ID. Required.
        :type asset_id: str
        :param body: Multi-part form data. Required.
        :type body: JSON
        :return: StacCollection. The StacCollection is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacCollection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def replace_collection_asset(
        self, collection_id: str, asset_id: str, body: Union[_models.StacAssetData, JSON], **kwargs: Any
    ) -> _models.StacCollection:
        """Update Collection Asset.

        Update an existing asset in a given collection.

        :param collection_id: STAC Collection ID. Required.
        :type collection_id: str
        :param asset_id: STAC Asset ID. Required.
        :type asset_id: str
        :param body: Multi-part form data. Is either a StacAssetData type or a JSON type. Required.
        :type body: ~azure.planetarycomputer.models.StacAssetData or JSON
        :return: StacCollection. The StacCollection is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacCollection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.StacCollection] = kwargs.pop("cls", None)

        _body = body.as_dict() if isinstance(body, _Model) else body
        _file_fields: list[str] = ["file"]
        _data_fields: list[str] = ["data"]
        _files = prepare_multipart_form_data(_body, _file_fields, _data_fields)

        _request = build_stac_replace_collection_asset_request(
            collection_id=collection_id,
            asset_id=asset_id,
            api_version=self._config.api_version,
            files=_files,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.StacCollection, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_collection_asset(self, collection_id: str, asset_id: str, **kwargs: Any) -> _models.StacCollection:
        """Delete Collection Asset.

        Delete an asset from a given collection.

        :param collection_id: STAC Collection ID. Required.
        :type collection_id: str
        :param asset_id: STAC Asset ID. Required.
        :type asset_id: str
        :return: StacCollection. The StacCollection is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacCollection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.StacCollection] = kwargs.pop("cls", None)

        _request = build_stac_delete_collection_asset_request(
            collection_id=collection_id,
            asset_id=asset_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.StacCollection, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_collection_configuration(self, collection_id: str, **kwargs: Any) -> _models.UserCollectionSettings:
        """Get Config.

        Get the complete user configuration for a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :return: UserCollectionSettings. The UserCollectionSettings is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.UserCollectionSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.UserCollectionSettings] = kwargs.pop("cls", None)

        _request = build_stac_get_collection_configuration_request(
            collection_id=collection_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.UserCollectionSettings, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def add_mosaic(
        self, collection_id: str, body: _models.StacMosaic, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.StacMosaic:
        """Add Collection Mosaic.

        Add a mosaic definition to a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param body: Mosaic definition to be created or updated. Required.
        :type body: ~azure.planetarycomputer.models.StacMosaic
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StacMosaic. The StacMosaic is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacMosaic
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add_mosaic(
        self, collection_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.StacMosaic:
        """Add Collection Mosaic.

        Add a mosaic definition to a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param body: Mosaic definition to be created or updated. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StacMosaic. The StacMosaic is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacMosaic
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add_mosaic(
        self, collection_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.StacMosaic:
        """Add Collection Mosaic.

        Add a mosaic definition to a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param body: Mosaic definition to be created or updated. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StacMosaic. The StacMosaic is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacMosaic
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add_mosaic(
        self, collection_id: str, body: Union[_models.StacMosaic, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.StacMosaic:
        """Add Collection Mosaic.

        Add a mosaic definition to a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param body: Mosaic definition to be created or updated. Is one of the following types:
         StacMosaic, JSON, IO[bytes] Required.
        :type body: ~azure.planetarycomputer.models.StacMosaic or JSON or IO[bytes]
        :return: StacMosaic. The StacMosaic is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacMosaic
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StacMosaic] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_stac_add_mosaic_request(
            collection_id=collection_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.StacMosaic, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def replace_mosaic(
        self,
        collection_id: str,
        mosaic_id: str,
        body: _models.StacMosaic,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StacMosaic:
        """Update Collection Mosaic.

        Update a mosaic definition from a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param mosaic_id: Unique identifier for the mosaic configuration. Required.
        :type mosaic_id: str
        :param body: Mosaic definition to be created or updated. Required.
        :type body: ~azure.planetarycomputer.models.StacMosaic
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StacMosaic. The StacMosaic is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacMosaic
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def replace_mosaic(
        self, collection_id: str, mosaic_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.StacMosaic:
        """Update Collection Mosaic.

        Update a mosaic definition from a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param mosaic_id: Unique identifier for the mosaic configuration. Required.
        :type mosaic_id: str
        :param body: Mosaic definition to be created or updated. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StacMosaic. The StacMosaic is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacMosaic
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def replace_mosaic(
        self,
        collection_id: str,
        mosaic_id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StacMosaic:
        """Update Collection Mosaic.

        Update a mosaic definition from a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param mosaic_id: Unique identifier for the mosaic configuration. Required.
        :type mosaic_id: str
        :param body: Mosaic definition to be created or updated. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StacMosaic. The StacMosaic is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacMosaic
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def replace_mosaic(
        self, collection_id: str, mosaic_id: str, body: Union[_models.StacMosaic, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.StacMosaic:
        """Update Collection Mosaic.

        Update a mosaic definition from a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param mosaic_id: Unique identifier for the mosaic configuration. Required.
        :type mosaic_id: str
        :param body: Mosaic definition to be created or updated. Is one of the following types:
         StacMosaic, JSON, IO[bytes] Required.
        :type body: ~azure.planetarycomputer.models.StacMosaic or JSON or IO[bytes]
        :return: StacMosaic. The StacMosaic is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacMosaic
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StacMosaic] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_stac_replace_mosaic_request(
            collection_id=collection_id,
            mosaic_id=mosaic_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.StacMosaic, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_mosaic(self, collection_id: str, mosaic_id: str, **kwargs: Any) -> None:
        """Delete Collection Mosaic.

        Delete a mosaic definition from a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param mosaic_id: Unique identifier for the mosaic configuration. Required.
        :type mosaic_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_stac_delete_mosaic_request(
            collection_id=collection_id,
            mosaic_id=mosaic_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_mosaic(self, collection_id: str, mosaic_id: str, **kwargs: Any) -> _models.StacMosaic:
        """Get Collection Mosaic.

        Get a mosaic definition from a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param mosaic_id: Unique identifier for the mosaic configuration. Required.
        :type mosaic_id: str
        :return: StacMosaic. The StacMosaic is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacMosaic
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.StacMosaic] = kwargs.pop("cls", None)

        _request = build_stac_get_mosaic_request(
            collection_id=collection_id,
            mosaic_id=mosaic_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.StacMosaic, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_mosaics(self, collection_id: str, **kwargs: Any) -> List[_models.StacMosaic]:
        """Get Collection Mosaics.

        Get the mosaic definitions for a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :return: list of StacMosaic
        :rtype: list[~azure.planetarycomputer.models.StacMosaic]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.StacMosaic]] = kwargs.pop("cls", None)

        _request = build_stac_list_mosaics_request(
            collection_id=collection_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.StacMosaic], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_collection_initial(
        self, body: Union[_models.StacCollection, JSON, IO[bytes]], **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_stac_create_collection_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["location"] = self._deserialize("str", response.headers.get("location"))
        response_headers["operation-location"] = self._deserialize("str", response.headers.get("operation-location"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_collection(
        self, body: _models.StacCollection, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Create Collection.

        Create a new collection in the GeoCatalog instance.

        :param body: Request collection body. Required.
        :type body: ~azure.planetarycomputer.models.StacCollection
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_collection(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Create Collection.

        Create a new collection in the GeoCatalog instance.

        :param body: Request collection body. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_collection(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Create Collection.

        Create a new collection in the GeoCatalog instance.

        :param body: Request collection body. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_collection(
        self, body: Union[_models.StacCollection, JSON, IO[bytes]], **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Create Collection.

        Create a new collection in the GeoCatalog instance.

        :param body: Request collection body. Is one of the following types: StacCollection, JSON,
         IO[bytes] Required.
        :type body: ~azure.planetarycomputer.models.StacCollection or JSON or IO[bytes]
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_collection_initial(
                body=body, content_type=content_type, cls=lambda x, y, z: x, headers=_headers, params=_params, **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @overload
    async def create_or_replace_collection(
        self, collection_id: str, body: _models.StacCollection, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.StacCollection:
        """Create or update Collection.

        Create or replace a collection in the GeoCatalog instance.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param body: Request collection body. Required.
        :type body: ~azure.planetarycomputer.models.StacCollection
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StacCollection. The StacCollection is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacCollection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_replace_collection(
        self, collection_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.StacCollection:
        """Create or update Collection.

        Create or replace a collection in the GeoCatalog instance.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param body: Request collection body. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StacCollection. The StacCollection is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacCollection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_replace_collection(
        self, collection_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.StacCollection:
        """Create or update Collection.

        Create or replace a collection in the GeoCatalog instance.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param body: Request collection body. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StacCollection. The StacCollection is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacCollection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_replace_collection(
        self, collection_id: str, body: Union[_models.StacCollection, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.StacCollection:
        """Create or update Collection.

        Create or replace a collection in the GeoCatalog instance.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param body: Request collection body. Is one of the following types: StacCollection, JSON,
         IO[bytes] Required.
        :type body: ~azure.planetarycomputer.models.StacCollection or JSON or IO[bytes]
        :return: StacCollection. The StacCollection is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacCollection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StacCollection] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_stac_create_or_replace_collection_request(
            collection_id=collection_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.StacCollection, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _delete_collection_initial(self, collection_id: str, **kwargs: Any) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_stac_delete_collection_request(
            collection_id=collection_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["location"] = self._deserialize("str", response.headers.get("location"))
        response_headers["operation-location"] = self._deserialize("str", response.headers.get("operation-location"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_delete_collection(self, collection_id: str, **kwargs: Any) -> AsyncLROPoller[None]:
        """Delete Collection.

        Delete a collection in the GeoCatalog instance.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_collection_initial(
                collection_id=collection_id, cls=lambda x, y, z: x, headers=_headers, params=_params, **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get_collection(
        self,
        collection_id: str,
        *,
        sign: Optional[Union[str, _models.StacAssetUrlSigningMode]] = None,
        duration_in_minutes: Optional[int] = None,
        **kwargs: Any
    ) -> _models.StacCollection:
        """Get Collection.

        Get a collection in the GeoCatalog instance.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :keyword sign: Whether to sign asset URLs in the response. Known values are: "true" and
         "false". Default value is None.
        :paramtype sign: str or ~azure.planetarycomputer.models.StacAssetUrlSigningMode
        :keyword duration_in_minutes: URL signature duration in minutes. Default value is None.
        :paramtype duration_in_minutes: int
        :return: StacCollection. The StacCollection is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacCollection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.StacCollection] = kwargs.pop("cls", None)

        _request = build_stac_get_collection_request(
            collection_id=collection_id,
            sign=sign,
            duration_in_minutes=duration_in_minutes,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.StacCollection, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_collections(
        self,
        *,
        sign: Optional[Union[str, _models.StacAssetUrlSigningMode]] = None,
        duration_in_minutes: Optional[int] = None,
        **kwargs: Any
    ) -> _models.StacCatalogCollections:
        """Get Collections.

        List all collections in the GeoCatalog instance.

        :keyword sign: Whether to sign asset URLs in the response. Known values are: "true" and
         "false". Default value is None.
        :paramtype sign: str or ~azure.planetarycomputer.models.StacAssetUrlSigningMode
        :keyword duration_in_minutes: URL signature duration in minutes. Default value is None.
        :paramtype duration_in_minutes: int
        :return: StacCatalogCollections. The StacCatalogCollections is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacCatalogCollections
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.StacCatalogCollections] = kwargs.pop("cls", None)

        _request = build_stac_get_collections_request(
            sign=sign,
            duration_in_minutes=duration_in_minutes,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.StacCatalogCollections, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_partition_type(self, collection_id: str, **kwargs: Any) -> _models.PartitionType:
        """Get Partitiontype.

        Get the partitiontype for a GeoCatalog Collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :return: PartitionType. The PartitionType is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.PartitionType
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.PartitionType] = kwargs.pop("cls", None)

        _request = build_stac_get_partition_type_request(
            collection_id=collection_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.PartitionType, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def replace_partition_type(
        self, collection_id: str, body: _models.PartitionType, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Create Partitiontype.

        Updates partition type for a GeoCatalog Collection. This will
        determine the partitioning scheme for items within the database,
        and can only be set before any items are loaded.

        Ideal partitioning schemes result in partitions of roughly 100k items each.

        The default partitioning scheme is "none" which does not partition items.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param body: Partition type configuration determining how items are partitioned in storage.
         Required.
        :type body: ~azure.planetarycomputer.models.PartitionType
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def replace_partition_type(
        self, collection_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Create Partitiontype.

        Updates partition type for a GeoCatalog Collection. This will
        determine the partitioning scheme for items within the database,
        and can only be set before any items are loaded.

        Ideal partitioning schemes result in partitions of roughly 100k items each.

        The default partitioning scheme is "none" which does not partition items.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param body: Partition type configuration determining how items are partitioned in storage.
         Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def replace_partition_type(
        self, collection_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Create Partitiontype.

        Updates partition type for a GeoCatalog Collection. This will
        determine the partitioning scheme for items within the database,
        and can only be set before any items are loaded.

        Ideal partitioning schemes result in partitions of roughly 100k items each.

        The default partitioning scheme is "none" which does not partition items.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param body: Partition type configuration determining how items are partitioned in storage.
         Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def replace_partition_type(
        self, collection_id: str, body: Union[_models.PartitionType, JSON, IO[bytes]], **kwargs: Any
    ) -> None:
        """Create Partitiontype.

        Updates partition type for a GeoCatalog Collection. This will
        determine the partitioning scheme for items within the database,
        and can only be set before any items are loaded.

        Ideal partitioning schemes result in partitions of roughly 100k items each.

        The default partitioning scheme is "none" which does not partition items.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param body: Partition type configuration determining how items are partitioned in storage. Is
         one of the following types: PartitionType, JSON, IO[bytes] Required.
        :type body: ~azure.planetarycomputer.models.PartitionType or JSON or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_stac_replace_partition_type_request(
            collection_id=collection_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def create_render_option(
        self, collection_id: str, body: _models.RenderOption, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.RenderOption:
        """Add Collection Render Option.

        Add a render option for a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param body: Render option configuration to be created or updated. Required.
        :type body: ~azure.planetarycomputer.models.RenderOption
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RenderOption. The RenderOption is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.RenderOption
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_render_option(
        self, collection_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.RenderOption:
        """Add Collection Render Option.

        Add a render option for a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param body: Render option configuration to be created or updated. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RenderOption. The RenderOption is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.RenderOption
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_render_option(
        self, collection_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.RenderOption:
        """Add Collection Render Option.

        Add a render option for a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param body: Render option configuration to be created or updated. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RenderOption. The RenderOption is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.RenderOption
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_render_option(
        self, collection_id: str, body: Union[_models.RenderOption, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.RenderOption:
        """Add Collection Render Option.

        Add a render option for a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param body: Render option configuration to be created or updated. Is one of the following
         types: RenderOption, JSON, IO[bytes] Required.
        :type body: ~azure.planetarycomputer.models.RenderOption or JSON or IO[bytes]
        :return: RenderOption. The RenderOption is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.RenderOption
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RenderOption] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_stac_create_render_option_request(
            collection_id=collection_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.RenderOption, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def replace_render_option(
        self,
        collection_id: str,
        render_option_id: str,
        body: _models.RenderOption,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RenderOption:
        """Update Collection Render Option.

        Update a render option for a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param render_option_id: Unique identifier for the render option. Required.
        :type render_option_id: str
        :param body: Render option configuration to be created or updated. Required.
        :type body: ~azure.planetarycomputer.models.RenderOption
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RenderOption. The RenderOption is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.RenderOption
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def replace_render_option(
        self,
        collection_id: str,
        render_option_id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RenderOption:
        """Update Collection Render Option.

        Update a render option for a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param render_option_id: Unique identifier for the render option. Required.
        :type render_option_id: str
        :param body: Render option configuration to be created or updated. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RenderOption. The RenderOption is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.RenderOption
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def replace_render_option(
        self,
        collection_id: str,
        render_option_id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RenderOption:
        """Update Collection Render Option.

        Update a render option for a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param render_option_id: Unique identifier for the render option. Required.
        :type render_option_id: str
        :param body: Render option configuration to be created or updated. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RenderOption. The RenderOption is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.RenderOption
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def replace_render_option(
        self,
        collection_id: str,
        render_option_id: str,
        body: Union[_models.RenderOption, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.RenderOption:
        """Update Collection Render Option.

        Update a render option for a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param render_option_id: Unique identifier for the render option. Required.
        :type render_option_id: str
        :param body: Render option configuration to be created or updated. Is one of the following
         types: RenderOption, JSON, IO[bytes] Required.
        :type body: ~azure.planetarycomputer.models.RenderOption or JSON or IO[bytes]
        :return: RenderOption. The RenderOption is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.RenderOption
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RenderOption] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_stac_replace_render_option_request(
            collection_id=collection_id,
            render_option_id=render_option_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.RenderOption, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_render_option(self, collection_id: str, render_option_id: str, **kwargs: Any) -> None:
        """Delete Collection Render Option.

        Delete a render option for a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param render_option_id: Unique identifier for the render option. Required.
        :type render_option_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_stac_delete_render_option_request(
            collection_id=collection_id,
            render_option_id=render_option_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_render_option(self, collection_id: str, render_option_id: str, **kwargs: Any) -> _models.RenderOption:
        """Get Collection Render Option.

        Get a render option for a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param render_option_id: Unique identifier for the render option. Required.
        :type render_option_id: str
        :return: RenderOption. The RenderOption is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.RenderOption
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.RenderOption] = kwargs.pop("cls", None)

        _request = build_stac_get_render_option_request(
            collection_id=collection_id,
            render_option_id=render_option_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.RenderOption, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_render_options(self, collection_id: str, **kwargs: Any) -> List[_models.RenderOption]:
        """Get Collection Render Options.

        Get all render options for a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :return: list of RenderOption
        :rtype: list[~azure.planetarycomputer.models.RenderOption]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.RenderOption]] = kwargs.pop("cls", None)

        _request = build_stac_list_render_options_request(
            collection_id=collection_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.RenderOption], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_collection_thumbnail(self, collection_id: str, **kwargs: Any) -> AsyncIterator[bytes]:
        """Get Collection Thumbnail.

        Get thumbnail for given collection.

        :param collection_id: STAC Collection ID. Required.
        :type collection_id: str
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_stac_get_collection_thumbnail_request(
            collection_id=collection_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", True)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_tile_settings(self, collection_id: str, **kwargs: Any) -> _models.TileSettings:
        """Get Collection Tile Settings.

        Get the tile settings for a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :return: TileSettings. The TileSettings is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.TileSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TileSettings] = kwargs.pop("cls", None)

        _request = build_stac_get_tile_settings_request(
            collection_id=collection_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TileSettings, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def replace_tile_settings(
        self, collection_id: str, body: _models.TileSettings, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.TileSettings:
        """Update Collection Tile Settings.

        Update the tile settings for a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param body: Tile settings configuration to be updated. Required.
        :type body: ~azure.planetarycomputer.models.TileSettings
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TileSettings. The TileSettings is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.TileSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def replace_tile_settings(
        self, collection_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.TileSettings:
        """Update Collection Tile Settings.

        Update the tile settings for a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param body: Tile settings configuration to be updated. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TileSettings. The TileSettings is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.TileSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def replace_tile_settings(
        self, collection_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.TileSettings:
        """Update Collection Tile Settings.

        Update the tile settings for a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param body: Tile settings configuration to be updated. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TileSettings. The TileSettings is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.TileSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def replace_tile_settings(
        self, collection_id: str, body: Union[_models.TileSettings, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.TileSettings:
        """Update Collection Tile Settings.

        Update the tile settings for a given collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param body: Tile settings configuration to be updated. Is one of the following types:
         TileSettings, JSON, IO[bytes] Required.
        :type body: ~azure.planetarycomputer.models.TileSettings or JSON or IO[bytes]
        :return: TileSettings. The TileSettings is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.TileSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.TileSettings] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_stac_replace_tile_settings_request(
            collection_id=collection_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TileSettings, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_conformance_class(self, **kwargs: Any) -> _models.StacConformanceClasses:
        """Conformance Classes.

        Returns the STAC conformance classes.

        :return: StacConformanceClasses. The StacConformanceClasses is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacConformanceClasses
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.StacConformanceClasses] = kwargs.pop("cls", None)

        _request = build_stac_get_conformance_class_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.StacConformanceClasses, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_landing_page(self, **kwargs: Any) -> _models.StacLandingPage:
        """Landing Page.

        Return the STAC landing page.

        :return: StacLandingPage. The StacLandingPage is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacLandingPage
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.StacLandingPage] = kwargs.pop("cls", None)

        _request = build_stac_get_landing_page_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.StacLandingPage, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_item_initial(
        self, collection_id: str, body: Union[_models.StacItemOrStacItemCollection, JSON, IO[bytes]], **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_stac_create_item_request(
            collection_id=collection_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["location"] = self._deserialize("str", response.headers.get("location"))
        response_headers["operation-location"] = self._deserialize("str", response.headers.get("operation-location"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_item(
        self,
        collection_id: str,
        body: _models.StacItemOrStacItemCollection,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Create a new STAC item or a set of items in a collection.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param body: STAC Item or StacItemCollection

         Represents a STAC Item or StacItemCollection as defined by the STAC 1.0.0 standard.

         **Item**: A GeoJSON Feature that represents a single spatiotemporal asset.
         It includes metadata such as geometry, datetime, and links to related assets.
         Example: A satellite image with its metadata.

         **StacItemCollection**: A GeoJSON FeatureCollection that contains multiple Items.
         It is used to group multiple related Items together, such as a collection of satellite images.

         This union allows the request body to accept either a single Item or a collection of Items.
         Required.
        :type body: ~azure.planetarycomputer.models.StacItemOrStacItemCollection
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_item(
        self, collection_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Create a new STAC item or a set of items in a collection.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param body: STAC Item or StacItemCollection

         Represents a STAC Item or StacItemCollection as defined by the STAC 1.0.0 standard.

         **Item**: A GeoJSON Feature that represents a single spatiotemporal asset.
         It includes metadata such as geometry, datetime, and links to related assets.
         Example: A satellite image with its metadata.

         **StacItemCollection**: A GeoJSON FeatureCollection that contains multiple Items.
         It is used to group multiple related Items together, such as a collection of satellite images.

         This union allows the request body to accept either a single Item or a collection of Items.
         Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_item(
        self, collection_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Create a new STAC item or a set of items in a collection.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param body: STAC Item or StacItemCollection

         Represents a STAC Item or StacItemCollection as defined by the STAC 1.0.0 standard.

         **Item**: A GeoJSON Feature that represents a single spatiotemporal asset.
         It includes metadata such as geometry, datetime, and links to related assets.
         Example: A satellite image with its metadata.

         **StacItemCollection**: A GeoJSON FeatureCollection that contains multiple Items.
         It is used to group multiple related Items together, such as a collection of satellite images.

         This union allows the request body to accept either a single Item or a collection of Items.
         Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_item(
        self, collection_id: str, body: Union[_models.StacItemOrStacItemCollection, JSON, IO[bytes]], **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Create a new STAC item or a set of items in a collection.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param body: STAC Item or StacItemCollection

         Represents a STAC Item or StacItemCollection as defined by the STAC 1.0.0 standard.

         **Item**: A GeoJSON Feature that represents a single spatiotemporal asset.
         It includes metadata such as geometry, datetime, and links to related assets.
         Example: A satellite image with its metadata.

         **StacItemCollection**: A GeoJSON FeatureCollection that contains multiple Items.
         It is used to group multiple related Items together, such as a collection of satellite images.

         This union allows the request body to accept either a single Item or a collection of Items. Is
         one of the following types: StacItemOrStacItemCollection, JSON, IO[bytes] Required.
        :type body: ~azure.planetarycomputer.models.StacItemOrStacItemCollection or JSON or IO[bytes]
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_item_initial(
                collection_id=collection_id,
                body=body,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _create_or_replace_item_initial(
        self, collection_id: str, item_id: str, body: Union[_models.StacItem, JSON, IO[bytes]], **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_stac_create_or_replace_item_request(
            collection_id=collection_id,
            item_id=item_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["location"] = self._deserialize("str", response.headers.get("location"))
        response_headers["operation-location"] = self._deserialize("str", response.headers.get("operation-location"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_replace_item(
        self,
        collection_id: str,
        item_id: str,
        body: _models.StacItem,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Create or replace a STAC item in a collection.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param item_id: STAC Item id. Required.
        :type item_id: str
        :param body: STAC Item. Required.
        :type body: ~azure.planetarycomputer.models.StacItem
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_replace_item(
        self, collection_id: str, item_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Create or replace a STAC item in a collection.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param item_id: STAC Item id. Required.
        :type item_id: str
        :param body: STAC Item. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_replace_item(
        self,
        collection_id: str,
        item_id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Create or replace a STAC item in a collection.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param item_id: STAC Item id. Required.
        :type item_id: str
        :param body: STAC Item. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_replace_item(
        self, collection_id: str, item_id: str, body: Union[_models.StacItem, JSON, IO[bytes]], **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Create or replace a STAC item in a collection.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param item_id: STAC Item id. Required.
        :type item_id: str
        :param body: STAC Item. Is one of the following types: StacItem, JSON, IO[bytes] Required.
        :type body: ~azure.planetarycomputer.models.StacItem or JSON or IO[bytes]
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_replace_item_initial(
                collection_id=collection_id,
                item_id=item_id,
                body=body,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _delete_item_initial(self, collection_id: str, item_id: str, **kwargs: Any) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_stac_delete_item_request(
            collection_id=collection_id,
            item_id=item_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["location"] = self._deserialize("str", response.headers.get("location"))
        response_headers["operation-location"] = self._deserialize("str", response.headers.get("operation-location"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_delete_item(self, collection_id: str, item_id: str, **kwargs: Any) -> AsyncLROPoller[None]:
        """Delete a STAC item from a collection.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param item_id: STAC Item id. Required.
        :type item_id: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_item_initial(
                collection_id=collection_id,
                item_id=item_id,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get_item(self, collection_id: str, item_id: str, **kwargs: Any) -> _models.StacItem:
        """Fetch a single STAC Item.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param item_id: STAC Item id. Required.
        :type item_id: str
        :return: StacItem. The StacItem is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.StacItem] = kwargs.pop("cls", None)

        _request = build_stac_get_item_request(
            collection_id=collection_id,
            item_id=item_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.StacItem, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_item_collection(
        self,
        collection_id: str,
        *,
        limit: Optional[int] = None,
        bounding_box: Optional[List[str]] = None,
        datetime: Optional[str] = None,
        **kwargs: Any
    ) -> _models.StacItemCollection:
        """Fetch features of the feature collection with id ``collectionId``.

        Every feature in a dataset belongs to a collection. A dataset may
        consist of multiple feature collections. A feature collection is often a
        collection of features of a similar type, based on a common schema.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :keyword limit: The optional limit parameter recommends the number of items that should be
         present in the response document.

         If the limit parameter value is greater than advertised limit maximum, the server must return
         the
         maximum possible number of items, rather than responding with an error.

         Only items are counted that are on the first level of the collection in the response document.
         Nested objects contained within the explicitly requested items must not be counted.

         Minimum = 1. Maximum = 10000. Default = 10. Default value is None.
        :paramtype limit: int
        :keyword bounding_box: Only features that have a geometry that intersects the bounding box are
         selected.
         The bounding box is provided as four or six numbers, depending on whether the
         coordinate reference system includes a vertical axis (height or depth):



         * Lower left corner, coordinate axis 1
         * Lower left corner, coordinate axis 2
         * Minimum value, coordinate axis 3 (optional)
         * Upper right corner, coordinate axis 1
         * Upper right corner, coordinate axis 2
         * Maximum value, coordinate axis 3 (optional)

         The coordinate reference system of the values is WGS 84 longitude/latitude
         (`http://www.opengis.net/def/crs/OGC/1.3/CRS84
         <http://www.opengis.net/def/crs/OGC/1.3/CRS84>`_).

         For WGS 84 longitude/latitude the values are in most cases the sequence of
         minimum longitude, minimum latitude, maximum longitude and maximum latitude.
         However, in cases where the box spans the antimeridian the first value
         (west-most box edge) is larger than the third value (east-most box edge).

         If the vertical axis is included, the third and the sixth number are
         the bottom and the top of the 3-dimensional bounding box.

         If a feature has multiple spatial geometry properties, it is the decision of the
         server whether only a single spatial geometry property is used to determine
         the extent or all relevant geometries. Default value is None.
        :paramtype bounding_box: list[str]
        :keyword datetime: Either a date-time or an interval, open or closed. Date and time expressions
         adhere to RFC 3339. Open intervals are expressed using double-dots.

         Examples:



         * A date-time: "2018-02-12T23:20:50Z"
         * A closed interval: "2018-02-12T00:00:00Z/2018-03-18T12:31:12Z"
         * Open intervals: "2018-02-12T00:00:00Z/.." or "../2018-03-18T12:31:12Z"

         Only features that have a temporal property that intersects the value of
         ``datetime`` are selected.

         If a feature has multiple temporal properties, it is the decision of the
         server whether only a single temporal property is used to determine
         the extent or all relevant temporal properties. Default value is None.
        :paramtype datetime: str
        :return: StacItemCollection. The StacItemCollection is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacItemCollection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.StacItemCollection] = kwargs.pop("cls", None)

        _request = build_stac_get_item_collection_request(
            collection_id=collection_id,
            limit=limit,
            bounding_box=bounding_box,
            datetime=datetime,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.StacItemCollection, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _update_item_initial(
        self, collection_id: str, item_id: str, body: Union[_models.StacItem, JSON, IO[bytes]], **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("content-type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_stac_update_item_request(
            collection_id=collection_id,
            item_id=item_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["location"] = self._deserialize("str", response.headers.get("location"))
        response_headers["operation-location"] = self._deserialize("str", response.headers.get("operation-location"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update_item(
        self,
        collection_id: str,
        item_id: str,
        body: _models.StacItem,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Update a STAC item in a collection.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param item_id: STAC Item id. Required.
        :type item_id: str
        :param body: STAC Item. Required.
        :type body: ~azure.planetarycomputer.models.StacItem
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update_item(
        self,
        collection_id: str,
        item_id: str,
        body: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Update a STAC item in a collection.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param item_id: STAC Item id. Required.
        :type item_id: str
        :param body: STAC Item. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update_item(
        self,
        collection_id: str,
        item_id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Update a STAC item in a collection.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param item_id: STAC Item id. Required.
        :type item_id: str
        :param body: STAC Item. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update_item(
        self, collection_id: str, item_id: str, body: Union[_models.StacItem, JSON, IO[bytes]], **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Update a STAC item in a collection.

        :param collection_id: Catalog collection id. Required.
        :type collection_id: str
        :param item_id: STAC Item id. Required.
        :type item_id: str
        :param body: STAC Item. Is one of the following types: StacItem, JSON, IO[bytes] Required.
        :type body: ~azure.planetarycomputer.models.StacItem or JSON or IO[bytes]
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("content-type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_item_initial(
                collection_id=collection_id,
                item_id=item_id,
                body=body,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @overload
    async def create_queryables(
        self,
        collection_id: str,
        body: List[_models.StacQueryable],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.StacQueryable]:
        """Set Collection Queryables.

        Set queryables for a collection given a list of queryable definitions.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param body: Request queryable definition body. Required.
        :type body: list[~azure.planetarycomputer.models.StacQueryable]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of StacQueryable
        :rtype: list[~azure.planetarycomputer.models.StacQueryable]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_queryables(
        self, collection_id: str, body: List[JSON], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.StacQueryable]:
        """Set Collection Queryables.

        Set queryables for a collection given a list of queryable definitions.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param body: Request queryable definition body. Required.
        :type body: list[JSON]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of StacQueryable
        :rtype: list[~azure.planetarycomputer.models.StacQueryable]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_queryables(
        self, collection_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.StacQueryable]:
        """Set Collection Queryables.

        Set queryables for a collection given a list of queryable definitions.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param body: Request queryable definition body. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of StacQueryable
        :rtype: list[~azure.planetarycomputer.models.StacQueryable]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_queryables(
        self, collection_id: str, body: Union[List[_models.StacQueryable], List[JSON], IO[bytes]], **kwargs: Any
    ) -> List[_models.StacQueryable]:
        """Set Collection Queryables.

        Set queryables for a collection given a list of queryable definitions.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param body: Request queryable definition body. Is one of the following types: [StacQueryable],
         [JSON], IO[bytes] Required.
        :type body: list[~azure.planetarycomputer.models.StacQueryable] or list[JSON] or IO[bytes]
        :return: list of StacQueryable
        :rtype: list[~azure.planetarycomputer.models.StacQueryable]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.StacQueryable]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_stac_create_queryables_request(
            collection_id=collection_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.StacQueryable], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def replace_queryable(
        self,
        collection_id: str,
        queryable_name: str,
        body: _models.StacQueryable,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StacQueryable:
        """Update Collection Queryables.

        Updates a queryable given a queryable definition and corresponding collection id.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param queryable_name: Name of the queryable property to operate on. Required.
        :type queryable_name: str
        :param body: Request queryable definition body. Required.
        :type body: ~azure.planetarycomputer.models.StacQueryable
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StacQueryable. The StacQueryable is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacQueryable
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def replace_queryable(
        self,
        collection_id: str,
        queryable_name: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StacQueryable:
        """Update Collection Queryables.

        Updates a queryable given a queryable definition and corresponding collection id.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param queryable_name: Name of the queryable property to operate on. Required.
        :type queryable_name: str
        :param body: Request queryable definition body. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StacQueryable. The StacQueryable is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacQueryable
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def replace_queryable(
        self,
        collection_id: str,
        queryable_name: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StacQueryable:
        """Update Collection Queryables.

        Updates a queryable given a queryable definition and corresponding collection id.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param queryable_name: Name of the queryable property to operate on. Required.
        :type queryable_name: str
        :param body: Request queryable definition body. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StacQueryable. The StacQueryable is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacQueryable
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def replace_queryable(
        self,
        collection_id: str,
        queryable_name: str,
        body: Union[_models.StacQueryable, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.StacQueryable:
        """Update Collection Queryables.

        Updates a queryable given a queryable definition and corresponding collection id.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param queryable_name: Name of the queryable property to operate on. Required.
        :type queryable_name: str
        :param body: Request queryable definition body. Is one of the following types: StacQueryable,
         JSON, IO[bytes] Required.
        :type body: ~azure.planetarycomputer.models.StacQueryable or JSON or IO[bytes]
        :return: StacQueryable. The StacQueryable is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacQueryable
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StacQueryable] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_stac_replace_queryable_request(
            collection_id=collection_id,
            queryable_name=queryable_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.StacQueryable, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_queryable(self, collection_id: str, queryable_name: str, **kwargs: Any) -> None:
        """Delete Queryables.

        Delete queryables by name for specified collection.

        :param collection_id: Unique identifier for the STAC collection. Required.
        :type collection_id: str
        :param queryable_name: Name of the queryable property to operate on. Required.
        :type queryable_name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_stac_delete_queryable_request(
            collection_id=collection_id,
            queryable_name=queryable_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def list_queryables(self, **kwargs: Any) -> _models.QueryableDefinitionsResponse:
        """Queryables.

        List all queryables in the GeoCatalog instance.

        :return: QueryableDefinitionsResponse. The QueryableDefinitionsResponse is compatible with
         MutableMapping
        :rtype: ~azure.planetarycomputer.models.QueryableDefinitionsResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.QueryableDefinitionsResponse] = kwargs.pop("cls", None)

        _request = build_stac_list_queryables_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.QueryableDefinitionsResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_collection_queryables(
        self, collection_id: str, **kwargs: Any
    ) -> _models.QueryableDefinitionsResponse:
        """Collection Queryables.

        List all queryables in a given collection.

        :param collection_id: Collection ID. Required.
        :type collection_id: str
        :return: QueryableDefinitionsResponse. The QueryableDefinitionsResponse is compatible with
         MutableMapping
        :rtype: ~azure.planetarycomputer.models.QueryableDefinitionsResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.QueryableDefinitionsResponse] = kwargs.pop("cls", None)

        _request = build_stac_get_collection_queryables_request(
            collection_id=collection_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.QueryableDefinitionsResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def search(
        self,
        body: _models.StacSearchParameters,
        *,
        sign: Optional[Union[str, _models.StacAssetUrlSigningMode]] = None,
        duration_in_minutes: Optional[int] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StacItemCollection:
        """Search.

        STAC search operation.

        :param body: Request body. Required.
        :type body: ~azure.planetarycomputer.models.StacSearchParameters
        :keyword sign: Whether to sign asset URLs in the response. Known values are: "true" and
         "false". Default value is None.
        :paramtype sign: str or ~azure.planetarycomputer.models.StacAssetUrlSigningMode
        :keyword duration_in_minutes: URL signature duration in minutes. Default value is None.
        :paramtype duration_in_minutes: int
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StacItemCollection. The StacItemCollection is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacItemCollection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def search(
        self,
        body: JSON,
        *,
        sign: Optional[Union[str, _models.StacAssetUrlSigningMode]] = None,
        duration_in_minutes: Optional[int] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StacItemCollection:
        """Search.

        STAC search operation.

        :param body: Request body. Required.
        :type body: JSON
        :keyword sign: Whether to sign asset URLs in the response. Known values are: "true" and
         "false". Default value is None.
        :paramtype sign: str or ~azure.planetarycomputer.models.StacAssetUrlSigningMode
        :keyword duration_in_minutes: URL signature duration in minutes. Default value is None.
        :paramtype duration_in_minutes: int
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StacItemCollection. The StacItemCollection is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacItemCollection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def search(
        self,
        body: IO[bytes],
        *,
        sign: Optional[Union[str, _models.StacAssetUrlSigningMode]] = None,
        duration_in_minutes: Optional[int] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StacItemCollection:
        """Search.

        STAC search operation.

        :param body: Request body. Required.
        :type body: IO[bytes]
        :keyword sign: Whether to sign asset URLs in the response. Known values are: "true" and
         "false". Default value is None.
        :paramtype sign: str or ~azure.planetarycomputer.models.StacAssetUrlSigningMode
        :keyword duration_in_minutes: URL signature duration in minutes. Default value is None.
        :paramtype duration_in_minutes: int
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StacItemCollection. The StacItemCollection is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacItemCollection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def search(
        self,
        body: Union[_models.StacSearchParameters, JSON, IO[bytes]],
        *,
        sign: Optional[Union[str, _models.StacAssetUrlSigningMode]] = None,
        duration_in_minutes: Optional[int] = None,
        **kwargs: Any
    ) -> _models.StacItemCollection:
        """Search.

        STAC search operation.

        :param body: Request body. Is one of the following types: StacSearchParameters, JSON, IO[bytes]
         Required.
        :type body: ~azure.planetarycomputer.models.StacSearchParameters or JSON or IO[bytes]
        :keyword sign: Whether to sign asset URLs in the response. Known values are: "true" and
         "false". Default value is None.
        :paramtype sign: str or ~azure.planetarycomputer.models.StacAssetUrlSigningMode
        :keyword duration_in_minutes: URL signature duration in minutes. Default value is None.
        :paramtype duration_in_minutes: int
        :return: StacItemCollection. The StacItemCollection is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacItemCollection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StacItemCollection] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_stac_search_request(
            sign=sign,
            duration_in_minutes=duration_in_minutes,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.StacItemCollection, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class DataOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.planetarycomputer.aio.PlanetaryComputerProClient`'s
        :attr:`data` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: PlanetaryComputerProClientConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get_tile_matrix_definitions(self, tile_matrix_set_id: str, **kwargs: Any) -> _models.TileMatrixSet:
        """Matrix Definition.

        Return Matrix Definition.

        :param tile_matrix_set_id: Identifier selecting one of the TileMatrixSetId supported. Required.
        :type tile_matrix_set_id: str
        :return: TileMatrixSet. The TileMatrixSet is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.TileMatrixSet
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TileMatrixSet] = kwargs.pop("cls", None)

        _request = build_data_get_tile_matrix_definitions_request(
            tile_matrix_set_id=tile_matrix_set_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TileMatrixSet, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_tile_matrices(self, **kwargs: Any) -> List[str]:
        """Matrix List.

        Return Matrix List.

        :return: list of str
        :rtype: list[str]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[str]] = kwargs.pop("cls", None)

        _request = build_data_list_tile_matrices_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[str], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_asset_statistics(  # pylint: disable=too-many-locals
        self,
        collection_id: str,
        item_id: str,
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        max_size: Optional[int] = None,
        categorical: Optional[bool] = None,
        categories_pixels: Optional[List[str]] = None,
        percentiles: Optional[List[int]] = None,
        histogram_bins: Optional[str] = None,
        histogram_range: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AssetStatisticsResponse:
        """Asset Statistics.

        Per Asset statistics.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :keyword max_size: Maximum dimension in pixels for the source data used to calculate
         statistics. Default value is None.
        :paramtype max_size: int
        :keyword categorical: Return statistics for categorical dataset. Default value is None.
        :paramtype categorical: bool
        :keyword categories_pixels: List of pixel categorical values for which to report counts.
         Default value is None.
        :paramtype categories_pixels: list[str]
        :keyword percentiles: List of percentile values (default to [2, 98]). Default value is None.
        :paramtype percentiles: list[int]
        :keyword histogram_bins: Defines the number of equal-width bins in the given range (10, by
         default).

         If bins is a sequence (comma ``,`` delimited values), it defines a monotonically
         increasing array of bin edges, including the rightmost edge, allowing for
         non-uniform bin widths.

         link: `https://numpy.org/doc/stable/reference/generated/numpy.histogram.html
         <https://numpy.org/doc/stable/reference/generated/numpy.histogram.html>`_. Default value is
         None.
        :paramtype histogram_bins: str
        :keyword histogram_range: Comma ``,`` delimited range of the bins.

         The lower and upper range of the bins. If not provided, range is simply
         (a.min(), a.max()).

         Values outside the range are ignored. The first element of the range must be
         less than or equal to the second.
         range affects the automatic bin computation as well.

         link: `https://numpy.org/doc/stable/reference/generated/numpy.histogram.html
         <https://numpy.org/doc/stable/reference/generated/numpy.histogram.html>`_. Default value is
         None.
        :paramtype histogram_range: str
        :return: AssetStatisticsResponse. The AssetStatisticsResponse is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.AssetStatisticsResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AssetStatisticsResponse] = kwargs.pop("cls", None)

        _request = build_data_get_asset_statistics_request(
            collection_id=collection_id,
            item_id=item_id,
            assets=assets,
            expression=expression,
            asset_band_indices=asset_band_indices,
            asset_as_band=asset_as_band,
            no_data=no_data,
            unscale=unscale,
            resampling=resampling,
            max_size=max_size,
            categorical=categorical,
            categories_pixels=categories_pixels,
            percentiles=percentiles,
            histogram_bins=histogram_bins,
            histogram_range=histogram_range,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AssetStatisticsResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_available_assets(self, collection_id: str, item_id: str, **kwargs: Any) -> List[str]:
        """Available Assets.

        Return a list of supported assets.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :return: list of str
        :rtype: list[str]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[str]] = kwargs.pop("cls", None)

        _request = build_data_list_available_assets_request(
            collection_id=collection_id,
            item_id=item_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[str], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_bounds(self, collection_id: str, item_id: str, **kwargs: Any) -> _models.StacItemBounds:
        """Bounds.

        Return all Bounds.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :return: StacItemBounds. The StacItemBounds is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacItemBounds
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.StacItemBounds] = kwargs.pop("cls", None)

        _request = build_data_get_bounds_request(
            collection_id=collection_id,
            item_id=item_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.StacItemBounds, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def crop_geo_json(
        self,
        collection_id: str,
        item_id: str,
        format: str,
        body: _models.Feature,
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        algorithm: Optional[Union[str, _models.TerrainAlgorithm]] = None,
        algorithm_params: Optional[str] = None,
        color_formula: Optional[str] = None,
        coordinate_reference_system: Optional[str] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        max_size: Optional[int] = None,
        height: Optional[int] = None,
        width: Optional[int] = None,
        rescale: Optional[List[str]] = None,
        color_map_name: Optional[Union[str, _models.ColorMapNames]] = None,
        color_map: Optional[str] = None,
        return_mask: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Geojson Crop.

        Create image from a geojson feature.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :param format: Output format for the tile or image (e.g., png, jpeg, webp). Required.
        :type format: str
        :param body: Request GeoJson body. Required.
        :type body: ~azure.planetarycomputer.models.Feature
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword algorithm: Terrain algorithm name. Known values are: "hillshade", "contours",
         "normalizedIndex", "terrarium", and "terrainrgb". Default value is None.
        :paramtype algorithm: str or ~azure.planetarycomputer.models.TerrainAlgorithm
        :keyword algorithm_params: Terrain algorithm parameters. Default value is None.
        :paramtype algorithm_params: str
        :keyword color_formula: rio-color formula (info: `https://github.com/mapbox/rio-color
         <https://github.com/mapbox/rio-color>`_). Default value is None.
        :paramtype color_formula: str
        :keyword coordinate_reference_system: Coordinate Reference System of the input coords. Default
         to ``epsg:4326``. Default value is None.
        :paramtype coordinate_reference_system: str
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :keyword max_size: Image output size limit if width and height limits are not set. Default
         value is None.
        :paramtype max_size: int
        :keyword height: Height in pixels for the output image. Default value is None.
        :paramtype height: int
        :keyword width: Width in pixels for the output image. Default value is None.
        :paramtype width: int
        :keyword rescale: comma (',') delimited Min,Max range. Can set multiple time for multiple
         bands. Default value is None.
        :paramtype rescale: list[str]
        :keyword color_map_name: Colormap name. Known values are: "accent", "accent_r", "afmhot",
         "afmhot_r", "ai4g-lulc", "alos-fnf", "alos-palsar-mask", "autumn", "autumn_r", "binary",
         "binary_r", "blues", "blues_r", "bone", "bone_r", "brbg", "brbg_r", "brg", "brg_r", "bugn",
         "bugn_r", "bupu", "bupu_r", "bwr", "bwr_r", "c-cap", "cfastie", "chesapeake-lc-13",
         "chesapeake-lc-7", "chesapeake-lu", "chloris-biomass", "cividis", "cividis_r", "cmrmap",
         "cmrmap_r", "cool", "cool_r", "coolwarm", "coolwarm_r", "copper", "copper_r", "cubehelix",
         "cubehelix_r", "dark2", "dark2_r", "drcog-lulc", "esa-cci-lc", "esa-worldcover", "flag",
         "flag_r", "gap-lulc", "gist_earth", "gist_earth_r", "gist_gray", "gist_gray_r", "gist_heat",
         "gist_heat_r", "gist_ncar", "gist_ncar_r", "gist_rainbow", "gist_rainbow_r", "gist_stern",
         "gist_stern_r", "gist_yarg", "gist_yarg_r", "gnbu", "gnbu_r", "gnuplot", "gnuplot2",
         "gnuplot2_r", "gnuplot_r", "gray", "gray_r", "greens", "greens_r", "greys", "greys_r", "hot",
         "hot_r", "hsv", "hsv_r", "inferno", "inferno_r", "io-bii", "io-lulc", "io-lulc-9-class", "jet",
         "jet_r", "jrc-change", "jrc-extent", "jrc-occurrence", "jrc-recurrence", "jrc-seasonality",
         "jrc-transitions", "lidar-classification", "lidar-hag", "lidar-hag-alternative",
         "lidar-intensity", "lidar-returns", "magma", "magma_r", "modis-10A1", "modis-10A2",
         "modis-13A1|Q1", "modis-14A1|A2", "modis-15A2H|A3H", "modis-16A3GF-ET", "modis-16A3GF-PET",
         "modis-17A2H|A2HGF", "modis-17A3HGF", "modis-64A1", "mtbs-severity", "nipy_spectral",
         "nipy_spectral_r", "nrcan-lulc", "ocean", "ocean_r", "oranges", "oranges_r", "orrd", "orrd_r",
         "paired", "paired_r", "pastel1", "pastel1_r", "pastel2", "pastel2_r", "pink", "pink_r", "piyg",
         "piyg_r", "plasma", "plasma_r", "prgn", "prgn_r", "prism", "prism_r", "pubu", "pubu_r",
         "pubugn", "pubugn_r", "puor", "puor_r", "purd", "purd_r", "purples", "purples_r", "qpe",
         "rainbow", "rainbow_r", "rdbu", "rdbu_r", "rdgy", "rdgy_r", "rdpu", "rdpu_r", "rdylbu",
         "rdylbu_r", "rdylgn", "rdylgn_r", "reds", "reds_r", "rplumbo", "schwarzwald", "seismic",
         "seismic_r", "set1", "set1_r", "set2", "set2_r", "set3", "set3_r", "spectral", "spectral_r",
         "spring", "spring_r", "summer", "summer_r", "tab10", "tab10_r", "tab20", "tab20_r", "tab20b",
         "tab20b_r", "tab20c", "tab20c_r", "terrain", "terrain_r", "twilight", "twilight_r",
         "twilight_shifted", "twilight_shifted_r", "usda-cdl", "usda-cdl-corn", "usda-cdl-cotton",
         "usda-cdl-soybeans", "usda-cdl-wheat", "usgs-lcmap", "viirs-10a1", "viirs-13a1", "viirs-14a1",
         "viirs-15a2H", "viridis", "viridis_r", "winter", "winter_r", "wistia", "wistia_r", "ylgn",
         "ylgn_r", "ylgnbu", "ylgnbu_r", "ylorbr", "ylorbr_r", "ylorrd", and "ylorrd_r". Default value
         is None.
        :paramtype color_map_name: str or ~azure.planetarycomputer.models.ColorMapNames
        :keyword color_map: JSON encoded custom Colormap. Default value is None.
        :paramtype color_map: str
        :keyword return_mask: Add mask to the output data. Default value is None.
        :paramtype return_mask: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def crop_geo_json(
        self,
        collection_id: str,
        item_id: str,
        format: str,
        body: JSON,
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        algorithm: Optional[Union[str, _models.TerrainAlgorithm]] = None,
        algorithm_params: Optional[str] = None,
        color_formula: Optional[str] = None,
        coordinate_reference_system: Optional[str] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        max_size: Optional[int] = None,
        height: Optional[int] = None,
        width: Optional[int] = None,
        rescale: Optional[List[str]] = None,
        color_map_name: Optional[Union[str, _models.ColorMapNames]] = None,
        color_map: Optional[str] = None,
        return_mask: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Geojson Crop.

        Create image from a geojson feature.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :param format: Output format for the tile or image (e.g., png, jpeg, webp). Required.
        :type format: str
        :param body: Request GeoJson body. Required.
        :type body: JSON
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword algorithm: Terrain algorithm name. Known values are: "hillshade", "contours",
         "normalizedIndex", "terrarium", and "terrainrgb". Default value is None.
        :paramtype algorithm: str or ~azure.planetarycomputer.models.TerrainAlgorithm
        :keyword algorithm_params: Terrain algorithm parameters. Default value is None.
        :paramtype algorithm_params: str
        :keyword color_formula: rio-color formula (info: `https://github.com/mapbox/rio-color
         <https://github.com/mapbox/rio-color>`_). Default value is None.
        :paramtype color_formula: str
        :keyword coordinate_reference_system: Coordinate Reference System of the input coords. Default
         to ``epsg:4326``. Default value is None.
        :paramtype coordinate_reference_system: str
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :keyword max_size: Image output size limit if width and height limits are not set. Default
         value is None.
        :paramtype max_size: int
        :keyword height: Height in pixels for the output image. Default value is None.
        :paramtype height: int
        :keyword width: Width in pixels for the output image. Default value is None.
        :paramtype width: int
        :keyword rescale: comma (',') delimited Min,Max range. Can set multiple time for multiple
         bands. Default value is None.
        :paramtype rescale: list[str]
        :keyword color_map_name: Colormap name. Known values are: "accent", "accent_r", "afmhot",
         "afmhot_r", "ai4g-lulc", "alos-fnf", "alos-palsar-mask", "autumn", "autumn_r", "binary",
         "binary_r", "blues", "blues_r", "bone", "bone_r", "brbg", "brbg_r", "brg", "brg_r", "bugn",
         "bugn_r", "bupu", "bupu_r", "bwr", "bwr_r", "c-cap", "cfastie", "chesapeake-lc-13",
         "chesapeake-lc-7", "chesapeake-lu", "chloris-biomass", "cividis", "cividis_r", "cmrmap",
         "cmrmap_r", "cool", "cool_r", "coolwarm", "coolwarm_r", "copper", "copper_r", "cubehelix",
         "cubehelix_r", "dark2", "dark2_r", "drcog-lulc", "esa-cci-lc", "esa-worldcover", "flag",
         "flag_r", "gap-lulc", "gist_earth", "gist_earth_r", "gist_gray", "gist_gray_r", "gist_heat",
         "gist_heat_r", "gist_ncar", "gist_ncar_r", "gist_rainbow", "gist_rainbow_r", "gist_stern",
         "gist_stern_r", "gist_yarg", "gist_yarg_r", "gnbu", "gnbu_r", "gnuplot", "gnuplot2",
         "gnuplot2_r", "gnuplot_r", "gray", "gray_r", "greens", "greens_r", "greys", "greys_r", "hot",
         "hot_r", "hsv", "hsv_r", "inferno", "inferno_r", "io-bii", "io-lulc", "io-lulc-9-class", "jet",
         "jet_r", "jrc-change", "jrc-extent", "jrc-occurrence", "jrc-recurrence", "jrc-seasonality",
         "jrc-transitions", "lidar-classification", "lidar-hag", "lidar-hag-alternative",
         "lidar-intensity", "lidar-returns", "magma", "magma_r", "modis-10A1", "modis-10A2",
         "modis-13A1|Q1", "modis-14A1|A2", "modis-15A2H|A3H", "modis-16A3GF-ET", "modis-16A3GF-PET",
         "modis-17A2H|A2HGF", "modis-17A3HGF", "modis-64A1", "mtbs-severity", "nipy_spectral",
         "nipy_spectral_r", "nrcan-lulc", "ocean", "ocean_r", "oranges", "oranges_r", "orrd", "orrd_r",
         "paired", "paired_r", "pastel1", "pastel1_r", "pastel2", "pastel2_r", "pink", "pink_r", "piyg",
         "piyg_r", "plasma", "plasma_r", "prgn", "prgn_r", "prism", "prism_r", "pubu", "pubu_r",
         "pubugn", "pubugn_r", "puor", "puor_r", "purd", "purd_r", "purples", "purples_r", "qpe",
         "rainbow", "rainbow_r", "rdbu", "rdbu_r", "rdgy", "rdgy_r", "rdpu", "rdpu_r", "rdylbu",
         "rdylbu_r", "rdylgn", "rdylgn_r", "reds", "reds_r", "rplumbo", "schwarzwald", "seismic",
         "seismic_r", "set1", "set1_r", "set2", "set2_r", "set3", "set3_r", "spectral", "spectral_r",
         "spring", "spring_r", "summer", "summer_r", "tab10", "tab10_r", "tab20", "tab20_r", "tab20b",
         "tab20b_r", "tab20c", "tab20c_r", "terrain", "terrain_r", "twilight", "twilight_r",
         "twilight_shifted", "twilight_shifted_r", "usda-cdl", "usda-cdl-corn", "usda-cdl-cotton",
         "usda-cdl-soybeans", "usda-cdl-wheat", "usgs-lcmap", "viirs-10a1", "viirs-13a1", "viirs-14a1",
         "viirs-15a2H", "viridis", "viridis_r", "winter", "winter_r", "wistia", "wistia_r", "ylgn",
         "ylgn_r", "ylgnbu", "ylgnbu_r", "ylorbr", "ylorbr_r", "ylorrd", and "ylorrd_r". Default value
         is None.
        :paramtype color_map_name: str or ~azure.planetarycomputer.models.ColorMapNames
        :keyword color_map: JSON encoded custom Colormap. Default value is None.
        :paramtype color_map: str
        :keyword return_mask: Add mask to the output data. Default value is None.
        :paramtype return_mask: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def crop_geo_json(
        self,
        collection_id: str,
        item_id: str,
        format: str,
        body: IO[bytes],
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        algorithm: Optional[Union[str, _models.TerrainAlgorithm]] = None,
        algorithm_params: Optional[str] = None,
        color_formula: Optional[str] = None,
        coordinate_reference_system: Optional[str] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        max_size: Optional[int] = None,
        height: Optional[int] = None,
        width: Optional[int] = None,
        rescale: Optional[List[str]] = None,
        color_map_name: Optional[Union[str, _models.ColorMapNames]] = None,
        color_map: Optional[str] = None,
        return_mask: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Geojson Crop.

        Create image from a geojson feature.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :param format: Output format for the tile or image (e.g., png, jpeg, webp). Required.
        :type format: str
        :param body: Request GeoJson body. Required.
        :type body: IO[bytes]
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword algorithm: Terrain algorithm name. Known values are: "hillshade", "contours",
         "normalizedIndex", "terrarium", and "terrainrgb". Default value is None.
        :paramtype algorithm: str or ~azure.planetarycomputer.models.TerrainAlgorithm
        :keyword algorithm_params: Terrain algorithm parameters. Default value is None.
        :paramtype algorithm_params: str
        :keyword color_formula: rio-color formula (info: `https://github.com/mapbox/rio-color
         <https://github.com/mapbox/rio-color>`_). Default value is None.
        :paramtype color_formula: str
        :keyword coordinate_reference_system: Coordinate Reference System of the input coords. Default
         to ``epsg:4326``. Default value is None.
        :paramtype coordinate_reference_system: str
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :keyword max_size: Image output size limit if width and height limits are not set. Default
         value is None.
        :paramtype max_size: int
        :keyword height: Height in pixels for the output image. Default value is None.
        :paramtype height: int
        :keyword width: Width in pixels for the output image. Default value is None.
        :paramtype width: int
        :keyword rescale: comma (',') delimited Min,Max range. Can set multiple time for multiple
         bands. Default value is None.
        :paramtype rescale: list[str]
        :keyword color_map_name: Colormap name. Known values are: "accent", "accent_r", "afmhot",
         "afmhot_r", "ai4g-lulc", "alos-fnf", "alos-palsar-mask", "autumn", "autumn_r", "binary",
         "binary_r", "blues", "blues_r", "bone", "bone_r", "brbg", "brbg_r", "brg", "brg_r", "bugn",
         "bugn_r", "bupu", "bupu_r", "bwr", "bwr_r", "c-cap", "cfastie", "chesapeake-lc-13",
         "chesapeake-lc-7", "chesapeake-lu", "chloris-biomass", "cividis", "cividis_r", "cmrmap",
         "cmrmap_r", "cool", "cool_r", "coolwarm", "coolwarm_r", "copper", "copper_r", "cubehelix",
         "cubehelix_r", "dark2", "dark2_r", "drcog-lulc", "esa-cci-lc", "esa-worldcover", "flag",
         "flag_r", "gap-lulc", "gist_earth", "gist_earth_r", "gist_gray", "gist_gray_r", "gist_heat",
         "gist_heat_r", "gist_ncar", "gist_ncar_r", "gist_rainbow", "gist_rainbow_r", "gist_stern",
         "gist_stern_r", "gist_yarg", "gist_yarg_r", "gnbu", "gnbu_r", "gnuplot", "gnuplot2",
         "gnuplot2_r", "gnuplot_r", "gray", "gray_r", "greens", "greens_r", "greys", "greys_r", "hot",
         "hot_r", "hsv", "hsv_r", "inferno", "inferno_r", "io-bii", "io-lulc", "io-lulc-9-class", "jet",
         "jet_r", "jrc-change", "jrc-extent", "jrc-occurrence", "jrc-recurrence", "jrc-seasonality",
         "jrc-transitions", "lidar-classification", "lidar-hag", "lidar-hag-alternative",
         "lidar-intensity", "lidar-returns", "magma", "magma_r", "modis-10A1", "modis-10A2",
         "modis-13A1|Q1", "modis-14A1|A2", "modis-15A2H|A3H", "modis-16A3GF-ET", "modis-16A3GF-PET",
         "modis-17A2H|A2HGF", "modis-17A3HGF", "modis-64A1", "mtbs-severity", "nipy_spectral",
         "nipy_spectral_r", "nrcan-lulc", "ocean", "ocean_r", "oranges", "oranges_r", "orrd", "orrd_r",
         "paired", "paired_r", "pastel1", "pastel1_r", "pastel2", "pastel2_r", "pink", "pink_r", "piyg",
         "piyg_r", "plasma", "plasma_r", "prgn", "prgn_r", "prism", "prism_r", "pubu", "pubu_r",
         "pubugn", "pubugn_r", "puor", "puor_r", "purd", "purd_r", "purples", "purples_r", "qpe",
         "rainbow", "rainbow_r", "rdbu", "rdbu_r", "rdgy", "rdgy_r", "rdpu", "rdpu_r", "rdylbu",
         "rdylbu_r", "rdylgn", "rdylgn_r", "reds", "reds_r", "rplumbo", "schwarzwald", "seismic",
         "seismic_r", "set1", "set1_r", "set2", "set2_r", "set3", "set3_r", "spectral", "spectral_r",
         "spring", "spring_r", "summer", "summer_r", "tab10", "tab10_r", "tab20", "tab20_r", "tab20b",
         "tab20b_r", "tab20c", "tab20c_r", "terrain", "terrain_r", "twilight", "twilight_r",
         "twilight_shifted", "twilight_shifted_r", "usda-cdl", "usda-cdl-corn", "usda-cdl-cotton",
         "usda-cdl-soybeans", "usda-cdl-wheat", "usgs-lcmap", "viirs-10a1", "viirs-13a1", "viirs-14a1",
         "viirs-15a2H", "viridis", "viridis_r", "winter", "winter_r", "wistia", "wistia_r", "ylgn",
         "ylgn_r", "ylgnbu", "ylgnbu_r", "ylorbr", "ylorbr_r", "ylorrd", and "ylorrd_r". Default value
         is None.
        :paramtype color_map_name: str or ~azure.planetarycomputer.models.ColorMapNames
        :keyword color_map: JSON encoded custom Colormap. Default value is None.
        :paramtype color_map: str
        :keyword return_mask: Add mask to the output data. Default value is None.
        :paramtype return_mask: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def crop_geo_json(  # pylint: disable=too-many-locals
        self,
        collection_id: str,
        item_id: str,
        format: str,
        body: Union[_models.Feature, JSON, IO[bytes]],
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        algorithm: Optional[Union[str, _models.TerrainAlgorithm]] = None,
        algorithm_params: Optional[str] = None,
        color_formula: Optional[str] = None,
        coordinate_reference_system: Optional[str] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        max_size: Optional[int] = None,
        height: Optional[int] = None,
        width: Optional[int] = None,
        rescale: Optional[List[str]] = None,
        color_map_name: Optional[Union[str, _models.ColorMapNames]] = None,
        color_map: Optional[str] = None,
        return_mask: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Geojson Crop.

        Create image from a geojson feature.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :param format: Output format for the tile or image (e.g., png, jpeg, webp). Required.
        :type format: str
        :param body: Request GeoJson body. Is one of the following types: Feature, JSON, IO[bytes]
         Required.
        :type body: ~azure.planetarycomputer.models.Feature or JSON or IO[bytes]
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword algorithm: Terrain algorithm name. Known values are: "hillshade", "contours",
         "normalizedIndex", "terrarium", and "terrainrgb". Default value is None.
        :paramtype algorithm: str or ~azure.planetarycomputer.models.TerrainAlgorithm
        :keyword algorithm_params: Terrain algorithm parameters. Default value is None.
        :paramtype algorithm_params: str
        :keyword color_formula: rio-color formula (info: `https://github.com/mapbox/rio-color
         <https://github.com/mapbox/rio-color>`_). Default value is None.
        :paramtype color_formula: str
        :keyword coordinate_reference_system: Coordinate Reference System of the input coords. Default
         to ``epsg:4326``. Default value is None.
        :paramtype coordinate_reference_system: str
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :keyword max_size: Image output size limit if width and height limits are not set. Default
         value is None.
        :paramtype max_size: int
        :keyword height: Height in pixels for the output image. Default value is None.
        :paramtype height: int
        :keyword width: Width in pixels for the output image. Default value is None.
        :paramtype width: int
        :keyword rescale: comma (',') delimited Min,Max range. Can set multiple time for multiple
         bands. Default value is None.
        :paramtype rescale: list[str]
        :keyword color_map_name: Colormap name. Known values are: "accent", "accent_r", "afmhot",
         "afmhot_r", "ai4g-lulc", "alos-fnf", "alos-palsar-mask", "autumn", "autumn_r", "binary",
         "binary_r", "blues", "blues_r", "bone", "bone_r", "brbg", "brbg_r", "brg", "brg_r", "bugn",
         "bugn_r", "bupu", "bupu_r", "bwr", "bwr_r", "c-cap", "cfastie", "chesapeake-lc-13",
         "chesapeake-lc-7", "chesapeake-lu", "chloris-biomass", "cividis", "cividis_r", "cmrmap",
         "cmrmap_r", "cool", "cool_r", "coolwarm", "coolwarm_r", "copper", "copper_r", "cubehelix",
         "cubehelix_r", "dark2", "dark2_r", "drcog-lulc", "esa-cci-lc", "esa-worldcover", "flag",
         "flag_r", "gap-lulc", "gist_earth", "gist_earth_r", "gist_gray", "gist_gray_r", "gist_heat",
         "gist_heat_r", "gist_ncar", "gist_ncar_r", "gist_rainbow", "gist_rainbow_r", "gist_stern",
         "gist_stern_r", "gist_yarg", "gist_yarg_r", "gnbu", "gnbu_r", "gnuplot", "gnuplot2",
         "gnuplot2_r", "gnuplot_r", "gray", "gray_r", "greens", "greens_r", "greys", "greys_r", "hot",
         "hot_r", "hsv", "hsv_r", "inferno", "inferno_r", "io-bii", "io-lulc", "io-lulc-9-class", "jet",
         "jet_r", "jrc-change", "jrc-extent", "jrc-occurrence", "jrc-recurrence", "jrc-seasonality",
         "jrc-transitions", "lidar-classification", "lidar-hag", "lidar-hag-alternative",
         "lidar-intensity", "lidar-returns", "magma", "magma_r", "modis-10A1", "modis-10A2",
         "modis-13A1|Q1", "modis-14A1|A2", "modis-15A2H|A3H", "modis-16A3GF-ET", "modis-16A3GF-PET",
         "modis-17A2H|A2HGF", "modis-17A3HGF", "modis-64A1", "mtbs-severity", "nipy_spectral",
         "nipy_spectral_r", "nrcan-lulc", "ocean", "ocean_r", "oranges", "oranges_r", "orrd", "orrd_r",
         "paired", "paired_r", "pastel1", "pastel1_r", "pastel2", "pastel2_r", "pink", "pink_r", "piyg",
         "piyg_r", "plasma", "plasma_r", "prgn", "prgn_r", "prism", "prism_r", "pubu", "pubu_r",
         "pubugn", "pubugn_r", "puor", "puor_r", "purd", "purd_r", "purples", "purples_r", "qpe",
         "rainbow", "rainbow_r", "rdbu", "rdbu_r", "rdgy", "rdgy_r", "rdpu", "rdpu_r", "rdylbu",
         "rdylbu_r", "rdylgn", "rdylgn_r", "reds", "reds_r", "rplumbo", "schwarzwald", "seismic",
         "seismic_r", "set1", "set1_r", "set2", "set2_r", "set3", "set3_r", "spectral", "spectral_r",
         "spring", "spring_r", "summer", "summer_r", "tab10", "tab10_r", "tab20", "tab20_r", "tab20b",
         "tab20b_r", "tab20c", "tab20c_r", "terrain", "terrain_r", "twilight", "twilight_r",
         "twilight_shifted", "twilight_shifted_r", "usda-cdl", "usda-cdl-corn", "usda-cdl-cotton",
         "usda-cdl-soybeans", "usda-cdl-wheat", "usgs-lcmap", "viirs-10a1", "viirs-13a1", "viirs-14a1",
         "viirs-15a2H", "viridis", "viridis_r", "winter", "winter_r", "wistia", "wistia_r", "ylgn",
         "ylgn_r", "ylgnbu", "ylgnbu_r", "ylorbr", "ylorbr_r", "ylorrd", and "ylorrd_r". Default value
         is None.
        :paramtype color_map_name: str or ~azure.planetarycomputer.models.ColorMapNames
        :keyword color_map: JSON encoded custom Colormap. Default value is None.
        :paramtype color_map: str
        :keyword return_mask: Add mask to the output data. Default value is None.
        :paramtype return_mask: bool
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_data_crop_geo_json_request(
            collection_id=collection_id,
            item_id=item_id,
            format=format,
            assets=assets,
            expression=expression,
            asset_band_indices=asset_band_indices,
            asset_as_band=asset_as_band,
            no_data=no_data,
            unscale=unscale,
            algorithm=algorithm,
            algorithm_params=algorithm_params,
            color_formula=color_formula,
            coordinate_reference_system=coordinate_reference_system,
            resampling=resampling,
            max_size=max_size,
            height=height,
            width=width,
            rescale=rescale,
            color_map_name=color_map_name,
            color_map=color_map,
            return_mask=return_mask,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", True)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def crop_geo_json_with_dimensions(
        self,
        collection_id: str,
        item_id: str,
        width: int,
        height: int,
        format: str,
        body: _models.Feature,
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        algorithm: Optional[Union[str, _models.TerrainAlgorithm]] = None,
        algorithm_params: Optional[str] = None,
        color_formula: Optional[str] = None,
        coordinate_reference_system: Optional[str] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        max_size: Optional[int] = None,
        rescale: Optional[List[str]] = None,
        color_map_name: Optional[Union[str, _models.ColorMapNames]] = None,
        color_map: Optional[str] = None,
        return_mask: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Geojson Crop.

        Create image from a geojson feature.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :param width: Width in pixels for the output image. Required.
        :type width: int
        :param height: Height in pixels for the output image. Required.
        :type height: int
        :param format: Output format for the tile or image (e.g., png, jpeg, webp). Required.
        :type format: str
        :param body: Request GeoJson body. Required.
        :type body: ~azure.planetarycomputer.models.Feature
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword algorithm: Terrain algorithm name. Known values are: "hillshade", "contours",
         "normalizedIndex", "terrarium", and "terrainrgb". Default value is None.
        :paramtype algorithm: str or ~azure.planetarycomputer.models.TerrainAlgorithm
        :keyword algorithm_params: Terrain algorithm parameters. Default value is None.
        :paramtype algorithm_params: str
        :keyword color_formula: rio-color formula (info: `https://github.com/mapbox/rio-color
         <https://github.com/mapbox/rio-color>`_). Default value is None.
        :paramtype color_formula: str
        :keyword coordinate_reference_system: Coordinate Reference System of the input coords. Default
         to ``epsg:4326``. Default value is None.
        :paramtype coordinate_reference_system: str
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :keyword max_size: Image output size limit if width and height limits are not set. Default
         value is None.
        :paramtype max_size: int
        :keyword rescale: comma (',') delimited Min,Max range. Can set multiple time for multiple
         bands. Default value is None.
        :paramtype rescale: list[str]
        :keyword color_map_name: Colormap name. Known values are: "accent", "accent_r", "afmhot",
         "afmhot_r", "ai4g-lulc", "alos-fnf", "alos-palsar-mask", "autumn", "autumn_r", "binary",
         "binary_r", "blues", "blues_r", "bone", "bone_r", "brbg", "brbg_r", "brg", "brg_r", "bugn",
         "bugn_r", "bupu", "bupu_r", "bwr", "bwr_r", "c-cap", "cfastie", "chesapeake-lc-13",
         "chesapeake-lc-7", "chesapeake-lu", "chloris-biomass", "cividis", "cividis_r", "cmrmap",
         "cmrmap_r", "cool", "cool_r", "coolwarm", "coolwarm_r", "copper", "copper_r", "cubehelix",
         "cubehelix_r", "dark2", "dark2_r", "drcog-lulc", "esa-cci-lc", "esa-worldcover", "flag",
         "flag_r", "gap-lulc", "gist_earth", "gist_earth_r", "gist_gray", "gist_gray_r", "gist_heat",
         "gist_heat_r", "gist_ncar", "gist_ncar_r", "gist_rainbow", "gist_rainbow_r", "gist_stern",
         "gist_stern_r", "gist_yarg", "gist_yarg_r", "gnbu", "gnbu_r", "gnuplot", "gnuplot2",
         "gnuplot2_r", "gnuplot_r", "gray", "gray_r", "greens", "greens_r", "greys", "greys_r", "hot",
         "hot_r", "hsv", "hsv_r", "inferno", "inferno_r", "io-bii", "io-lulc", "io-lulc-9-class", "jet",
         "jet_r", "jrc-change", "jrc-extent", "jrc-occurrence", "jrc-recurrence", "jrc-seasonality",
         "jrc-transitions", "lidar-classification", "lidar-hag", "lidar-hag-alternative",
         "lidar-intensity", "lidar-returns", "magma", "magma_r", "modis-10A1", "modis-10A2",
         "modis-13A1|Q1", "modis-14A1|A2", "modis-15A2H|A3H", "modis-16A3GF-ET", "modis-16A3GF-PET",
         "modis-17A2H|A2HGF", "modis-17A3HGF", "modis-64A1", "mtbs-severity", "nipy_spectral",
         "nipy_spectral_r", "nrcan-lulc", "ocean", "ocean_r", "oranges", "oranges_r", "orrd", "orrd_r",
         "paired", "paired_r", "pastel1", "pastel1_r", "pastel2", "pastel2_r", "pink", "pink_r", "piyg",
         "piyg_r", "plasma", "plasma_r", "prgn", "prgn_r", "prism", "prism_r", "pubu", "pubu_r",
         "pubugn", "pubugn_r", "puor", "puor_r", "purd", "purd_r", "purples", "purples_r", "qpe",
         "rainbow", "rainbow_r", "rdbu", "rdbu_r", "rdgy", "rdgy_r", "rdpu", "rdpu_r", "rdylbu",
         "rdylbu_r", "rdylgn", "rdylgn_r", "reds", "reds_r", "rplumbo", "schwarzwald", "seismic",
         "seismic_r", "set1", "set1_r", "set2", "set2_r", "set3", "set3_r", "spectral", "spectral_r",
         "spring", "spring_r", "summer", "summer_r", "tab10", "tab10_r", "tab20", "tab20_r", "tab20b",
         "tab20b_r", "tab20c", "tab20c_r", "terrain", "terrain_r", "twilight", "twilight_r",
         "twilight_shifted", "twilight_shifted_r", "usda-cdl", "usda-cdl-corn", "usda-cdl-cotton",
         "usda-cdl-soybeans", "usda-cdl-wheat", "usgs-lcmap", "viirs-10a1", "viirs-13a1", "viirs-14a1",
         "viirs-15a2H", "viridis", "viridis_r", "winter", "winter_r", "wistia", "wistia_r", "ylgn",
         "ylgn_r", "ylgnbu", "ylgnbu_r", "ylorbr", "ylorbr_r", "ylorrd", and "ylorrd_r". Default value
         is None.
        :paramtype color_map_name: str or ~azure.planetarycomputer.models.ColorMapNames
        :keyword color_map: JSON encoded custom Colormap. Default value is None.
        :paramtype color_map: str
        :keyword return_mask: Add mask to the output data. Default value is None.
        :paramtype return_mask: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def crop_geo_json_with_dimensions(
        self,
        collection_id: str,
        item_id: str,
        width: int,
        height: int,
        format: str,
        body: JSON,
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        algorithm: Optional[Union[str, _models.TerrainAlgorithm]] = None,
        algorithm_params: Optional[str] = None,
        color_formula: Optional[str] = None,
        coordinate_reference_system: Optional[str] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        max_size: Optional[int] = None,
        rescale: Optional[List[str]] = None,
        color_map_name: Optional[Union[str, _models.ColorMapNames]] = None,
        color_map: Optional[str] = None,
        return_mask: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Geojson Crop.

        Create image from a geojson feature.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :param width: Width in pixels for the output image. Required.
        :type width: int
        :param height: Height in pixels for the output image. Required.
        :type height: int
        :param format: Output format for the tile or image (e.g., png, jpeg, webp). Required.
        :type format: str
        :param body: Request GeoJson body. Required.
        :type body: JSON
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword algorithm: Terrain algorithm name. Known values are: "hillshade", "contours",
         "normalizedIndex", "terrarium", and "terrainrgb". Default value is None.
        :paramtype algorithm: str or ~azure.planetarycomputer.models.TerrainAlgorithm
        :keyword algorithm_params: Terrain algorithm parameters. Default value is None.
        :paramtype algorithm_params: str
        :keyword color_formula: rio-color formula (info: `https://github.com/mapbox/rio-color
         <https://github.com/mapbox/rio-color>`_). Default value is None.
        :paramtype color_formula: str
        :keyword coordinate_reference_system: Coordinate Reference System of the input coords. Default
         to ``epsg:4326``. Default value is None.
        :paramtype coordinate_reference_system: str
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :keyword max_size: Image output size limit if width and height limits are not set. Default
         value is None.
        :paramtype max_size: int
        :keyword rescale: comma (',') delimited Min,Max range. Can set multiple time for multiple
         bands. Default value is None.
        :paramtype rescale: list[str]
        :keyword color_map_name: Colormap name. Known values are: "accent", "accent_r", "afmhot",
         "afmhot_r", "ai4g-lulc", "alos-fnf", "alos-palsar-mask", "autumn", "autumn_r", "binary",
         "binary_r", "blues", "blues_r", "bone", "bone_r", "brbg", "brbg_r", "brg", "brg_r", "bugn",
         "bugn_r", "bupu", "bupu_r", "bwr", "bwr_r", "c-cap", "cfastie", "chesapeake-lc-13",
         "chesapeake-lc-7", "chesapeake-lu", "chloris-biomass", "cividis", "cividis_r", "cmrmap",
         "cmrmap_r", "cool", "cool_r", "coolwarm", "coolwarm_r", "copper", "copper_r", "cubehelix",
         "cubehelix_r", "dark2", "dark2_r", "drcog-lulc", "esa-cci-lc", "esa-worldcover", "flag",
         "flag_r", "gap-lulc", "gist_earth", "gist_earth_r", "gist_gray", "gist_gray_r", "gist_heat",
         "gist_heat_r", "gist_ncar", "gist_ncar_r", "gist_rainbow", "gist_rainbow_r", "gist_stern",
         "gist_stern_r", "gist_yarg", "gist_yarg_r", "gnbu", "gnbu_r", "gnuplot", "gnuplot2",
         "gnuplot2_r", "gnuplot_r", "gray", "gray_r", "greens", "greens_r", "greys", "greys_r", "hot",
         "hot_r", "hsv", "hsv_r", "inferno", "inferno_r", "io-bii", "io-lulc", "io-lulc-9-class", "jet",
         "jet_r", "jrc-change", "jrc-extent", "jrc-occurrence", "jrc-recurrence", "jrc-seasonality",
         "jrc-transitions", "lidar-classification", "lidar-hag", "lidar-hag-alternative",
         "lidar-intensity", "lidar-returns", "magma", "magma_r", "modis-10A1", "modis-10A2",
         "modis-13A1|Q1", "modis-14A1|A2", "modis-15A2H|A3H", "modis-16A3GF-ET", "modis-16A3GF-PET",
         "modis-17A2H|A2HGF", "modis-17A3HGF", "modis-64A1", "mtbs-severity", "nipy_spectral",
         "nipy_spectral_r", "nrcan-lulc", "ocean", "ocean_r", "oranges", "oranges_r", "orrd", "orrd_r",
         "paired", "paired_r", "pastel1", "pastel1_r", "pastel2", "pastel2_r", "pink", "pink_r", "piyg",
         "piyg_r", "plasma", "plasma_r", "prgn", "prgn_r", "prism", "prism_r", "pubu", "pubu_r",
         "pubugn", "pubugn_r", "puor", "puor_r", "purd", "purd_r", "purples", "purples_r", "qpe",
         "rainbow", "rainbow_r", "rdbu", "rdbu_r", "rdgy", "rdgy_r", "rdpu", "rdpu_r", "rdylbu",
         "rdylbu_r", "rdylgn", "rdylgn_r", "reds", "reds_r", "rplumbo", "schwarzwald", "seismic",
         "seismic_r", "set1", "set1_r", "set2", "set2_r", "set3", "set3_r", "spectral", "spectral_r",
         "spring", "spring_r", "summer", "summer_r", "tab10", "tab10_r", "tab20", "tab20_r", "tab20b",
         "tab20b_r", "tab20c", "tab20c_r", "terrain", "terrain_r", "twilight", "twilight_r",
         "twilight_shifted", "twilight_shifted_r", "usda-cdl", "usda-cdl-corn", "usda-cdl-cotton",
         "usda-cdl-soybeans", "usda-cdl-wheat", "usgs-lcmap", "viirs-10a1", "viirs-13a1", "viirs-14a1",
         "viirs-15a2H", "viridis", "viridis_r", "winter", "winter_r", "wistia", "wistia_r", "ylgn",
         "ylgn_r", "ylgnbu", "ylgnbu_r", "ylorbr", "ylorbr_r", "ylorrd", and "ylorrd_r". Default value
         is None.
        :paramtype color_map_name: str or ~azure.planetarycomputer.models.ColorMapNames
        :keyword color_map: JSON encoded custom Colormap. Default value is None.
        :paramtype color_map: str
        :keyword return_mask: Add mask to the output data. Default value is None.
        :paramtype return_mask: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def crop_geo_json_with_dimensions(
        self,
        collection_id: str,
        item_id: str,
        width: int,
        height: int,
        format: str,
        body: IO[bytes],
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        algorithm: Optional[Union[str, _models.TerrainAlgorithm]] = None,
        algorithm_params: Optional[str] = None,
        color_formula: Optional[str] = None,
        coordinate_reference_system: Optional[str] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        max_size: Optional[int] = None,
        rescale: Optional[List[str]] = None,
        color_map_name: Optional[Union[str, _models.ColorMapNames]] = None,
        color_map: Optional[str] = None,
        return_mask: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Geojson Crop.

        Create image from a geojson feature.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :param width: Width in pixels for the output image. Required.
        :type width: int
        :param height: Height in pixels for the output image. Required.
        :type height: int
        :param format: Output format for the tile or image (e.g., png, jpeg, webp). Required.
        :type format: str
        :param body: Request GeoJson body. Required.
        :type body: IO[bytes]
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword algorithm: Terrain algorithm name. Known values are: "hillshade", "contours",
         "normalizedIndex", "terrarium", and "terrainrgb". Default value is None.
        :paramtype algorithm: str or ~azure.planetarycomputer.models.TerrainAlgorithm
        :keyword algorithm_params: Terrain algorithm parameters. Default value is None.
        :paramtype algorithm_params: str
        :keyword color_formula: rio-color formula (info: `https://github.com/mapbox/rio-color
         <https://github.com/mapbox/rio-color>`_). Default value is None.
        :paramtype color_formula: str
        :keyword coordinate_reference_system: Coordinate Reference System of the input coords. Default
         to ``epsg:4326``. Default value is None.
        :paramtype coordinate_reference_system: str
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :keyword max_size: Image output size limit if width and height limits are not set. Default
         value is None.
        :paramtype max_size: int
        :keyword rescale: comma (',') delimited Min,Max range. Can set multiple time for multiple
         bands. Default value is None.
        :paramtype rescale: list[str]
        :keyword color_map_name: Colormap name. Known values are: "accent", "accent_r", "afmhot",
         "afmhot_r", "ai4g-lulc", "alos-fnf", "alos-palsar-mask", "autumn", "autumn_r", "binary",
         "binary_r", "blues", "blues_r", "bone", "bone_r", "brbg", "brbg_r", "brg", "brg_r", "bugn",
         "bugn_r", "bupu", "bupu_r", "bwr", "bwr_r", "c-cap", "cfastie", "chesapeake-lc-13",
         "chesapeake-lc-7", "chesapeake-lu", "chloris-biomass", "cividis", "cividis_r", "cmrmap",
         "cmrmap_r", "cool", "cool_r", "coolwarm", "coolwarm_r", "copper", "copper_r", "cubehelix",
         "cubehelix_r", "dark2", "dark2_r", "drcog-lulc", "esa-cci-lc", "esa-worldcover", "flag",
         "flag_r", "gap-lulc", "gist_earth", "gist_earth_r", "gist_gray", "gist_gray_r", "gist_heat",
         "gist_heat_r", "gist_ncar", "gist_ncar_r", "gist_rainbow", "gist_rainbow_r", "gist_stern",
         "gist_stern_r", "gist_yarg", "gist_yarg_r", "gnbu", "gnbu_r", "gnuplot", "gnuplot2",
         "gnuplot2_r", "gnuplot_r", "gray", "gray_r", "greens", "greens_r", "greys", "greys_r", "hot",
         "hot_r", "hsv", "hsv_r", "inferno", "inferno_r", "io-bii", "io-lulc", "io-lulc-9-class", "jet",
         "jet_r", "jrc-change", "jrc-extent", "jrc-occurrence", "jrc-recurrence", "jrc-seasonality",
         "jrc-transitions", "lidar-classification", "lidar-hag", "lidar-hag-alternative",
         "lidar-intensity", "lidar-returns", "magma", "magma_r", "modis-10A1", "modis-10A2",
         "modis-13A1|Q1", "modis-14A1|A2", "modis-15A2H|A3H", "modis-16A3GF-ET", "modis-16A3GF-PET",
         "modis-17A2H|A2HGF", "modis-17A3HGF", "modis-64A1", "mtbs-severity", "nipy_spectral",
         "nipy_spectral_r", "nrcan-lulc", "ocean", "ocean_r", "oranges", "oranges_r", "orrd", "orrd_r",
         "paired", "paired_r", "pastel1", "pastel1_r", "pastel2", "pastel2_r", "pink", "pink_r", "piyg",
         "piyg_r", "plasma", "plasma_r", "prgn", "prgn_r", "prism", "prism_r", "pubu", "pubu_r",
         "pubugn", "pubugn_r", "puor", "puor_r", "purd", "purd_r", "purples", "purples_r", "qpe",
         "rainbow", "rainbow_r", "rdbu", "rdbu_r", "rdgy", "rdgy_r", "rdpu", "rdpu_r", "rdylbu",
         "rdylbu_r", "rdylgn", "rdylgn_r", "reds", "reds_r", "rplumbo", "schwarzwald", "seismic",
         "seismic_r", "set1", "set1_r", "set2", "set2_r", "set3", "set3_r", "spectral", "spectral_r",
         "spring", "spring_r", "summer", "summer_r", "tab10", "tab10_r", "tab20", "tab20_r", "tab20b",
         "tab20b_r", "tab20c", "tab20c_r", "terrain", "terrain_r", "twilight", "twilight_r",
         "twilight_shifted", "twilight_shifted_r", "usda-cdl", "usda-cdl-corn", "usda-cdl-cotton",
         "usda-cdl-soybeans", "usda-cdl-wheat", "usgs-lcmap", "viirs-10a1", "viirs-13a1", "viirs-14a1",
         "viirs-15a2H", "viridis", "viridis_r", "winter", "winter_r", "wistia", "wistia_r", "ylgn",
         "ylgn_r", "ylgnbu", "ylgnbu_r", "ylorbr", "ylorbr_r", "ylorrd", and "ylorrd_r". Default value
         is None.
        :paramtype color_map_name: str or ~azure.planetarycomputer.models.ColorMapNames
        :keyword color_map: JSON encoded custom Colormap. Default value is None.
        :paramtype color_map: str
        :keyword return_mask: Add mask to the output data. Default value is None.
        :paramtype return_mask: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def crop_geo_json_with_dimensions(  # pylint: disable=too-many-locals
        self,
        collection_id: str,
        item_id: str,
        width: int,
        height: int,
        format: str,
        body: Union[_models.Feature, JSON, IO[bytes]],
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        algorithm: Optional[Union[str, _models.TerrainAlgorithm]] = None,
        algorithm_params: Optional[str] = None,
        color_formula: Optional[str] = None,
        coordinate_reference_system: Optional[str] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        max_size: Optional[int] = None,
        rescale: Optional[List[str]] = None,
        color_map_name: Optional[Union[str, _models.ColorMapNames]] = None,
        color_map: Optional[str] = None,
        return_mask: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Geojson Crop.

        Create image from a geojson feature.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :param width: Width in pixels for the output image. Required.
        :type width: int
        :param height: Height in pixels for the output image. Required.
        :type height: int
        :param format: Output format for the tile or image (e.g., png, jpeg, webp). Required.
        :type format: str
        :param body: Request GeoJson body. Is one of the following types: Feature, JSON, IO[bytes]
         Required.
        :type body: ~azure.planetarycomputer.models.Feature or JSON or IO[bytes]
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword algorithm: Terrain algorithm name. Known values are: "hillshade", "contours",
         "normalizedIndex", "terrarium", and "terrainrgb". Default value is None.
        :paramtype algorithm: str or ~azure.planetarycomputer.models.TerrainAlgorithm
        :keyword algorithm_params: Terrain algorithm parameters. Default value is None.
        :paramtype algorithm_params: str
        :keyword color_formula: rio-color formula (info: `https://github.com/mapbox/rio-color
         <https://github.com/mapbox/rio-color>`_). Default value is None.
        :paramtype color_formula: str
        :keyword coordinate_reference_system: Coordinate Reference System of the input coords. Default
         to ``epsg:4326``. Default value is None.
        :paramtype coordinate_reference_system: str
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :keyword max_size: Image output size limit if width and height limits are not set. Default
         value is None.
        :paramtype max_size: int
        :keyword rescale: comma (',') delimited Min,Max range. Can set multiple time for multiple
         bands. Default value is None.
        :paramtype rescale: list[str]
        :keyword color_map_name: Colormap name. Known values are: "accent", "accent_r", "afmhot",
         "afmhot_r", "ai4g-lulc", "alos-fnf", "alos-palsar-mask", "autumn", "autumn_r", "binary",
         "binary_r", "blues", "blues_r", "bone", "bone_r", "brbg", "brbg_r", "brg", "brg_r", "bugn",
         "bugn_r", "bupu", "bupu_r", "bwr", "bwr_r", "c-cap", "cfastie", "chesapeake-lc-13",
         "chesapeake-lc-7", "chesapeake-lu", "chloris-biomass", "cividis", "cividis_r", "cmrmap",
         "cmrmap_r", "cool", "cool_r", "coolwarm", "coolwarm_r", "copper", "copper_r", "cubehelix",
         "cubehelix_r", "dark2", "dark2_r", "drcog-lulc", "esa-cci-lc", "esa-worldcover", "flag",
         "flag_r", "gap-lulc", "gist_earth", "gist_earth_r", "gist_gray", "gist_gray_r", "gist_heat",
         "gist_heat_r", "gist_ncar", "gist_ncar_r", "gist_rainbow", "gist_rainbow_r", "gist_stern",
         "gist_stern_r", "gist_yarg", "gist_yarg_r", "gnbu", "gnbu_r", "gnuplot", "gnuplot2",
         "gnuplot2_r", "gnuplot_r", "gray", "gray_r", "greens", "greens_r", "greys", "greys_r", "hot",
         "hot_r", "hsv", "hsv_r", "inferno", "inferno_r", "io-bii", "io-lulc", "io-lulc-9-class", "jet",
         "jet_r", "jrc-change", "jrc-extent", "jrc-occurrence", "jrc-recurrence", "jrc-seasonality",
         "jrc-transitions", "lidar-classification", "lidar-hag", "lidar-hag-alternative",
         "lidar-intensity", "lidar-returns", "magma", "magma_r", "modis-10A1", "modis-10A2",
         "modis-13A1|Q1", "modis-14A1|A2", "modis-15A2H|A3H", "modis-16A3GF-ET", "modis-16A3GF-PET",
         "modis-17A2H|A2HGF", "modis-17A3HGF", "modis-64A1", "mtbs-severity", "nipy_spectral",
         "nipy_spectral_r", "nrcan-lulc", "ocean", "ocean_r", "oranges", "oranges_r", "orrd", "orrd_r",
         "paired", "paired_r", "pastel1", "pastel1_r", "pastel2", "pastel2_r", "pink", "pink_r", "piyg",
         "piyg_r", "plasma", "plasma_r", "prgn", "prgn_r", "prism", "prism_r", "pubu", "pubu_r",
         "pubugn", "pubugn_r", "puor", "puor_r", "purd", "purd_r", "purples", "purples_r", "qpe",
         "rainbow", "rainbow_r", "rdbu", "rdbu_r", "rdgy", "rdgy_r", "rdpu", "rdpu_r", "rdylbu",
         "rdylbu_r", "rdylgn", "rdylgn_r", "reds", "reds_r", "rplumbo", "schwarzwald", "seismic",
         "seismic_r", "set1", "set1_r", "set2", "set2_r", "set3", "set3_r", "spectral", "spectral_r",
         "spring", "spring_r", "summer", "summer_r", "tab10", "tab10_r", "tab20", "tab20_r", "tab20b",
         "tab20b_r", "tab20c", "tab20c_r", "terrain", "terrain_r", "twilight", "twilight_r",
         "twilight_shifted", "twilight_shifted_r", "usda-cdl", "usda-cdl-corn", "usda-cdl-cotton",
         "usda-cdl-soybeans", "usda-cdl-wheat", "usgs-lcmap", "viirs-10a1", "viirs-13a1", "viirs-14a1",
         "viirs-15a2H", "viridis", "viridis_r", "winter", "winter_r", "wistia", "wistia_r", "ylgn",
         "ylgn_r", "ylgnbu", "ylgnbu_r", "ylorbr", "ylorbr_r", "ylorrd", and "ylorrd_r". Default value
         is None.
        :paramtype color_map_name: str or ~azure.planetarycomputer.models.ColorMapNames
        :keyword color_map: JSON encoded custom Colormap. Default value is None.
        :paramtype color_map: str
        :keyword return_mask: Add mask to the output data. Default value is None.
        :paramtype return_mask: bool
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_data_crop_geo_json_with_dimensions_request(
            collection_id=collection_id,
            item_id=item_id,
            width=width,
            height=height,
            format=format,
            assets=assets,
            expression=expression,
            asset_band_indices=asset_band_indices,
            asset_as_band=asset_as_band,
            no_data=no_data,
            unscale=unscale,
            algorithm=algorithm,
            algorithm_params=algorithm_params,
            color_formula=color_formula,
            coordinate_reference_system=coordinate_reference_system,
            resampling=resampling,
            max_size=max_size,
            rescale=rescale,
            color_map_name=color_map_name,
            color_map=color_map,
            return_mask=return_mask,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", True)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def get_geo_json_statistics(
        self,
        collection_id: str,
        item_id: str,
        body: _models.Feature,
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        coordinate_reference_system: Optional[str] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        max_size: Optional[int] = None,
        categorical: Optional[bool] = None,
        categories_pixels: Optional[List[str]] = None,
        percentiles: Optional[List[int]] = None,
        histogram_bins: Optional[str] = None,
        histogram_range: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StacItemStatisticsGeoJson:
        """Geojson Statistics.

        Get Statistics from a geojson feature.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :param body: Request GeoJson body. Required.
        :type body: ~azure.planetarycomputer.models.Feature
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword coordinate_reference_system: Coordinate Reference System of the input coords. Default
         to ``epsg:4326``. Default value is None.
        :paramtype coordinate_reference_system: str
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :keyword max_size: Maximum dimension in pixels for the source data used to calculate
         statistics. Default value is None.
        :paramtype max_size: int
        :keyword categorical: Return statistics for categorical dataset. Default value is None.
        :paramtype categorical: bool
        :keyword categories_pixels: List of pixel categorical values for which to report counts.
         Default value is None.
        :paramtype categories_pixels: list[str]
        :keyword percentiles: List of percentile values (default to [2, 98]). Default value is None.
        :paramtype percentiles: list[int]
        :keyword histogram_bins: Defines the number of equal-width bins in the given range (10, by
         default).

         If bins is a sequence (comma ``,`` delimited values), it defines a monotonically
         increasing array of bin edges, including the rightmost edge, allowing for
         non-uniform bin widths.

         link: `https://numpy.org/doc/stable/reference/generated/numpy.histogram.html
         <https://numpy.org/doc/stable/reference/generated/numpy.histogram.html>`_. Default value is
         None.
        :paramtype histogram_bins: str
        :keyword histogram_range: Comma ``,`` delimited range of the bins.

         The lower and upper range of the bins. If not provided, range is simply
         (a.min(), a.max()).

         Values outside the range are ignored. The first element of the range must be
         less than or equal to the second.
         range affects the automatic bin computation as well.

         link: `https://numpy.org/doc/stable/reference/generated/numpy.histogram.html
         <https://numpy.org/doc/stable/reference/generated/numpy.histogram.html>`_. Default value is
         None.
        :paramtype histogram_range: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StacItemStatisticsGeoJson. The StacItemStatisticsGeoJson is compatible with
         MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacItemStatisticsGeoJson
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def get_geo_json_statistics(
        self,
        collection_id: str,
        item_id: str,
        body: JSON,
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        coordinate_reference_system: Optional[str] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        max_size: Optional[int] = None,
        categorical: Optional[bool] = None,
        categories_pixels: Optional[List[str]] = None,
        percentiles: Optional[List[int]] = None,
        histogram_bins: Optional[str] = None,
        histogram_range: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StacItemStatisticsGeoJson:
        """Geojson Statistics.

        Get Statistics from a geojson feature.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :param body: Request GeoJson body. Required.
        :type body: JSON
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword coordinate_reference_system: Coordinate Reference System of the input coords. Default
         to ``epsg:4326``. Default value is None.
        :paramtype coordinate_reference_system: str
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :keyword max_size: Maximum dimension in pixels for the source data used to calculate
         statistics. Default value is None.
        :paramtype max_size: int
        :keyword categorical: Return statistics for categorical dataset. Default value is None.
        :paramtype categorical: bool
        :keyword categories_pixels: List of pixel categorical values for which to report counts.
         Default value is None.
        :paramtype categories_pixels: list[str]
        :keyword percentiles: List of percentile values (default to [2, 98]). Default value is None.
        :paramtype percentiles: list[int]
        :keyword histogram_bins: Defines the number of equal-width bins in the given range (10, by
         default).

         If bins is a sequence (comma ``,`` delimited values), it defines a monotonically
         increasing array of bin edges, including the rightmost edge, allowing for
         non-uniform bin widths.

         link: `https://numpy.org/doc/stable/reference/generated/numpy.histogram.html
         <https://numpy.org/doc/stable/reference/generated/numpy.histogram.html>`_. Default value is
         None.
        :paramtype histogram_bins: str
        :keyword histogram_range: Comma ``,`` delimited range of the bins.

         The lower and upper range of the bins. If not provided, range is simply
         (a.min(), a.max()).

         Values outside the range are ignored. The first element of the range must be
         less than or equal to the second.
         range affects the automatic bin computation as well.

         link: `https://numpy.org/doc/stable/reference/generated/numpy.histogram.html
         <https://numpy.org/doc/stable/reference/generated/numpy.histogram.html>`_. Default value is
         None.
        :paramtype histogram_range: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StacItemStatisticsGeoJson. The StacItemStatisticsGeoJson is compatible with
         MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacItemStatisticsGeoJson
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def get_geo_json_statistics(
        self,
        collection_id: str,
        item_id: str,
        body: IO[bytes],
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        coordinate_reference_system: Optional[str] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        max_size: Optional[int] = None,
        categorical: Optional[bool] = None,
        categories_pixels: Optional[List[str]] = None,
        percentiles: Optional[List[int]] = None,
        histogram_bins: Optional[str] = None,
        histogram_range: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StacItemStatisticsGeoJson:
        """Geojson Statistics.

        Get Statistics from a geojson feature.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :param body: Request GeoJson body. Required.
        :type body: IO[bytes]
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword coordinate_reference_system: Coordinate Reference System of the input coords. Default
         to ``epsg:4326``. Default value is None.
        :paramtype coordinate_reference_system: str
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :keyword max_size: Maximum dimension in pixels for the source data used to calculate
         statistics. Default value is None.
        :paramtype max_size: int
        :keyword categorical: Return statistics for categorical dataset. Default value is None.
        :paramtype categorical: bool
        :keyword categories_pixels: List of pixel categorical values for which to report counts.
         Default value is None.
        :paramtype categories_pixels: list[str]
        :keyword percentiles: List of percentile values (default to [2, 98]). Default value is None.
        :paramtype percentiles: list[int]
        :keyword histogram_bins: Defines the number of equal-width bins in the given range (10, by
         default).

         If bins is a sequence (comma ``,`` delimited values), it defines a monotonically
         increasing array of bin edges, including the rightmost edge, allowing for
         non-uniform bin widths.

         link: `https://numpy.org/doc/stable/reference/generated/numpy.histogram.html
         <https://numpy.org/doc/stable/reference/generated/numpy.histogram.html>`_. Default value is
         None.
        :paramtype histogram_bins: str
        :keyword histogram_range: Comma ``,`` delimited range of the bins.

         The lower and upper range of the bins. If not provided, range is simply
         (a.min(), a.max()).

         Values outside the range are ignored. The first element of the range must be
         less than or equal to the second.
         range affects the automatic bin computation as well.

         link: `https://numpy.org/doc/stable/reference/generated/numpy.histogram.html
         <https://numpy.org/doc/stable/reference/generated/numpy.histogram.html>`_. Default value is
         None.
        :paramtype histogram_range: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StacItemStatisticsGeoJson. The StacItemStatisticsGeoJson is compatible with
         MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacItemStatisticsGeoJson
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def get_geo_json_statistics(  # pylint: disable=too-many-locals
        self,
        collection_id: str,
        item_id: str,
        body: Union[_models.Feature, JSON, IO[bytes]],
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        coordinate_reference_system: Optional[str] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        max_size: Optional[int] = None,
        categorical: Optional[bool] = None,
        categories_pixels: Optional[List[str]] = None,
        percentiles: Optional[List[int]] = None,
        histogram_bins: Optional[str] = None,
        histogram_range: Optional[str] = None,
        **kwargs: Any
    ) -> _models.StacItemStatisticsGeoJson:
        """Geojson Statistics.

        Get Statistics from a geojson feature.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :param body: Request GeoJson body. Is one of the following types: Feature, JSON, IO[bytes]
         Required.
        :type body: ~azure.planetarycomputer.models.Feature or JSON or IO[bytes]
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword coordinate_reference_system: Coordinate Reference System of the input coords. Default
         to ``epsg:4326``. Default value is None.
        :paramtype coordinate_reference_system: str
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :keyword max_size: Maximum dimension in pixels for the source data used to calculate
         statistics. Default value is None.
        :paramtype max_size: int
        :keyword categorical: Return statistics for categorical dataset. Default value is None.
        :paramtype categorical: bool
        :keyword categories_pixels: List of pixel categorical values for which to report counts.
         Default value is None.
        :paramtype categories_pixels: list[str]
        :keyword percentiles: List of percentile values (default to [2, 98]). Default value is None.
        :paramtype percentiles: list[int]
        :keyword histogram_bins: Defines the number of equal-width bins in the given range (10, by
         default).

         If bins is a sequence (comma ``,`` delimited values), it defines a monotonically
         increasing array of bin edges, including the rightmost edge, allowing for
         non-uniform bin widths.

         link: `https://numpy.org/doc/stable/reference/generated/numpy.histogram.html
         <https://numpy.org/doc/stable/reference/generated/numpy.histogram.html>`_. Default value is
         None.
        :paramtype histogram_bins: str
        :keyword histogram_range: Comma ``,`` delimited range of the bins.

         The lower and upper range of the bins. If not provided, range is simply
         (a.min(), a.max()).

         Values outside the range are ignored. The first element of the range must be
         less than or equal to the second.
         range affects the automatic bin computation as well.

         link: `https://numpy.org/doc/stable/reference/generated/numpy.histogram.html
         <https://numpy.org/doc/stable/reference/generated/numpy.histogram.html>`_. Default value is
         None.
        :paramtype histogram_range: str
        :return: StacItemStatisticsGeoJson. The StacItemStatisticsGeoJson is compatible with
         MutableMapping
        :rtype: ~azure.planetarycomputer.models.StacItemStatisticsGeoJson
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StacItemStatisticsGeoJson] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_data_get_geo_json_statistics_request(
            collection_id=collection_id,
            item_id=item_id,
            assets=assets,
            expression=expression,
            asset_band_indices=asset_band_indices,
            asset_as_band=asset_as_band,
            no_data=no_data,
            unscale=unscale,
            coordinate_reference_system=coordinate_reference_system,
            resampling=resampling,
            max_size=max_size,
            categorical=categorical,
            categories_pixels=categories_pixels,
            percentiles=percentiles,
            histogram_bins=histogram_bins,
            histogram_range=histogram_range,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.StacItemStatisticsGeoJson, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_info_geo_json(
        self, collection_id: str, item_id: str, *, assets: Optional[List[str]] = None, **kwargs: Any
    ) -> _models.TilerInfoGeoJsonFeature:
        """Info Geojson.

        Return Info Geojson.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :return: TilerInfoGeoJsonFeature. The TilerInfoGeoJsonFeature is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.TilerInfoGeoJsonFeature
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TilerInfoGeoJsonFeature] = kwargs.pop("cls", None)

        _request = build_data_get_info_geo_json_request(
            collection_id=collection_id,
            item_id=item_id,
            assets=assets,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TilerInfoGeoJsonFeature, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_item_asset_details(
        self, collection_id: str, item_id: str, *, assets: Optional[List[str]] = None, **kwargs: Any
    ) -> _models.TilerInfoMapResponse:
        """Info.

        Return dataset's basic info.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :return: TilerInfoMapResponse. The TilerInfoMapResponse is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.TilerInfoMapResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TilerInfoMapResponse] = kwargs.pop("cls", None)

        _request = build_data_get_item_asset_details_request(
            collection_id=collection_id,
            item_id=item_id,
            assets=assets,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TilerInfoMapResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_part(  # pylint: disable=too-many-locals
        self,
        collection_id: str,
        item_id: str,
        minx: float,
        miny: float,
        maxx: float,
        maxy: float,
        format: str,
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        algorithm: Optional[Union[str, _models.TerrainAlgorithm]] = None,
        algorithm_params: Optional[str] = None,
        color_formula: Optional[str] = None,
        dst_crs: Optional[str] = None,
        coordinate_reference_system: Optional[str] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        max_size: Optional[int] = None,
        height: Optional[int] = None,
        width: Optional[int] = None,
        rescale: Optional[List[str]] = None,
        color_map_name: Optional[Union[str, _models.ColorMapNames]] = None,
        color_map: Optional[str] = None,
        return_mask: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Part.

        Create image from part of a dataset.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :param minx: Bounding box min X. Required.
        :type minx: float
        :param miny: Bounding box min Y. Required.
        :type miny: float
        :param maxx: Bounding box max X. Required.
        :type maxx: float
        :param maxy: Bounding box max Y. Required.
        :type maxy: float
        :param format: Output format for the tile or image (e.g., png, jpeg, webp). Required.
        :type format: str
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword algorithm: Terrain algorithm name. Known values are: "hillshade", "contours",
         "normalizedIndex", "terrarium", and "terrainrgb". Default value is None.
        :paramtype algorithm: str or ~azure.planetarycomputer.models.TerrainAlgorithm
        :keyword algorithm_params: Terrain algorithm parameters. Default value is None.
        :paramtype algorithm_params: str
        :keyword color_formula: rio-color formula (info: `https://github.com/mapbox/rio-color
         <https://github.com/mapbox/rio-color>`_). Default value is None.
        :paramtype color_formula: str
        :keyword dst_crs: Output Coordinate Reference System. Default value is None.
        :paramtype dst_crs: str
        :keyword coordinate_reference_system: Coordinate Reference System of the input coords. Default
         to ``epsg:4326``. Default value is None.
        :paramtype coordinate_reference_system: str
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :keyword max_size: Image output size limit if width and height limits are not set. Default
         value is None.
        :paramtype max_size: int
        :keyword height: Height in pixels for the output image. Default value is None.
        :paramtype height: int
        :keyword width: Width in pixels for the output image. Default value is None.
        :paramtype width: int
        :keyword rescale: comma (',') delimited Min,Max range. Can set multiple time for multiple
         bands. Default value is None.
        :paramtype rescale: list[str]
        :keyword color_map_name: Colormap name. Known values are: "accent", "accent_r", "afmhot",
         "afmhot_r", "ai4g-lulc", "alos-fnf", "alos-palsar-mask", "autumn", "autumn_r", "binary",
         "binary_r", "blues", "blues_r", "bone", "bone_r", "brbg", "brbg_r", "brg", "brg_r", "bugn",
         "bugn_r", "bupu", "bupu_r", "bwr", "bwr_r", "c-cap", "cfastie", "chesapeake-lc-13",
         "chesapeake-lc-7", "chesapeake-lu", "chloris-biomass", "cividis", "cividis_r", "cmrmap",
         "cmrmap_r", "cool", "cool_r", "coolwarm", "coolwarm_r", "copper", "copper_r", "cubehelix",
         "cubehelix_r", "dark2", "dark2_r", "drcog-lulc", "esa-cci-lc", "esa-worldcover", "flag",
         "flag_r", "gap-lulc", "gist_earth", "gist_earth_r", "gist_gray", "gist_gray_r", "gist_heat",
         "gist_heat_r", "gist_ncar", "gist_ncar_r", "gist_rainbow", "gist_rainbow_r", "gist_stern",
         "gist_stern_r", "gist_yarg", "gist_yarg_r", "gnbu", "gnbu_r", "gnuplot", "gnuplot2",
         "gnuplot2_r", "gnuplot_r", "gray", "gray_r", "greens", "greens_r", "greys", "greys_r", "hot",
         "hot_r", "hsv", "hsv_r", "inferno", "inferno_r", "io-bii", "io-lulc", "io-lulc-9-class", "jet",
         "jet_r", "jrc-change", "jrc-extent", "jrc-occurrence", "jrc-recurrence", "jrc-seasonality",
         "jrc-transitions", "lidar-classification", "lidar-hag", "lidar-hag-alternative",
         "lidar-intensity", "lidar-returns", "magma", "magma_r", "modis-10A1", "modis-10A2",
         "modis-13A1|Q1", "modis-14A1|A2", "modis-15A2H|A3H", "modis-16A3GF-ET", "modis-16A3GF-PET",
         "modis-17A2H|A2HGF", "modis-17A3HGF", "modis-64A1", "mtbs-severity", "nipy_spectral",
         "nipy_spectral_r", "nrcan-lulc", "ocean", "ocean_r", "oranges", "oranges_r", "orrd", "orrd_r",
         "paired", "paired_r", "pastel1", "pastel1_r", "pastel2", "pastel2_r", "pink", "pink_r", "piyg",
         "piyg_r", "plasma", "plasma_r", "prgn", "prgn_r", "prism", "prism_r", "pubu", "pubu_r",
         "pubugn", "pubugn_r", "puor", "puor_r", "purd", "purd_r", "purples", "purples_r", "qpe",
         "rainbow", "rainbow_r", "rdbu", "rdbu_r", "rdgy", "rdgy_r", "rdpu", "rdpu_r", "rdylbu",
         "rdylbu_r", "rdylgn", "rdylgn_r", "reds", "reds_r", "rplumbo", "schwarzwald", "seismic",
         "seismic_r", "set1", "set1_r", "set2", "set2_r", "set3", "set3_r", "spectral", "spectral_r",
         "spring", "spring_r", "summer", "summer_r", "tab10", "tab10_r", "tab20", "tab20_r", "tab20b",
         "tab20b_r", "tab20c", "tab20c_r", "terrain", "terrain_r", "twilight", "twilight_r",
         "twilight_shifted", "twilight_shifted_r", "usda-cdl", "usda-cdl-corn", "usda-cdl-cotton",
         "usda-cdl-soybeans", "usda-cdl-wheat", "usgs-lcmap", "viirs-10a1", "viirs-13a1", "viirs-14a1",
         "viirs-15a2H", "viridis", "viridis_r", "winter", "winter_r", "wistia", "wistia_r", "ylgn",
         "ylgn_r", "ylgnbu", "ylgnbu_r", "ylorbr", "ylorbr_r", "ylorrd", and "ylorrd_r". Default value
         is None.
        :paramtype color_map_name: str or ~azure.planetarycomputer.models.ColorMapNames
        :keyword color_map: JSON encoded custom Colormap. Default value is None.
        :paramtype color_map: str
        :keyword return_mask: Add mask to the output data. Default value is None.
        :paramtype return_mask: bool
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_data_get_part_request(
            collection_id=collection_id,
            item_id=item_id,
            minx=minx,
            miny=miny,
            maxx=maxx,
            maxy=maxy,
            format=format,
            assets=assets,
            expression=expression,
            asset_band_indices=asset_band_indices,
            asset_as_band=asset_as_band,
            no_data=no_data,
            unscale=unscale,
            algorithm=algorithm,
            algorithm_params=algorithm_params,
            color_formula=color_formula,
            dst_crs=dst_crs,
            coordinate_reference_system=coordinate_reference_system,
            resampling=resampling,
            max_size=max_size,
            height=height,
            width=width,
            rescale=rescale,
            color_map_name=color_map_name,
            color_map=color_map,
            return_mask=return_mask,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", True)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_part_with_dimensions(  # pylint: disable=too-many-locals
        self,
        collection_id: str,
        item_id: str,
        minx: float,
        miny: float,
        maxx: float,
        maxy: float,
        width: int,
        height: int,
        format: str,
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        algorithm: Optional[Union[str, _models.TerrainAlgorithm]] = None,
        algorithm_params: Optional[str] = None,
        color_formula: Optional[str] = None,
        dst_crs: Optional[str] = None,
        coordinate_reference_system: Optional[str] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        max_size: Optional[int] = None,
        rescale: Optional[List[str]] = None,
        color_map_name: Optional[Union[str, _models.ColorMapNames]] = None,
        color_map: Optional[str] = None,
        return_mask: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Part.

        Create image from part of a dataset.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :param minx: Bounding box min X. Required.
        :type minx: float
        :param miny: Bounding box min Y. Required.
        :type miny: float
        :param maxx: Bounding box max X. Required.
        :type maxx: float
        :param maxy: Bounding box max Y. Required.
        :type maxy: float
        :param width: Width in pixels for the output image. Required.
        :type width: int
        :param height: Height in pixels for the output image. Required.
        :type height: int
        :param format: Output format for the tile or image (e.g., png, jpeg, webp). Required.
        :type format: str
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword algorithm: Terrain algorithm name. Known values are: "hillshade", "contours",
         "normalizedIndex", "terrarium", and "terrainrgb". Default value is None.
        :paramtype algorithm: str or ~azure.planetarycomputer.models.TerrainAlgorithm
        :keyword algorithm_params: Terrain algorithm parameters. Default value is None.
        :paramtype algorithm_params: str
        :keyword color_formula: rio-color formula (info: `https://github.com/mapbox/rio-color
         <https://github.com/mapbox/rio-color>`_). Default value is None.
        :paramtype color_formula: str
        :keyword dst_crs: Output Coordinate Reference System. Default value is None.
        :paramtype dst_crs: str
        :keyword coordinate_reference_system: Coordinate Reference System of the input coords. Default
         to ``epsg:4326``. Default value is None.
        :paramtype coordinate_reference_system: str
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :keyword max_size: Image output size limit if width and height limits are not set. Default
         value is None.
        :paramtype max_size: int
        :keyword rescale: comma (',') delimited Min,Max range. Can set multiple time for multiple
         bands. Default value is None.
        :paramtype rescale: list[str]
        :keyword color_map_name: Colormap name. Known values are: "accent", "accent_r", "afmhot",
         "afmhot_r", "ai4g-lulc", "alos-fnf", "alos-palsar-mask", "autumn", "autumn_r", "binary",
         "binary_r", "blues", "blues_r", "bone", "bone_r", "brbg", "brbg_r", "brg", "brg_r", "bugn",
         "bugn_r", "bupu", "bupu_r", "bwr", "bwr_r", "c-cap", "cfastie", "chesapeake-lc-13",
         "chesapeake-lc-7", "chesapeake-lu", "chloris-biomass", "cividis", "cividis_r", "cmrmap",
         "cmrmap_r", "cool", "cool_r", "coolwarm", "coolwarm_r", "copper", "copper_r", "cubehelix",
         "cubehelix_r", "dark2", "dark2_r", "drcog-lulc", "esa-cci-lc", "esa-worldcover", "flag",
         "flag_r", "gap-lulc", "gist_earth", "gist_earth_r", "gist_gray", "gist_gray_r", "gist_heat",
         "gist_heat_r", "gist_ncar", "gist_ncar_r", "gist_rainbow", "gist_rainbow_r", "gist_stern",
         "gist_stern_r", "gist_yarg", "gist_yarg_r", "gnbu", "gnbu_r", "gnuplot", "gnuplot2",
         "gnuplot2_r", "gnuplot_r", "gray", "gray_r", "greens", "greens_r", "greys", "greys_r", "hot",
         "hot_r", "hsv", "hsv_r", "inferno", "inferno_r", "io-bii", "io-lulc", "io-lulc-9-class", "jet",
         "jet_r", "jrc-change", "jrc-extent", "jrc-occurrence", "jrc-recurrence", "jrc-seasonality",
         "jrc-transitions", "lidar-classification", "lidar-hag", "lidar-hag-alternative",
         "lidar-intensity", "lidar-returns", "magma", "magma_r", "modis-10A1", "modis-10A2",
         "modis-13A1|Q1", "modis-14A1|A2", "modis-15A2H|A3H", "modis-16A3GF-ET", "modis-16A3GF-PET",
         "modis-17A2H|A2HGF", "modis-17A3HGF", "modis-64A1", "mtbs-severity", "nipy_spectral",
         "nipy_spectral_r", "nrcan-lulc", "ocean", "ocean_r", "oranges", "oranges_r", "orrd", "orrd_r",
         "paired", "paired_r", "pastel1", "pastel1_r", "pastel2", "pastel2_r", "pink", "pink_r", "piyg",
         "piyg_r", "plasma", "plasma_r", "prgn", "prgn_r", "prism", "prism_r", "pubu", "pubu_r",
         "pubugn", "pubugn_r", "puor", "puor_r", "purd", "purd_r", "purples", "purples_r", "qpe",
         "rainbow", "rainbow_r", "rdbu", "rdbu_r", "rdgy", "rdgy_r", "rdpu", "rdpu_r", "rdylbu",
         "rdylbu_r", "rdylgn", "rdylgn_r", "reds", "reds_r", "rplumbo", "schwarzwald", "seismic",
         "seismic_r", "set1", "set1_r", "set2", "set2_r", "set3", "set3_r", "spectral", "spectral_r",
         "spring", "spring_r", "summer", "summer_r", "tab10", "tab10_r", "tab20", "tab20_r", "tab20b",
         "tab20b_r", "tab20c", "tab20c_r", "terrain", "terrain_r", "twilight", "twilight_r",
         "twilight_shifted", "twilight_shifted_r", "usda-cdl", "usda-cdl-corn", "usda-cdl-cotton",
         "usda-cdl-soybeans", "usda-cdl-wheat", "usgs-lcmap", "viirs-10a1", "viirs-13a1", "viirs-14a1",
         "viirs-15a2H", "viridis", "viridis_r", "winter", "winter_r", "wistia", "wistia_r", "ylgn",
         "ylgn_r", "ylgnbu", "ylgnbu_r", "ylorbr", "ylorbr_r", "ylorrd", and "ylorrd_r". Default value
         is None.
        :paramtype color_map_name: str or ~azure.planetarycomputer.models.ColorMapNames
        :keyword color_map: JSON encoded custom Colormap. Default value is None.
        :paramtype color_map: str
        :keyword return_mask: Add mask to the output data. Default value is None.
        :paramtype return_mask: bool
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_data_get_part_with_dimensions_request(
            collection_id=collection_id,
            item_id=item_id,
            minx=minx,
            miny=miny,
            maxx=maxx,
            maxy=maxy,
            width=width,
            height=height,
            format=format,
            assets=assets,
            expression=expression,
            asset_band_indices=asset_band_indices,
            asset_as_band=asset_as_band,
            no_data=no_data,
            unscale=unscale,
            algorithm=algorithm,
            algorithm_params=algorithm_params,
            color_formula=color_formula,
            dst_crs=dst_crs,
            coordinate_reference_system=coordinate_reference_system,
            resampling=resampling,
            max_size=max_size,
            rescale=rescale,
            color_map_name=color_map_name,
            color_map=color_map,
            return_mask=return_mask,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", True)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_point(  # pylint: disable=too-many-locals
        self,
        collection_id: str,
        item_id: str,
        longitude: float,
        latitude: float,
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        coordinate_reference_system: Optional[str] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        **kwargs: Any
    ) -> _models.TilerCoreModelsResponsesPoint:
        """Point.

        Get Point value for a dataset.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :param longitude: Longitude. Required.
        :type longitude: float
        :param latitude: Latitude. Required.
        :type latitude: float
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword coordinate_reference_system: Coordinate Reference System of the input coords. Default
         to ``epsg:4326``. Default value is None.
        :paramtype coordinate_reference_system: str
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :return: TilerCoreModelsResponsesPoint. The TilerCoreModelsResponsesPoint is compatible with
         MutableMapping
        :rtype: ~azure.planetarycomputer.models.TilerCoreModelsResponsesPoint
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TilerCoreModelsResponsesPoint] = kwargs.pop("cls", None)

        _request = build_data_get_point_request(
            collection_id=collection_id,
            item_id=item_id,
            longitude=longitude,
            latitude=latitude,
            assets=assets,
            expression=expression,
            asset_band_indices=asset_band_indices,
            asset_as_band=asset_as_band,
            no_data=no_data,
            unscale=unscale,
            coordinate_reference_system=coordinate_reference_system,
            resampling=resampling,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TilerCoreModelsResponsesPoint, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_preview(  # pylint: disable=too-many-locals
        self,
        collection_id: str,
        item_id: str,
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        algorithm: Optional[Union[str, _models.TerrainAlgorithm]] = None,
        algorithm_params: Optional[str] = None,
        format: Optional[Union[str, _models.TilerImageFormat]] = None,
        color_formula: Optional[str] = None,
        dst_crs: Optional[str] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        max_size: Optional[int] = None,
        height: Optional[int] = None,
        width: Optional[int] = None,
        rescale: Optional[List[str]] = None,
        color_map_name: Optional[Union[str, _models.ColorMapNames]] = None,
        color_map: Optional[str] = None,
        return_mask: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Preview.

        Create preview of a dataset.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword algorithm: Terrain algorithm name. Known values are: "hillshade", "contours",
         "normalizedIndex", "terrarium", and "terrainrgb". Default value is None.
        :paramtype algorithm: str or ~azure.planetarycomputer.models.TerrainAlgorithm
        :keyword algorithm_params: Terrain algorithm parameters. Default value is None.
        :paramtype algorithm_params: str
        :keyword format: Output format for the tile or image (e.g., png, jpeg, webp). Known values are:
         "png", "npy", "tif", "jpeg", "jpg", "jp2", "webp", and "pngraw". Default value is None.
        :paramtype format: str or ~azure.planetarycomputer.models.TilerImageFormat
        :keyword color_formula: rio-color formula (info: `https://github.com/mapbox/rio-color
         <https://github.com/mapbox/rio-color>`_). Default value is None.
        :paramtype color_formula: str
        :keyword dst_crs: Output Coordinate Reference System. Default value is None.
        :paramtype dst_crs: str
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :keyword max_size: Image output size limit if width and height limits are not set. Default
         value is None.
        :paramtype max_size: int
        :keyword height: Height in pixels for the output image. Default value is None.
        :paramtype height: int
        :keyword width: Width in pixels for the output image. Default value is None.
        :paramtype width: int
        :keyword rescale: comma (',') delimited Min,Max range. Can set multiple time for multiple
         bands. Default value is None.
        :paramtype rescale: list[str]
        :keyword color_map_name: Colormap name. Known values are: "accent", "accent_r", "afmhot",
         "afmhot_r", "ai4g-lulc", "alos-fnf", "alos-palsar-mask", "autumn", "autumn_r", "binary",
         "binary_r", "blues", "blues_r", "bone", "bone_r", "brbg", "brbg_r", "brg", "brg_r", "bugn",
         "bugn_r", "bupu", "bupu_r", "bwr", "bwr_r", "c-cap", "cfastie", "chesapeake-lc-13",
         "chesapeake-lc-7", "chesapeake-lu", "chloris-biomass", "cividis", "cividis_r", "cmrmap",
         "cmrmap_r", "cool", "cool_r", "coolwarm", "coolwarm_r", "copper", "copper_r", "cubehelix",
         "cubehelix_r", "dark2", "dark2_r", "drcog-lulc", "esa-cci-lc", "esa-worldcover", "flag",
         "flag_r", "gap-lulc", "gist_earth", "gist_earth_r", "gist_gray", "gist_gray_r", "gist_heat",
         "gist_heat_r", "gist_ncar", "gist_ncar_r", "gist_rainbow", "gist_rainbow_r", "gist_stern",
         "gist_stern_r", "gist_yarg", "gist_yarg_r", "gnbu", "gnbu_r", "gnuplot", "gnuplot2",
         "gnuplot2_r", "gnuplot_r", "gray", "gray_r", "greens", "greens_r", "greys", "greys_r", "hot",
         "hot_r", "hsv", "hsv_r", "inferno", "inferno_r", "io-bii", "io-lulc", "io-lulc-9-class", "jet",
         "jet_r", "jrc-change", "jrc-extent", "jrc-occurrence", "jrc-recurrence", "jrc-seasonality",
         "jrc-transitions", "lidar-classification", "lidar-hag", "lidar-hag-alternative",
         "lidar-intensity", "lidar-returns", "magma", "magma_r", "modis-10A1", "modis-10A2",
         "modis-13A1|Q1", "modis-14A1|A2", "modis-15A2H|A3H", "modis-16A3GF-ET", "modis-16A3GF-PET",
         "modis-17A2H|A2HGF", "modis-17A3HGF", "modis-64A1", "mtbs-severity", "nipy_spectral",
         "nipy_spectral_r", "nrcan-lulc", "ocean", "ocean_r", "oranges", "oranges_r", "orrd", "orrd_r",
         "paired", "paired_r", "pastel1", "pastel1_r", "pastel2", "pastel2_r", "pink", "pink_r", "piyg",
         "piyg_r", "plasma", "plasma_r", "prgn", "prgn_r", "prism", "prism_r", "pubu", "pubu_r",
         "pubugn", "pubugn_r", "puor", "puor_r", "purd", "purd_r", "purples", "purples_r", "qpe",
         "rainbow", "rainbow_r", "rdbu", "rdbu_r", "rdgy", "rdgy_r", "rdpu", "rdpu_r", "rdylbu",
         "rdylbu_r", "rdylgn", "rdylgn_r", "reds", "reds_r", "rplumbo", "schwarzwald", "seismic",
         "seismic_r", "set1", "set1_r", "set2", "set2_r", "set3", "set3_r", "spectral", "spectral_r",
         "spring", "spring_r", "summer", "summer_r", "tab10", "tab10_r", "tab20", "tab20_r", "tab20b",
         "tab20b_r", "tab20c", "tab20c_r", "terrain", "terrain_r", "twilight", "twilight_r",
         "twilight_shifted", "twilight_shifted_r", "usda-cdl", "usda-cdl-corn", "usda-cdl-cotton",
         "usda-cdl-soybeans", "usda-cdl-wheat", "usgs-lcmap", "viirs-10a1", "viirs-13a1", "viirs-14a1",
         "viirs-15a2H", "viridis", "viridis_r", "winter", "winter_r", "wistia", "wistia_r", "ylgn",
         "ylgn_r", "ylgnbu", "ylgnbu_r", "ylorbr", "ylorbr_r", "ylorrd", and "ylorrd_r". Default value
         is None.
        :paramtype color_map_name: str or ~azure.planetarycomputer.models.ColorMapNames
        :keyword color_map: JSON encoded custom Colormap. Default value is None.
        :paramtype color_map: str
        :keyword return_mask: Add mask to the output data. Default value is None.
        :paramtype return_mask: bool
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_data_get_preview_request(
            collection_id=collection_id,
            item_id=item_id,
            assets=assets,
            expression=expression,
            asset_band_indices=asset_band_indices,
            asset_as_band=asset_as_band,
            no_data=no_data,
            unscale=unscale,
            algorithm=algorithm,
            algorithm_params=algorithm_params,
            format=format,
            color_formula=color_formula,
            dst_crs=dst_crs,
            resampling=resampling,
            max_size=max_size,
            height=height,
            width=width,
            rescale=rescale,
            color_map_name=color_map_name,
            color_map=color_map,
            return_mask=return_mask,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", True)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_preview_with_format(  # pylint: disable=too-many-locals
        self,
        collection_id: str,
        item_id: str,
        format: str,
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        algorithm: Optional[Union[str, _models.TerrainAlgorithm]] = None,
        algorithm_params: Optional[str] = None,
        color_formula: Optional[str] = None,
        dst_crs: Optional[str] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        max_size: Optional[int] = None,
        height: Optional[int] = None,
        width: Optional[int] = None,
        rescale: Optional[List[str]] = None,
        color_map_name: Optional[Union[str, _models.ColorMapNames]] = None,
        color_map: Optional[str] = None,
        return_mask: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Preview.

        Create preview of a dataset.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :param format: Output format for the tile or image (e.g., png, jpeg, webp). Required.
        :type format: str
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword algorithm: Terrain algorithm name. Known values are: "hillshade", "contours",
         "normalizedIndex", "terrarium", and "terrainrgb". Default value is None.
        :paramtype algorithm: str or ~azure.planetarycomputer.models.TerrainAlgorithm
        :keyword algorithm_params: Terrain algorithm parameters. Default value is None.
        :paramtype algorithm_params: str
        :keyword color_formula: rio-color formula (info: `https://github.com/mapbox/rio-color
         <https://github.com/mapbox/rio-color>`_). Default value is None.
        :paramtype color_formula: str
        :keyword dst_crs: Output Coordinate Reference System. Default value is None.
        :paramtype dst_crs: str
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :keyword max_size: Image output size limit if width and height limits are not set. Default
         value is None.
        :paramtype max_size: int
        :keyword height: Height in pixels for the output image. Default value is None.
        :paramtype height: int
        :keyword width: Width in pixels for the output image. Default value is None.
        :paramtype width: int
        :keyword rescale: comma (',') delimited Min,Max range. Can set multiple time for multiple
         bands. Default value is None.
        :paramtype rescale: list[str]
        :keyword color_map_name: Colormap name. Known values are: "accent", "accent_r", "afmhot",
         "afmhot_r", "ai4g-lulc", "alos-fnf", "alos-palsar-mask", "autumn", "autumn_r", "binary",
         "binary_r", "blues", "blues_r", "bone", "bone_r", "brbg", "brbg_r", "brg", "brg_r", "bugn",
         "bugn_r", "bupu", "bupu_r", "bwr", "bwr_r", "c-cap", "cfastie", "chesapeake-lc-13",
         "chesapeake-lc-7", "chesapeake-lu", "chloris-biomass", "cividis", "cividis_r", "cmrmap",
         "cmrmap_r", "cool", "cool_r", "coolwarm", "coolwarm_r", "copper", "copper_r", "cubehelix",
         "cubehelix_r", "dark2", "dark2_r", "drcog-lulc", "esa-cci-lc", "esa-worldcover", "flag",
         "flag_r", "gap-lulc", "gist_earth", "gist_earth_r", "gist_gray", "gist_gray_r", "gist_heat",
         "gist_heat_r", "gist_ncar", "gist_ncar_r", "gist_rainbow", "gist_rainbow_r", "gist_stern",
         "gist_stern_r", "gist_yarg", "gist_yarg_r", "gnbu", "gnbu_r", "gnuplot", "gnuplot2",
         "gnuplot2_r", "gnuplot_r", "gray", "gray_r", "greens", "greens_r", "greys", "greys_r", "hot",
         "hot_r", "hsv", "hsv_r", "inferno", "inferno_r", "io-bii", "io-lulc", "io-lulc-9-class", "jet",
         "jet_r", "jrc-change", "jrc-extent", "jrc-occurrence", "jrc-recurrence", "jrc-seasonality",
         "jrc-transitions", "lidar-classification", "lidar-hag", "lidar-hag-alternative",
         "lidar-intensity", "lidar-returns", "magma", "magma_r", "modis-10A1", "modis-10A2",
         "modis-13A1|Q1", "modis-14A1|A2", "modis-15A2H|A3H", "modis-16A3GF-ET", "modis-16A3GF-PET",
         "modis-17A2H|A2HGF", "modis-17A3HGF", "modis-64A1", "mtbs-severity", "nipy_spectral",
         "nipy_spectral_r", "nrcan-lulc", "ocean", "ocean_r", "oranges", "oranges_r", "orrd", "orrd_r",
         "paired", "paired_r", "pastel1", "pastel1_r", "pastel2", "pastel2_r", "pink", "pink_r", "piyg",
         "piyg_r", "plasma", "plasma_r", "prgn", "prgn_r", "prism", "prism_r", "pubu", "pubu_r",
         "pubugn", "pubugn_r", "puor", "puor_r", "purd", "purd_r", "purples", "purples_r", "qpe",
         "rainbow", "rainbow_r", "rdbu", "rdbu_r", "rdgy", "rdgy_r", "rdpu", "rdpu_r", "rdylbu",
         "rdylbu_r", "rdylgn", "rdylgn_r", "reds", "reds_r", "rplumbo", "schwarzwald", "seismic",
         "seismic_r", "set1", "set1_r", "set2", "set2_r", "set3", "set3_r", "spectral", "spectral_r",
         "spring", "spring_r", "summer", "summer_r", "tab10", "tab10_r", "tab20", "tab20_r", "tab20b",
         "tab20b_r", "tab20c", "tab20c_r", "terrain", "terrain_r", "twilight", "twilight_r",
         "twilight_shifted", "twilight_shifted_r", "usda-cdl", "usda-cdl-corn", "usda-cdl-cotton",
         "usda-cdl-soybeans", "usda-cdl-wheat", "usgs-lcmap", "viirs-10a1", "viirs-13a1", "viirs-14a1",
         "viirs-15a2H", "viridis", "viridis_r", "winter", "winter_r", "wistia", "wistia_r", "ylgn",
         "ylgn_r", "ylgnbu", "ylgnbu_r", "ylorbr", "ylorbr_r", "ylorrd", and "ylorrd_r". Default value
         is None.
        :paramtype color_map_name: str or ~azure.planetarycomputer.models.ColorMapNames
        :keyword color_map: JSON encoded custom Colormap. Default value is None.
        :paramtype color_map: str
        :keyword return_mask: Add mask to the output data. Default value is None.
        :paramtype return_mask: bool
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_data_get_preview_with_format_request(
            collection_id=collection_id,
            item_id=item_id,
            format=format,
            assets=assets,
            expression=expression,
            asset_band_indices=asset_band_indices,
            asset_as_band=asset_as_band,
            no_data=no_data,
            unscale=unscale,
            algorithm=algorithm,
            algorithm_params=algorithm_params,
            color_formula=color_formula,
            dst_crs=dst_crs,
            resampling=resampling,
            max_size=max_size,
            height=height,
            width=width,
            rescale=rescale,
            color_map_name=color_map_name,
            color_map=color_map,
            return_mask=return_mask,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", True)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_static_image(
        self,
        collection_id: str,
        body: _models.ImageParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ImageResponse:
        """Create Static Image.

        Create a new image export.

        :param collection_id: STAC Collection ID. Required.
        :type collection_id: str
        :param body: Image request body. Required.
        :type body: ~azure.planetarycomputer.models.ImageParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ImageResponse. The ImageResponse is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.ImageResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_static_image(
        self, collection_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.ImageResponse:
        """Create Static Image.

        Create a new image export.

        :param collection_id: STAC Collection ID. Required.
        :type collection_id: str
        :param body: Image request body. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ImageResponse. The ImageResponse is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.ImageResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_static_image(
        self, collection_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.ImageResponse:
        """Create Static Image.

        Create a new image export.

        :param collection_id: STAC Collection ID. Required.
        :type collection_id: str
        :param body: Image request body. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ImageResponse. The ImageResponse is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.ImageResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_static_image(
        self, collection_id: str, body: Union[_models.ImageParameters, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.ImageResponse:
        """Create Static Image.

        Create a new image export.

        :param collection_id: STAC Collection ID. Required.
        :type collection_id: str
        :param body: Image request body. Is one of the following types: ImageParameters, JSON,
         IO[bytes] Required.
        :type body: ~azure.planetarycomputer.models.ImageParameters or JSON or IO[bytes]
        :return: ImageResponse. The ImageResponse is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.ImageResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ImageResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_data_create_static_image_request(
            collection_id=collection_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.ImageResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_static_image(self, collection_id: str, id: str, **kwargs: Any) -> AsyncIterator[bytes]:
        """Get Static Image.

        Fetch an existing image export by ID.

        :param collection_id: STAC Collection ID. Required.
        :type collection_id: str
        :param id: Image export ID. Required.
        :type id: str
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_data_get_static_image_request(
            collection_id=collection_id,
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", True)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_statistics(  # pylint: disable=too-many-locals
        self,
        collection_id: str,
        item_id: str,
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        max_size: Optional[int] = None,
        categorical: Optional[bool] = None,
        categories_pixels: Optional[List[str]] = None,
        percentiles: Optional[List[int]] = None,
        histogram_bins: Optional[str] = None,
        histogram_range: Optional[str] = None,
        **kwargs: Any
    ) -> _models.TilerStacItemStatistics:
        """Statistics.

        Merged assets statistics.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :keyword max_size: Maximum dimension in pixels for the source data used to calculate
         statistics. Default value is None.
        :paramtype max_size: int
        :keyword categorical: Return statistics for categorical dataset. Default value is None.
        :paramtype categorical: bool
        :keyword categories_pixels: List of pixel categorical values for which to report counts.
         Default value is None.
        :paramtype categories_pixels: list[str]
        :keyword percentiles: List of percentile values (default to [2, 98]). Default value is None.
        :paramtype percentiles: list[int]
        :keyword histogram_bins: Defines the number of equal-width bins in the given range (10, by
         default).

         If bins is a sequence (comma ``,`` delimited values), it defines a monotonically
         increasing array of bin edges, including the rightmost edge, allowing for
         non-uniform bin widths.

         link: `https://numpy.org/doc/stable/reference/generated/numpy.histogram.html
         <https://numpy.org/doc/stable/reference/generated/numpy.histogram.html>`_. Default value is
         None.
        :paramtype histogram_bins: str
        :keyword histogram_range: Comma ``,`` delimited range of the bins.

         The lower and upper range of the bins. If not provided, range is simply
         (a.min(), a.max()).

         Values outside the range are ignored. The first element of the range must be
         less than or equal to the second.
         range affects the automatic bin computation as well.

         link: `https://numpy.org/doc/stable/reference/generated/numpy.histogram.html
         <https://numpy.org/doc/stable/reference/generated/numpy.histogram.html>`_. Default value is
         None.
        :paramtype histogram_range: str
        :return: TilerStacItemStatistics. The TilerStacItemStatistics is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.TilerStacItemStatistics
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TilerStacItemStatistics] = kwargs.pop("cls", None)

        _request = build_data_list_statistics_request(
            collection_id=collection_id,
            item_id=item_id,
            assets=assets,
            expression=expression,
            asset_band_indices=asset_band_indices,
            asset_as_band=asset_as_band,
            no_data=no_data,
            unscale=unscale,
            resampling=resampling,
            max_size=max_size,
            categorical=categorical,
            categories_pixels=categories_pixels,
            percentiles=percentiles,
            histogram_bins=histogram_bins,
            histogram_range=histogram_range,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TilerStacItemStatistics, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_tile_json(  # pylint: disable=too-many-locals
        self,
        collection_id: str,
        item_id: str,
        tile_matrix_set_id: str,
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        algorithm: Optional[Union[str, _models.TerrainAlgorithm]] = None,
        algorithm_params: Optional[str] = None,
        tile_format: Optional[Union[str, _models.TilerImageFormat]] = None,
        tile_scale: Optional[int] = None,
        min_zoom: Optional[int] = None,
        max_zoom: Optional[int] = None,
        buffer: Optional[str] = None,
        color_formula: Optional[str] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        rescale: Optional[List[str]] = None,
        color_map_name: Optional[Union[str, _models.ColorMapNames]] = None,
        color_map: Optional[str] = None,
        return_mask: Optional[bool] = None,
        **kwargs: Any
    ) -> _models.TileJsonMetadata:
        """TileJson Tilematrixsetid As Path.

        Return the TileJson Tilematrixsetid As a path.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :param tile_matrix_set_id: Identifier selecting one of the TileMatrixSetId supported. Required.
        :type tile_matrix_set_id: str
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword algorithm: Terrain algorithm name. Known values are: "hillshade", "contours",
         "normalizedIndex", "terrarium", and "terrainrgb". Default value is None.
        :paramtype algorithm: str or ~azure.planetarycomputer.models.TerrainAlgorithm
        :keyword algorithm_params: Terrain algorithm parameters. Default value is None.
        :paramtype algorithm_params: str
        :keyword tile_format: Default will be automatically defined if the output image needs a mask
         (png) or
         not (jpeg). Known values are: "png", "npy", "tif", "jpeg", "jpg", "jp2", "webp", and "pngraw".
         Default value is None.
        :paramtype tile_format: str or ~azure.planetarycomputer.models.TilerImageFormat
        :keyword tile_scale: Tile scale factor affecting output size. Values > 1 produce larger tiles
         (e.g., 1=256x256, 2=512x512). Default value is None.
        :paramtype tile_scale: int
        :keyword min_zoom: Overwrite default minzoom. Default value is None.
        :paramtype min_zoom: int
        :keyword max_zoom: Overwrite default maxzoom. Default value is None.
        :paramtype max_zoom: int
        :keyword buffer: Buffer on each side of the given tile. It must be a multiple of ``0.5``.
         Output
         **tilesize** will be expanded to ``tilesize + 2 * buffer`` (e.g 0.5 = 257x257,
         1.0 = 258x258). Default value is None.
        :paramtype buffer: str
        :keyword color_formula: rio-color formula (info: `https://github.com/mapbox/rio-color
         <https://github.com/mapbox/rio-color>`_). Default value is None.
        :paramtype color_formula: str
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :keyword rescale: comma (',') delimited Min,Max range. Can set multiple time for multiple
         bands. Default value is None.
        :paramtype rescale: list[str]
        :keyword color_map_name: Colormap name. Known values are: "accent", "accent_r", "afmhot",
         "afmhot_r", "ai4g-lulc", "alos-fnf", "alos-palsar-mask", "autumn", "autumn_r", "binary",
         "binary_r", "blues", "blues_r", "bone", "bone_r", "brbg", "brbg_r", "brg", "brg_r", "bugn",
         "bugn_r", "bupu", "bupu_r", "bwr", "bwr_r", "c-cap", "cfastie", "chesapeake-lc-13",
         "chesapeake-lc-7", "chesapeake-lu", "chloris-biomass", "cividis", "cividis_r", "cmrmap",
         "cmrmap_r", "cool", "cool_r", "coolwarm", "coolwarm_r", "copper", "copper_r", "cubehelix",
         "cubehelix_r", "dark2", "dark2_r", "drcog-lulc", "esa-cci-lc", "esa-worldcover", "flag",
         "flag_r", "gap-lulc", "gist_earth", "gist_earth_r", "gist_gray", "gist_gray_r", "gist_heat",
         "gist_heat_r", "gist_ncar", "gist_ncar_r", "gist_rainbow", "gist_rainbow_r", "gist_stern",
         "gist_stern_r", "gist_yarg", "gist_yarg_r", "gnbu", "gnbu_r", "gnuplot", "gnuplot2",
         "gnuplot2_r", "gnuplot_r", "gray", "gray_r", "greens", "greens_r", "greys", "greys_r", "hot",
         "hot_r", "hsv", "hsv_r", "inferno", "inferno_r", "io-bii", "io-lulc", "io-lulc-9-class", "jet",
         "jet_r", "jrc-change", "jrc-extent", "jrc-occurrence", "jrc-recurrence", "jrc-seasonality",
         "jrc-transitions", "lidar-classification", "lidar-hag", "lidar-hag-alternative",
         "lidar-intensity", "lidar-returns", "magma", "magma_r", "modis-10A1", "modis-10A2",
         "modis-13A1|Q1", "modis-14A1|A2", "modis-15A2H|A3H", "modis-16A3GF-ET", "modis-16A3GF-PET",
         "modis-17A2H|A2HGF", "modis-17A3HGF", "modis-64A1", "mtbs-severity", "nipy_spectral",
         "nipy_spectral_r", "nrcan-lulc", "ocean", "ocean_r", "oranges", "oranges_r", "orrd", "orrd_r",
         "paired", "paired_r", "pastel1", "pastel1_r", "pastel2", "pastel2_r", "pink", "pink_r", "piyg",
         "piyg_r", "plasma", "plasma_r", "prgn", "prgn_r", "prism", "prism_r", "pubu", "pubu_r",
         "pubugn", "pubugn_r", "puor", "puor_r", "purd", "purd_r", "purples", "purples_r", "qpe",
         "rainbow", "rainbow_r", "rdbu", "rdbu_r", "rdgy", "rdgy_r", "rdpu", "rdpu_r", "rdylbu",
         "rdylbu_r", "rdylgn", "rdylgn_r", "reds", "reds_r", "rplumbo", "schwarzwald", "seismic",
         "seismic_r", "set1", "set1_r", "set2", "set2_r", "set3", "set3_r", "spectral", "spectral_r",
         "spring", "spring_r", "summer", "summer_r", "tab10", "tab10_r", "tab20", "tab20_r", "tab20b",
         "tab20b_r", "tab20c", "tab20c_r", "terrain", "terrain_r", "twilight", "twilight_r",
         "twilight_shifted", "twilight_shifted_r", "usda-cdl", "usda-cdl-corn", "usda-cdl-cotton",
         "usda-cdl-soybeans", "usda-cdl-wheat", "usgs-lcmap", "viirs-10a1", "viirs-13a1", "viirs-14a1",
         "viirs-15a2H", "viridis", "viridis_r", "winter", "winter_r", "wistia", "wistia_r", "ylgn",
         "ylgn_r", "ylgnbu", "ylgnbu_r", "ylorbr", "ylorbr_r", "ylorrd", and "ylorrd_r". Default value
         is None.
        :paramtype color_map_name: str or ~azure.planetarycomputer.models.ColorMapNames
        :keyword color_map: JSON encoded custom Colormap. Default value is None.
        :paramtype color_map: str
        :keyword return_mask: Add mask to the output data. Default value is None.
        :paramtype return_mask: bool
        :return: TileJsonMetadata. The TileJsonMetadata is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.TileJsonMetadata
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TileJsonMetadata] = kwargs.pop("cls", None)

        _request = build_data_get_tile_json_request(
            collection_id=collection_id,
            item_id=item_id,
            tile_matrix_set_id=tile_matrix_set_id,
            assets=assets,
            expression=expression,
            asset_band_indices=asset_band_indices,
            asset_as_band=asset_as_band,
            no_data=no_data,
            unscale=unscale,
            algorithm=algorithm,
            algorithm_params=algorithm_params,
            tile_format=tile_format,
            tile_scale=tile_scale,
            min_zoom=min_zoom,
            max_zoom=max_zoom,
            buffer=buffer,
            color_formula=color_formula,
            resampling=resampling,
            rescale=rescale,
            color_map_name=color_map_name,
            color_map=color_map,
            return_mask=return_mask,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TileJsonMetadata, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_tile(  # pylint: disable=too-many-locals
        self,
        collection_id: str,
        item_id: str,
        tile_matrix_set_id: str,
        z: float,
        x: float,
        y: float,
        scale: float,
        format: str,
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        algorithm: Optional[Union[str, _models.TerrainAlgorithm]] = None,
        algorithm_params: Optional[str] = None,
        buffer: Optional[str] = None,
        color_formula: Optional[str] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        rescale: Optional[List[str]] = None,
        color_map_name: Optional[Union[str, _models.ColorMapNames]] = None,
        color_map: Optional[str] = None,
        return_mask: Optional[bool] = None,
        subdataset_name: Optional[str] = None,
        subdataset_bands: Optional[List[str]] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Tile Tilematrixsetid As Path.

        Create map tile from a dataset.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :param tile_matrix_set_id: Identifier selecting one of the TileMatrixSetId supported. Required.
        :type tile_matrix_set_id: str
        :param z: Identifier (Z) selecting one of the scales defined in the TileMatrixSet and
         representing the scaleDenominator the tile. Required.
        :type z: float
        :param x: Column (X) index of the tile on the selected TileMatrix. It cannot exceed the
         MatrixHeight-1 for the selected TileMatrix. Required.
        :type x: float
        :param y: Row (Y) index of the tile on the selected TileMatrix. It cannot exceed the
         MatrixWidth-1 for the selected TileMatrix. Required.
        :type y: float
        :param scale: Numeric scale factor for the tile. Higher values produce larger tiles. Required.
        :type scale: float
        :param format: Output format for the tile or image (e.g., png, jpeg, webp). Required.
        :type format: str
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword algorithm: Terrain algorithm name. Known values are: "hillshade", "contours",
         "normalizedIndex", "terrarium", and "terrainrgb". Default value is None.
        :paramtype algorithm: str or ~azure.planetarycomputer.models.TerrainAlgorithm
        :keyword algorithm_params: Terrain algorithm parameters. Default value is None.
        :paramtype algorithm_params: str
        :keyword buffer: Buffer on each side of the given tile. It must be a multiple of ``0.5``.
         Output
         **tilesize** will be expanded to ``tilesize + 2 * buffer`` (e.g 0.5 = 257x257,
         1.0 = 258x258). Default value is None.
        :paramtype buffer: str
        :keyword color_formula: rio-color formula (info: `https://github.com/mapbox/rio-color
         <https://github.com/mapbox/rio-color>`_). Default value is None.
        :paramtype color_formula: str
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :keyword rescale: comma (',') delimited Min,Max range. Can set multiple time for multiple
         bands. Default value is None.
        :paramtype rescale: list[str]
        :keyword color_map_name: Colormap name. Known values are: "accent", "accent_r", "afmhot",
         "afmhot_r", "ai4g-lulc", "alos-fnf", "alos-palsar-mask", "autumn", "autumn_r", "binary",
         "binary_r", "blues", "blues_r", "bone", "bone_r", "brbg", "brbg_r", "brg", "brg_r", "bugn",
         "bugn_r", "bupu", "bupu_r", "bwr", "bwr_r", "c-cap", "cfastie", "chesapeake-lc-13",
         "chesapeake-lc-7", "chesapeake-lu", "chloris-biomass", "cividis", "cividis_r", "cmrmap",
         "cmrmap_r", "cool", "cool_r", "coolwarm", "coolwarm_r", "copper", "copper_r", "cubehelix",
         "cubehelix_r", "dark2", "dark2_r", "drcog-lulc", "esa-cci-lc", "esa-worldcover", "flag",
         "flag_r", "gap-lulc", "gist_earth", "gist_earth_r", "gist_gray", "gist_gray_r", "gist_heat",
         "gist_heat_r", "gist_ncar", "gist_ncar_r", "gist_rainbow", "gist_rainbow_r", "gist_stern",
         "gist_stern_r", "gist_yarg", "gist_yarg_r", "gnbu", "gnbu_r", "gnuplot", "gnuplot2",
         "gnuplot2_r", "gnuplot_r", "gray", "gray_r", "greens", "greens_r", "greys", "greys_r", "hot",
         "hot_r", "hsv", "hsv_r", "inferno", "inferno_r", "io-bii", "io-lulc", "io-lulc-9-class", "jet",
         "jet_r", "jrc-change", "jrc-extent", "jrc-occurrence", "jrc-recurrence", "jrc-seasonality",
         "jrc-transitions", "lidar-classification", "lidar-hag", "lidar-hag-alternative",
         "lidar-intensity", "lidar-returns", "magma", "magma_r", "modis-10A1", "modis-10A2",
         "modis-13A1|Q1", "modis-14A1|A2", "modis-15A2H|A3H", "modis-16A3GF-ET", "modis-16A3GF-PET",
         "modis-17A2H|A2HGF", "modis-17A3HGF", "modis-64A1", "mtbs-severity", "nipy_spectral",
         "nipy_spectral_r", "nrcan-lulc", "ocean", "ocean_r", "oranges", "oranges_r", "orrd", "orrd_r",
         "paired", "paired_r", "pastel1", "pastel1_r", "pastel2", "pastel2_r", "pink", "pink_r", "piyg",
         "piyg_r", "plasma", "plasma_r", "prgn", "prgn_r", "prism", "prism_r", "pubu", "pubu_r",
         "pubugn", "pubugn_r", "puor", "puor_r", "purd", "purd_r", "purples", "purples_r", "qpe",
         "rainbow", "rainbow_r", "rdbu", "rdbu_r", "rdgy", "rdgy_r", "rdpu", "rdpu_r", "rdylbu",
         "rdylbu_r", "rdylgn", "rdylgn_r", "reds", "reds_r", "rplumbo", "schwarzwald", "seismic",
         "seismic_r", "set1", "set1_r", "set2", "set2_r", "set3", "set3_r", "spectral", "spectral_r",
         "spring", "spring_r", "summer", "summer_r", "tab10", "tab10_r", "tab20", "tab20_r", "tab20b",
         "tab20b_r", "tab20c", "tab20c_r", "terrain", "terrain_r", "twilight", "twilight_r",
         "twilight_shifted", "twilight_shifted_r", "usda-cdl", "usda-cdl-corn", "usda-cdl-cotton",
         "usda-cdl-soybeans", "usda-cdl-wheat", "usgs-lcmap", "viirs-10a1", "viirs-13a1", "viirs-14a1",
         "viirs-15a2H", "viridis", "viridis_r", "winter", "winter_r", "wistia", "wistia_r", "ylgn",
         "ylgn_r", "ylgnbu", "ylgnbu_r", "ylorbr", "ylorbr_r", "ylorrd", and "ylorrd_r". Default value
         is None.
        :paramtype color_map_name: str or ~azure.planetarycomputer.models.ColorMapNames
        :keyword color_map: JSON encoded custom Colormap. Default value is None.
        :paramtype color_map: str
        :keyword return_mask: Add mask to the output data. Default value is None.
        :paramtype return_mask: bool
        :keyword subdataset_name: The name of a subdataset within the asset. Default value is None.
        :paramtype subdataset_name: str
        :keyword subdataset_bands: The index of a subdataset band within the asset. Default value is
         None.
        :paramtype subdataset_bands: list[str]
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_data_get_tile_request(
            collection_id=collection_id,
            item_id=item_id,
            tile_matrix_set_id=tile_matrix_set_id,
            z=z,
            x=x,
            y=y,
            scale=scale,
            format=format,
            assets=assets,
            expression=expression,
            asset_band_indices=asset_band_indices,
            asset_as_band=asset_as_band,
            no_data=no_data,
            unscale=unscale,
            algorithm=algorithm,
            algorithm_params=algorithm_params,
            buffer=buffer,
            color_formula=color_formula,
            resampling=resampling,
            rescale=rescale,
            color_map_name=color_map_name,
            color_map=color_map,
            return_mask=return_mask,
            subdataset_name=subdataset_name,
            subdataset_bands=subdataset_bands,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", True)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_wmts_capabilities(  # pylint: disable=too-many-locals
        self,
        collection_id: str,
        item_id: str,
        tile_matrix_set_id: str,
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        algorithm: Optional[Union[str, _models.TerrainAlgorithm]] = None,
        algorithm_params: Optional[str] = None,
        tile_format: Optional[Union[str, _models.TilerImageFormat]] = None,
        tile_scale: Optional[int] = None,
        min_zoom: Optional[int] = None,
        max_zoom: Optional[int] = None,
        buffer: Optional[str] = None,
        color_formula: Optional[str] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        rescale: Optional[List[str]] = None,
        color_map_name: Optional[Union[str, _models.ColorMapNames]] = None,
        color_map: Optional[str] = None,
        return_mask: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Wmts Tilematrixsetid As Path.

        OGC WMTS endpoint.

        :param collection_id: STAC Collection Identifier. Required.
        :type collection_id: str
        :param item_id: STAC Item Identifier. Required.
        :type item_id: str
        :param tile_matrix_set_id: Identifier selecting one of the TileMatrixSetId supported. Required.
        :type tile_matrix_set_id: str
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword algorithm: Terrain algorithm name. Known values are: "hillshade", "contours",
         "normalizedIndex", "terrarium", and "terrainrgb". Default value is None.
        :paramtype algorithm: str or ~azure.planetarycomputer.models.TerrainAlgorithm
        :keyword algorithm_params: Terrain algorithm parameters. Default value is None.
        :paramtype algorithm_params: str
        :keyword tile_format: Output image type. Default is png. Known values are: "png", "npy", "tif",
         "jpeg", "jpg", "jp2", "webp", and "pngraw". Default value is None.
        :paramtype tile_format: str or ~azure.planetarycomputer.models.TilerImageFormat
        :keyword tile_scale: Tile scale factor affecting output size. Values > 1 produce larger tiles
         (e.g., 1=256x256, 2=512x512). Default value is None.
        :paramtype tile_scale: int
        :keyword min_zoom: Overwrite default minzoom. Default value is None.
        :paramtype min_zoom: int
        :keyword max_zoom: Overwrite default maxzoom. Default value is None.
        :paramtype max_zoom: int
        :keyword buffer: Buffer on each side of the given tile. It must be a multiple of ``0.5``.
         Output
         **tilesize** will be expanded to ``tilesize + 2 * buffer`` (e.g 0.5 = 257x257,
         1.0 = 258x258). Default value is None.
        :paramtype buffer: str
        :keyword color_formula: rio-color formula (info: `https://github.com/mapbox/rio-color
         <https://github.com/mapbox/rio-color>`_). Default value is None.
        :paramtype color_formula: str
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :keyword rescale: comma (',') delimited Min,Max range. Can set multiple time for multiple
         bands. Default value is None.
        :paramtype rescale: list[str]
        :keyword color_map_name: Colormap name. Known values are: "accent", "accent_r", "afmhot",
         "afmhot_r", "ai4g-lulc", "alos-fnf", "alos-palsar-mask", "autumn", "autumn_r", "binary",
         "binary_r", "blues", "blues_r", "bone", "bone_r", "brbg", "brbg_r", "brg", "brg_r", "bugn",
         "bugn_r", "bupu", "bupu_r", "bwr", "bwr_r", "c-cap", "cfastie", "chesapeake-lc-13",
         "chesapeake-lc-7", "chesapeake-lu", "chloris-biomass", "cividis", "cividis_r", "cmrmap",
         "cmrmap_r", "cool", "cool_r", "coolwarm", "coolwarm_r", "copper", "copper_r", "cubehelix",
         "cubehelix_r", "dark2", "dark2_r", "drcog-lulc", "esa-cci-lc", "esa-worldcover", "flag",
         "flag_r", "gap-lulc", "gist_earth", "gist_earth_r", "gist_gray", "gist_gray_r", "gist_heat",
         "gist_heat_r", "gist_ncar", "gist_ncar_r", "gist_rainbow", "gist_rainbow_r", "gist_stern",
         "gist_stern_r", "gist_yarg", "gist_yarg_r", "gnbu", "gnbu_r", "gnuplot", "gnuplot2",
         "gnuplot2_r", "gnuplot_r", "gray", "gray_r", "greens", "greens_r", "greys", "greys_r", "hot",
         "hot_r", "hsv", "hsv_r", "inferno", "inferno_r", "io-bii", "io-lulc", "io-lulc-9-class", "jet",
         "jet_r", "jrc-change", "jrc-extent", "jrc-occurrence", "jrc-recurrence", "jrc-seasonality",
         "jrc-transitions", "lidar-classification", "lidar-hag", "lidar-hag-alternative",
         "lidar-intensity", "lidar-returns", "magma", "magma_r", "modis-10A1", "modis-10A2",
         "modis-13A1|Q1", "modis-14A1|A2", "modis-15A2H|A3H", "modis-16A3GF-ET", "modis-16A3GF-PET",
         "modis-17A2H|A2HGF", "modis-17A3HGF", "modis-64A1", "mtbs-severity", "nipy_spectral",
         "nipy_spectral_r", "nrcan-lulc", "ocean", "ocean_r", "oranges", "oranges_r", "orrd", "orrd_r",
         "paired", "paired_r", "pastel1", "pastel1_r", "pastel2", "pastel2_r", "pink", "pink_r", "piyg",
         "piyg_r", "plasma", "plasma_r", "prgn", "prgn_r", "prism", "prism_r", "pubu", "pubu_r",
         "pubugn", "pubugn_r", "puor", "puor_r", "purd", "purd_r", "purples", "purples_r", "qpe",
         "rainbow", "rainbow_r", "rdbu", "rdbu_r", "rdgy", "rdgy_r", "rdpu", "rdpu_r", "rdylbu",
         "rdylbu_r", "rdylgn", "rdylgn_r", "reds", "reds_r", "rplumbo", "schwarzwald", "seismic",
         "seismic_r", "set1", "set1_r", "set2", "set2_r", "set3", "set3_r", "spectral", "spectral_r",
         "spring", "spring_r", "summer", "summer_r", "tab10", "tab10_r", "tab20", "tab20_r", "tab20b",
         "tab20b_r", "tab20c", "tab20c_r", "terrain", "terrain_r", "twilight", "twilight_r",
         "twilight_shifted", "twilight_shifted_r", "usda-cdl", "usda-cdl-corn", "usda-cdl-cotton",
         "usda-cdl-soybeans", "usda-cdl-wheat", "usgs-lcmap", "viirs-10a1", "viirs-13a1", "viirs-14a1",
         "viirs-15a2H", "viridis", "viridis_r", "winter", "winter_r", "wistia", "wistia_r", "ylgn",
         "ylgn_r", "ylgnbu", "ylgnbu_r", "ylorbr", "ylorbr_r", "ylorrd", and "ylorrd_r". Default value
         is None.
        :paramtype color_map_name: str or ~azure.planetarycomputer.models.ColorMapNames
        :keyword color_map: JSON encoded custom Colormap. Default value is None.
        :paramtype color_map: str
        :keyword return_mask: Add mask to the output data. Default value is None.
        :paramtype return_mask: bool
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_data_get_wmts_capabilities_request(
            collection_id=collection_id,
            item_id=item_id,
            tile_matrix_set_id=tile_matrix_set_id,
            assets=assets,
            expression=expression,
            asset_band_indices=asset_band_indices,
            asset_as_band=asset_as_band,
            no_data=no_data,
            unscale=unscale,
            algorithm=algorithm,
            algorithm_params=algorithm_params,
            tile_format=tile_format,
            tile_scale=tile_scale,
            min_zoom=min_zoom,
            max_zoom=max_zoom,
            buffer=buffer,
            color_formula=color_formula,
            resampling=resampling,
            rescale=rescale,
            color_map_name=color_map_name,
            color_map=color_map,
            return_mask=return_mask,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", True)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_class_map_legend(
        self, classmap_name: str, *, trim_start: Optional[int] = None, trim_end: Optional[int] = None, **kwargs: Any
    ) -> _models.ClassMapLegendResponse:
        """Get ClassMap Legend.

        Generate values and color swatches mapping for a given classmap.

        :param classmap_name: classmap name. Required.
        :type classmap_name: str
        :keyword trim_start: Number of items to trim from the start of the cmap. Default value is None.
        :paramtype trim_start: int
        :keyword trim_end: Number of items to trim from the end of the cmap. Default value is None.
        :paramtype trim_end: int
        :return: ClassMapLegendResponse. The ClassMapLegendResponse is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.ClassMapLegendResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ClassMapLegendResponse] = kwargs.pop("cls", None)

        _request = build_data_get_class_map_legend_request(
            classmap_name=classmap_name,
            trim_start=trim_start,
            trim_end=trim_end,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.ClassMapLegendResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_interval_legend(
        self, classmap_name: str, *, trim_start: Optional[int] = None, trim_end: Optional[int] = None, **kwargs: Any
    ) -> List[List[List[int]]]:
        """Get Interval Legend.

        Generate values and color swatches mapping for a given interval classmap.

        Returns a color map for intervals, where each interval is defined by:

        * A numeric range `[min, max]` representing the interval boundaries.
        * An RGBA color `[red, green, blue, alpha]` associated with the interval.

        The response is a 2D array of interval definitions, where each element is a pair:

        * The first element is an array of two numbers `[min, max]` defining the interval.
        * The second element is an array of four numbers `[red, green, blue, alpha]` defining the RGBA
          color.

        Example:

        .. code-block:: json

           [
             [
               [-2, 0], [0, 0, 0, 0]
             ],
             [
               [1, 32], [255, 255, 178, 255]
             ]
           ]

        This example defines two intervals:

        * The interval `[-2, 0]` is mapped to the color `[0, 0, 0, 0]` (transparent black).
        * The interval `[1, 32]` is mapped to the color `[255, 255, 178, 255]` (opaque yellow).

        :param classmap_name: classmap name. Required.
        :type classmap_name: str
        :keyword trim_start: Number of items to trim from the start of the cmap. Default value is None.
        :paramtype trim_start: int
        :keyword trim_end: Number of items to trim from the end of the cmap. Default value is None.
        :paramtype trim_end: int
        :return: list of list of list of int
        :rtype: list[list[list[int]]]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[List[List[int]]]] = kwargs.pop("cls", None)

        _request = build_data_get_interval_legend_request(
            classmap_name=classmap_name,
            trim_start=trim_start,
            trim_end=trim_end,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[List[List[int]]], response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_legend(
        self,
        color_map_name: str,
        *,
        height: Optional[float] = None,
        width: Optional[float] = None,
        trim_start: Optional[int] = None,
        trim_end: Optional[int] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Get Legend.

        Generate a legend image for a given colormap.

        If the colormap has non-contiguous values at the beginning or end,
        which aren't desired in the output image, they can be trimmed by specifying
        the number of values to trim.

        :param color_map_name: The name of the registered colormap to generate a legend for. Required.
        :type color_map_name: str
        :keyword height: The output height of the legend image. Default value is None.
        :paramtype height: float
        :keyword width: The output width of the legend image. Default value is None.
        :paramtype width: float
        :keyword trim_start: Number of items to trim from the start of the cmap. Default value is None.
        :paramtype trim_start: int
        :keyword trim_end: Number of items to trim from the end of the cmap. Default value is None.
        :paramtype trim_end: int
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_data_get_legend_request(
            color_map_name=color_map_name,
            height=height,
            width=width,
            trim_start=trim_start,
            trim_end=trim_end,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", True)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_mosaics_assets_for_point(
        self,
        search_id: str,
        longitude: float,
        latitude: float,
        *,
        scan_limit: Optional[int] = None,
        items_limit: Optional[int] = None,
        time_limit: Optional[int] = None,
        exit_when_full: Optional[bool] = None,
        skip_covered: Optional[bool] = None,
        coordinate_reference_system: Optional[str] = None,
        **kwargs: Any
    ) -> List[_models.StacItemPointAsset]:
        """Assets For Point.

        Return a list of assets for a given point.

        :param search_id: Search Id (pgSTAC Search Hash). Required.
        :type search_id: str
        :param longitude: Longitude. Required.
        :type longitude: float
        :param latitude: Latitude. Required.
        :type latitude: float
        :keyword scan_limit: Return as soon as we scan N items (defaults to 10000 in PgSTAC). Default
         value is None.
        :paramtype scan_limit: int
        :keyword items_limit: Return as soon as we have N items per geometry (defaults to 100 in
         PgSTAC). Default value is None.
        :paramtype items_limit: int
        :keyword time_limit: Return after N seconds to avoid long requests (defaults to 5 in PgSTAC).
         Default value is None.
        :paramtype time_limit: int
        :keyword exit_when_full: Return as soon as the geometry is fully covered (defaults to True in
         PgSTAC). Default value is None.
        :paramtype exit_when_full: bool
        :keyword skip_covered: Skip any items that would show up completely under the previous items
         (defaults
         to True in PgSTAC). Default value is None.
        :paramtype skip_covered: bool
        :keyword coordinate_reference_system: Coordinate Reference System of the input coords. Default
         to ``epsg:4326``. Default value is None.
        :paramtype coordinate_reference_system: str
        :return: list of StacItemPointAsset
        :rtype: list[~azure.planetarycomputer.models.StacItemPointAsset]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.StacItemPointAsset]] = kwargs.pop("cls", None)

        _request = build_data_get_mosaics_assets_for_point_request(
            search_id=search_id,
            longitude=longitude,
            latitude=latitude,
            scan_limit=scan_limit,
            items_limit=items_limit,
            time_limit=time_limit,
            exit_when_full=exit_when_full,
            skip_covered=skip_covered,
            coordinate_reference_system=coordinate_reference_system,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.StacItemPointAsset], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_mosaics_assets_for_tile(
        self,
        search_id: str,
        tile_matrix_set_id: str,
        z: float,
        x: float,
        y: float,
        *,
        collection_id: str,
        scan_limit: Optional[int] = None,
        items_limit: Optional[int] = None,
        time_limit: Optional[int] = None,
        exit_when_full: Optional[bool] = None,
        skip_covered: Optional[bool] = None,
        **kwargs: Any
    ) -> List[_models.TilerAssetGeoJson]:
        """Assets For Tile Tilematrixsetid As Path.

        Return a list of assets which overlap a given tile.

        :param search_id: Search Id (pgSTAC Search Hash). Required.
        :type search_id: str
        :param tile_matrix_set_id: Identifier selecting one of the TileMatrixSetId supported. Required.
        :type tile_matrix_set_id: str
        :param z: Identifier (Z) selecting one of the scales defined in the TileMatrixSet and
         representing the scaleDenominator the tile. Required.
        :type z: float
        :param x: Column (X) index of the tile on the selected TileMatrix. It cannot exceed the
         MatrixHeight-1 for the selected TileMatrix. Required.
        :type x: float
        :param y: Row (Y) index of the tile on the selected TileMatrix. It cannot exceed the
         MatrixWidth-1 for the selected TileMatrix. Required.
        :type y: float
        :keyword collection_id: STAC Collection Identifier. Required.
        :paramtype collection_id: str
        :keyword scan_limit: Return as soon as we scan N items (defaults to 10000 in PgSTAC). Default
         value is None.
        :paramtype scan_limit: int
        :keyword items_limit: Return as soon as we have N items per geometry (defaults to 100 in
         PgSTAC). Default value is None.
        :paramtype items_limit: int
        :keyword time_limit: Return after N seconds to avoid long requests (defaults to 5 in PgSTAC).
         Default value is None.
        :paramtype time_limit: int
        :keyword exit_when_full: Return as soon as the geometry is fully covered (defaults to True in
         PgSTAC). Default value is None.
        :paramtype exit_when_full: bool
        :keyword skip_covered: Skip any items that would show up completely under the previous items
         (defaults
         to True in PgSTAC). Default value is None.
        :paramtype skip_covered: bool
        :return: list of TilerAssetGeoJson
        :rtype: list[~azure.planetarycomputer.models.TilerAssetGeoJson]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.TilerAssetGeoJson]] = kwargs.pop("cls", None)

        _request = build_data_get_mosaics_assets_for_tile_request(
            search_id=search_id,
            tile_matrix_set_id=tile_matrix_set_id,
            z=z,
            x=x,
            y=y,
            collection_id=collection_id,
            scan_limit=scan_limit,
            items_limit=items_limit,
            time_limit=time_limit,
            exit_when_full=exit_when_full,
            skip_covered=skip_covered,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.TilerAssetGeoJson], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_mosaics_search_info(self, search_id: str, **kwargs: Any) -> _models.TilerStacSearchRegistration:
        """Info Search.

        Get Search query metadata.

        :param search_id: Search Id (pgSTAC Search Hash). Required.
        :type search_id: str
        :return: TilerStacSearchRegistration. The TilerStacSearchRegistration is compatible with
         MutableMapping
        :rtype: ~azure.planetarycomputer.models.TilerStacSearchRegistration
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TilerStacSearchRegistration] = kwargs.pop("cls", None)

        _request = build_data_get_mosaics_search_info_request(
            search_id=search_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TilerStacSearchRegistration, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def register_mosaics_search(
        self,
        *,
        content_type: str = "application/json",
        collections: Optional[List[str]] = None,
        ids: Optional[List[str]] = None,
        bounding_box: Optional[float] = None,
        intersects: Optional[_models.Geometry] = None,
        query: Optional[dict[str, Any]] = None,
        filter: Optional[dict[str, Any]] = None,
        datetime: Optional[str] = None,
        sort_by: Optional[List[_models.StacSortExtension]] = None,
        filter_language: Optional[Union[str, _models.FilterLanguage]] = None,
        metadata: Optional[_models.MosaicMetadata] = None,
        **kwargs: Any
    ) -> _models.TilerMosaicSearchRegistrationResponse:
        """Register Search.

        Register a Search query.

        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword collections: List of STAC collection IDs to include in the mosaic. Default value is
         None.
        :paramtype collections: list[str]
        :keyword ids: List of specific STAC item IDs to include in the mosaic. Default value is None.
        :paramtype ids: list[str]
        :keyword bounding_box: Geographic bounding box to filter items [west, south, east, north].
         Default value is None.
        :paramtype bounding_box: float
        :keyword intersects: GeoJSON geometry to spatially filter items by intersection. Default value
         is None.
        :paramtype intersects: ~azure.planetarycomputer.models.Geometry
        :keyword query: Query. Default value is None.
        :paramtype query: dict[str, any]
        :keyword filter: Filter. Default value is None.
        :paramtype filter: dict[str, any]
        :keyword datetime: Temporal filter in RFC 3339 format or interval. Default value is None.
        :paramtype datetime: str
        :keyword sort_by: Criteria for ordering items in the mosaic. Default value is None.
        :paramtype sort_by: list[~azure.planetarycomputer.models.StacSortExtension]
        :keyword filter_language: Query language format used in the filter parameter. Known values are:
         "cql-json", "cql2-json", and "cql2-text". Default value is None.
        :paramtype filter_language: str or ~azure.planetarycomputer.models.FilterLanguage
        :keyword metadata: Additional metadata to associate with the mosaic. Default value is None.
        :paramtype metadata: ~azure.planetarycomputer.models.MosaicMetadata
        :return: TilerMosaicSearchRegistrationResponse. The TilerMosaicSearchRegistrationResponse is
         compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.TilerMosaicSearchRegistrationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def register_mosaics_search(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.TilerMosaicSearchRegistrationResponse:
        """Register Search.

        Register a Search query.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TilerMosaicSearchRegistrationResponse. The TilerMosaicSearchRegistrationResponse is
         compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.TilerMosaicSearchRegistrationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def register_mosaics_search(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.TilerMosaicSearchRegistrationResponse:
        """Register Search.

        Register a Search query.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TilerMosaicSearchRegistrationResponse. The TilerMosaicSearchRegistrationResponse is
         compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.TilerMosaicSearchRegistrationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def register_mosaics_search(  # pylint: disable=too-many-locals
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        collections: Optional[List[str]] = None,
        ids: Optional[List[str]] = None,
        bounding_box: Optional[float] = None,
        intersects: Optional[_models.Geometry] = None,
        query: Optional[dict[str, Any]] = None,
        filter: Optional[dict[str, Any]] = None,
        datetime: Optional[str] = None,
        sort_by: Optional[List[_models.StacSortExtension]] = None,
        filter_language: Optional[Union[str, _models.FilterLanguage]] = None,
        metadata: Optional[_models.MosaicMetadata] = None,
        **kwargs: Any
    ) -> _models.TilerMosaicSearchRegistrationResponse:
        """Register Search.

        Register a Search query.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword collections: List of STAC collection IDs to include in the mosaic. Default value is
         None.
        :paramtype collections: list[str]
        :keyword ids: List of specific STAC item IDs to include in the mosaic. Default value is None.
        :paramtype ids: list[str]
        :keyword bounding_box: Geographic bounding box to filter items [west, south, east, north].
         Default value is None.
        :paramtype bounding_box: float
        :keyword intersects: GeoJSON geometry to spatially filter items by intersection. Default value
         is None.
        :paramtype intersects: ~azure.planetarycomputer.models.Geometry
        :keyword query: Query. Default value is None.
        :paramtype query: dict[str, any]
        :keyword filter: Filter. Default value is None.
        :paramtype filter: dict[str, any]
        :keyword datetime: Temporal filter in RFC 3339 format or interval. Default value is None.
        :paramtype datetime: str
        :keyword sort_by: Criteria for ordering items in the mosaic. Default value is None.
        :paramtype sort_by: list[~azure.planetarycomputer.models.StacSortExtension]
        :keyword filter_language: Query language format used in the filter parameter. Known values are:
         "cql-json", "cql2-json", and "cql2-text". Default value is None.
        :paramtype filter_language: str or ~azure.planetarycomputer.models.FilterLanguage
        :keyword metadata: Additional metadata to associate with the mosaic. Default value is None.
        :paramtype metadata: ~azure.planetarycomputer.models.MosaicMetadata
        :return: TilerMosaicSearchRegistrationResponse. The TilerMosaicSearchRegistrationResponse is
         compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.TilerMosaicSearchRegistrationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.TilerMosaicSearchRegistrationResponse] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {
                "bbox": bounding_box,
                "collections": collections,
                "datetime_property": datetime,
                "filter": filter,
                "filter_lang": filter_language,
                "ids": ids,
                "intersects": intersects,
                "metadata": metadata,
                "query": query,
                "sortby": sort_by,
            }
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_data_register_mosaics_search_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TilerMosaicSearchRegistrationResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_mosaics_tile_json(  # pylint: disable=too-many-locals
        self,
        search_id: str,
        tile_matrix_set_id: str,
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        scan_limit: Optional[int] = None,
        items_limit: Optional[int] = None,
        time_limit: Optional[int] = None,
        exit_when_full: Optional[bool] = None,
        skip_covered: Optional[bool] = None,
        algorithm: Optional[Union[str, _models.TerrainAlgorithm]] = None,
        algorithm_params: Optional[str] = None,
        min_zoom: Optional[int] = None,
        max_zoom: Optional[int] = None,
        tile_format: Optional[Union[str, _models.TilerImageFormat]] = None,
        tile_scale: Optional[int] = None,
        buffer: Optional[str] = None,
        color_formula: Optional[str] = None,
        collection: Optional[str] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        pixel_selection: Optional[Union[str, _models.PixelSelection]] = None,
        rescale: Optional[List[str]] = None,
        color_map_name: Optional[Union[str, _models.ColorMapNames]] = None,
        color_map: Optional[str] = None,
        return_mask: Optional[bool] = None,
        **kwargs: Any
    ) -> _models.TileJsonMetadata:
        """TileJson Tilematrixsetid As Path.

        Return TileJSON document for a searchId.

        :param search_id: Search Id (pgSTAC Search Hash). Required.
        :type search_id: str
        :param tile_matrix_set_id: Identifier selecting one of the TileMatrixSetId supported. Required.
        :type tile_matrix_set_id: str
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword scan_limit: Return as soon as we scan N items (defaults to 10000 in PgSTAC). Default
         value is None.
        :paramtype scan_limit: int
        :keyword items_limit: Return as soon as we have N items per geometry (defaults to 100 in
         PgSTAC). Default value is None.
        :paramtype items_limit: int
        :keyword time_limit: Return after N seconds to avoid long requests (defaults to 5 in PgSTAC).
         Default value is None.
        :paramtype time_limit: int
        :keyword exit_when_full: Return as soon as the geometry is fully covered (defaults to True in
         PgSTAC). Default value is None.
        :paramtype exit_when_full: bool
        :keyword skip_covered: Skip any items that would show up completely under the previous items
         (defaults
         to True in PgSTAC). Default value is None.
        :paramtype skip_covered: bool
        :keyword algorithm: Terrain algorithm name. Known values are: "hillshade", "contours",
         "normalizedIndex", "terrarium", and "terrainrgb". Default value is None.
        :paramtype algorithm: str or ~azure.planetarycomputer.models.TerrainAlgorithm
        :keyword algorithm_params: Terrain algorithm parameters. Default value is None.
        :paramtype algorithm_params: str
        :keyword min_zoom: Overwrite default minzoom. Default value is None.
        :paramtype min_zoom: int
        :keyword max_zoom: Overwrite default maxzoom. Default value is None.
        :paramtype max_zoom: int
        :keyword tile_format: Default will be automatically defined if the output image needs a mask
         (png) or
         not (jpeg). Known values are: "png", "npy", "tif", "jpeg", "jpg", "jp2", "webp", and "pngraw".
         Default value is None.
        :paramtype tile_format: str or ~azure.planetarycomputer.models.TilerImageFormat
        :keyword tile_scale: Tile scale factor affecting output size. Values > 1 produce larger tiles
         (e.g., 1=256x256, 2=512x512). Default value is None.
        :paramtype tile_scale: int
        :keyword buffer: Buffer on each side of the given tile. It must be a multiple of ``0.5``.
         Output
         **tilesize** will be expanded to ``tilesize + 2 * buffer`` (e.g 0.5 = 257x257,
         1.0 = 258x258). Default value is None.
        :paramtype buffer: str
        :keyword color_formula: rio-color formula (info: `https://github.com/mapbox/rio-color
         <https://github.com/mapbox/rio-color>`_). Default value is None.
        :paramtype color_formula: str
        :keyword collection: STAC Collection ID. Default value is None.
        :paramtype collection: str
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :keyword pixel_selection: Pixel selection method. Known values are: "first", "highest",
         "lowest", "mean", "median", "stdev", "lastbandlow", and "lastbandhigh". Default value is None.
        :paramtype pixel_selection: str or ~azure.planetarycomputer.models.PixelSelection
        :keyword rescale: comma (',') delimited Min,Max range. Can set multiple time for multiple
         bands. Default value is None.
        :paramtype rescale: list[str]
        :keyword color_map_name: Colormap name. Known values are: "accent", "accent_r", "afmhot",
         "afmhot_r", "ai4g-lulc", "alos-fnf", "alos-palsar-mask", "autumn", "autumn_r", "binary",
         "binary_r", "blues", "blues_r", "bone", "bone_r", "brbg", "brbg_r", "brg", "brg_r", "bugn",
         "bugn_r", "bupu", "bupu_r", "bwr", "bwr_r", "c-cap", "cfastie", "chesapeake-lc-13",
         "chesapeake-lc-7", "chesapeake-lu", "chloris-biomass", "cividis", "cividis_r", "cmrmap",
         "cmrmap_r", "cool", "cool_r", "coolwarm", "coolwarm_r", "copper", "copper_r", "cubehelix",
         "cubehelix_r", "dark2", "dark2_r", "drcog-lulc", "esa-cci-lc", "esa-worldcover", "flag",
         "flag_r", "gap-lulc", "gist_earth", "gist_earth_r", "gist_gray", "gist_gray_r", "gist_heat",
         "gist_heat_r", "gist_ncar", "gist_ncar_r", "gist_rainbow", "gist_rainbow_r", "gist_stern",
         "gist_stern_r", "gist_yarg", "gist_yarg_r", "gnbu", "gnbu_r", "gnuplot", "gnuplot2",
         "gnuplot2_r", "gnuplot_r", "gray", "gray_r", "greens", "greens_r", "greys", "greys_r", "hot",
         "hot_r", "hsv", "hsv_r", "inferno", "inferno_r", "io-bii", "io-lulc", "io-lulc-9-class", "jet",
         "jet_r", "jrc-change", "jrc-extent", "jrc-occurrence", "jrc-recurrence", "jrc-seasonality",
         "jrc-transitions", "lidar-classification", "lidar-hag", "lidar-hag-alternative",
         "lidar-intensity", "lidar-returns", "magma", "magma_r", "modis-10A1", "modis-10A2",
         "modis-13A1|Q1", "modis-14A1|A2", "modis-15A2H|A3H", "modis-16A3GF-ET", "modis-16A3GF-PET",
         "modis-17A2H|A2HGF", "modis-17A3HGF", "modis-64A1", "mtbs-severity", "nipy_spectral",
         "nipy_spectral_r", "nrcan-lulc", "ocean", "ocean_r", "oranges", "oranges_r", "orrd", "orrd_r",
         "paired", "paired_r", "pastel1", "pastel1_r", "pastel2", "pastel2_r", "pink", "pink_r", "piyg",
         "piyg_r", "plasma", "plasma_r", "prgn", "prgn_r", "prism", "prism_r", "pubu", "pubu_r",
         "pubugn", "pubugn_r", "puor", "puor_r", "purd", "purd_r", "purples", "purples_r", "qpe",
         "rainbow", "rainbow_r", "rdbu", "rdbu_r", "rdgy", "rdgy_r", "rdpu", "rdpu_r", "rdylbu",
         "rdylbu_r", "rdylgn", "rdylgn_r", "reds", "reds_r", "rplumbo", "schwarzwald", "seismic",
         "seismic_r", "set1", "set1_r", "set2", "set2_r", "set3", "set3_r", "spectral", "spectral_r",
         "spring", "spring_r", "summer", "summer_r", "tab10", "tab10_r", "tab20", "tab20_r", "tab20b",
         "tab20b_r", "tab20c", "tab20c_r", "terrain", "terrain_r", "twilight", "twilight_r",
         "twilight_shifted", "twilight_shifted_r", "usda-cdl", "usda-cdl-corn", "usda-cdl-cotton",
         "usda-cdl-soybeans", "usda-cdl-wheat", "usgs-lcmap", "viirs-10a1", "viirs-13a1", "viirs-14a1",
         "viirs-15a2H", "viridis", "viridis_r", "winter", "winter_r", "wistia", "wistia_r", "ylgn",
         "ylgn_r", "ylgnbu", "ylgnbu_r", "ylorbr", "ylorbr_r", "ylorrd", and "ylorrd_r". Default value
         is None.
        :paramtype color_map_name: str or ~azure.planetarycomputer.models.ColorMapNames
        :keyword color_map: JSON encoded custom Colormap. Default value is None.
        :paramtype color_map: str
        :keyword return_mask: Add mask to the output data. Default value is None.
        :paramtype return_mask: bool
        :return: TileJsonMetadata. The TileJsonMetadata is compatible with MutableMapping
        :rtype: ~azure.planetarycomputer.models.TileJsonMetadata
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TileJsonMetadata] = kwargs.pop("cls", None)

        _request = build_data_get_mosaics_tile_json_request(
            search_id=search_id,
            tile_matrix_set_id=tile_matrix_set_id,
            assets=assets,
            expression=expression,
            asset_band_indices=asset_band_indices,
            asset_as_band=asset_as_band,
            no_data=no_data,
            unscale=unscale,
            scan_limit=scan_limit,
            items_limit=items_limit,
            time_limit=time_limit,
            exit_when_full=exit_when_full,
            skip_covered=skip_covered,
            algorithm=algorithm,
            algorithm_params=algorithm_params,
            min_zoom=min_zoom,
            max_zoom=max_zoom,
            tile_format=tile_format,
            tile_scale=tile_scale,
            buffer=buffer,
            color_formula=color_formula,
            collection=collection,
            resampling=resampling,
            pixel_selection=pixel_selection,
            rescale=rescale,
            color_map_name=color_map_name,
            color_map=color_map,
            return_mask=return_mask,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TileJsonMetadata, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_mosaics_tile(  # pylint: disable=too-many-locals
        self,
        search_id: str,
        tile_matrix_set_id: str,
        z: float,
        x: float,
        y: float,
        scale: float,
        format: str,
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        scan_limit: Optional[int] = None,
        items_limit: Optional[int] = None,
        time_limit: Optional[int] = None,
        exit_when_full: Optional[bool] = None,
        skip_covered: Optional[bool] = None,
        algorithm: Optional[Union[str, _models.TerrainAlgorithm]] = None,
        algorithm_params: Optional[str] = None,
        buffer: Optional[str] = None,
        color_formula: Optional[str] = None,
        collection: Optional[str] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        pixel_selection: Optional[Union[str, _models.PixelSelection]] = None,
        rescale: Optional[List[str]] = None,
        color_map_name: Optional[Union[str, _models.ColorMapNames]] = None,
        color_map: Optional[str] = None,
        return_mask: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Tile Tilematrixsetid As Path.

        Create map tile.

        :param search_id: Search Id (pgSTAC Search Hash). Required.
        :type search_id: str
        :param tile_matrix_set_id: Identifier selecting one of the TileMatrixSetId supported. Required.
        :type tile_matrix_set_id: str
        :param z: Identifier (Z) selecting one of the scales defined in the TileMatrixSet and
         representing the scaleDenominator the tile. Required.
        :type z: float
        :param x: Column (X) index of the tile on the selected TileMatrix. It cannot exceed the
         MatrixHeight-1 for the selected TileMatrix. Required.
        :type x: float
        :param y: Row (Y) index of the tile on the selected TileMatrix. It cannot exceed the
         MatrixWidth-1 for the selected TileMatrix. Required.
        :type y: float
        :param scale: Numeric scale factor for the tile. Higher values produce larger tiles. Required.
        :type scale: float
        :param format: Output format for the tile or image (e.g., png, jpeg, webp). Required.
        :type format: str
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword scan_limit: Return as soon as we scan N items (defaults to 10000 in PgSTAC). Default
         value is None.
        :paramtype scan_limit: int
        :keyword items_limit: Return as soon as we have N items per geometry (defaults to 100 in
         PgSTAC). Default value is None.
        :paramtype items_limit: int
        :keyword time_limit: Return after N seconds to avoid long requests (defaults to 5 in PgSTAC).
         Default value is None.
        :paramtype time_limit: int
        :keyword exit_when_full: Return as soon as the geometry is fully covered (defaults to True in
         PgSTAC). Default value is None.
        :paramtype exit_when_full: bool
        :keyword skip_covered: Skip any items that would show up completely under the previous items
         (defaults
         to True in PgSTAC). Default value is None.
        :paramtype skip_covered: bool
        :keyword algorithm: Terrain algorithm name. Known values are: "hillshade", "contours",
         "normalizedIndex", "terrarium", and "terrainrgb". Default value is None.
        :paramtype algorithm: str or ~azure.planetarycomputer.models.TerrainAlgorithm
        :keyword algorithm_params: Terrain algorithm parameters. Default value is None.
        :paramtype algorithm_params: str
        :keyword buffer: Buffer on each side of the given tile. It must be a multiple of ``0.5``.
         Output
         **tilesize** will be expanded to ``tilesize + 2 * buffer`` (e.g 0.5 = 257x257,
         1.0 = 258x258). Default value is None.
        :paramtype buffer: str
        :keyword color_formula: rio-color formula (info: `https://github.com/mapbox/rio-color
         <https://github.com/mapbox/rio-color>`_). Default value is None.
        :paramtype color_formula: str
        :keyword collection: STAC Collection ID. Default value is None.
        :paramtype collection: str
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :keyword pixel_selection: Pixel selection method. Known values are: "first", "highest",
         "lowest", "mean", "median", "stdev", "lastbandlow", and "lastbandhigh". Default value is None.
        :paramtype pixel_selection: str or ~azure.planetarycomputer.models.PixelSelection
        :keyword rescale: comma (',') delimited Min,Max range. Can set multiple time for multiple
         bands. Default value is None.
        :paramtype rescale: list[str]
        :keyword color_map_name: Colormap name. Known values are: "accent", "accent_r", "afmhot",
         "afmhot_r", "ai4g-lulc", "alos-fnf", "alos-palsar-mask", "autumn", "autumn_r", "binary",
         "binary_r", "blues", "blues_r", "bone", "bone_r", "brbg", "brbg_r", "brg", "brg_r", "bugn",
         "bugn_r", "bupu", "bupu_r", "bwr", "bwr_r", "c-cap", "cfastie", "chesapeake-lc-13",
         "chesapeake-lc-7", "chesapeake-lu", "chloris-biomass", "cividis", "cividis_r", "cmrmap",
         "cmrmap_r", "cool", "cool_r", "coolwarm", "coolwarm_r", "copper", "copper_r", "cubehelix",
         "cubehelix_r", "dark2", "dark2_r", "drcog-lulc", "esa-cci-lc", "esa-worldcover", "flag",
         "flag_r", "gap-lulc", "gist_earth", "gist_earth_r", "gist_gray", "gist_gray_r", "gist_heat",
         "gist_heat_r", "gist_ncar", "gist_ncar_r", "gist_rainbow", "gist_rainbow_r", "gist_stern",
         "gist_stern_r", "gist_yarg", "gist_yarg_r", "gnbu", "gnbu_r", "gnuplot", "gnuplot2",
         "gnuplot2_r", "gnuplot_r", "gray", "gray_r", "greens", "greens_r", "greys", "greys_r", "hot",
         "hot_r", "hsv", "hsv_r", "inferno", "inferno_r", "io-bii", "io-lulc", "io-lulc-9-class", "jet",
         "jet_r", "jrc-change", "jrc-extent", "jrc-occurrence", "jrc-recurrence", "jrc-seasonality",
         "jrc-transitions", "lidar-classification", "lidar-hag", "lidar-hag-alternative",
         "lidar-intensity", "lidar-returns", "magma", "magma_r", "modis-10A1", "modis-10A2",
         "modis-13A1|Q1", "modis-14A1|A2", "modis-15A2H|A3H", "modis-16A3GF-ET", "modis-16A3GF-PET",
         "modis-17A2H|A2HGF", "modis-17A3HGF", "modis-64A1", "mtbs-severity", "nipy_spectral",
         "nipy_spectral_r", "nrcan-lulc", "ocean", "ocean_r", "oranges", "oranges_r", "orrd", "orrd_r",
         "paired", "paired_r", "pastel1", "pastel1_r", "pastel2", "pastel2_r", "pink", "pink_r", "piyg",
         "piyg_r", "plasma", "plasma_r", "prgn", "prgn_r", "prism", "prism_r", "pubu", "pubu_r",
         "pubugn", "pubugn_r", "puor", "puor_r", "purd", "purd_r", "purples", "purples_r", "qpe",
         "rainbow", "rainbow_r", "rdbu", "rdbu_r", "rdgy", "rdgy_r", "rdpu", "rdpu_r", "rdylbu",
         "rdylbu_r", "rdylgn", "rdylgn_r", "reds", "reds_r", "rplumbo", "schwarzwald", "seismic",
         "seismic_r", "set1", "set1_r", "set2", "set2_r", "set3", "set3_r", "spectral", "spectral_r",
         "spring", "spring_r", "summer", "summer_r", "tab10", "tab10_r", "tab20", "tab20_r", "tab20b",
         "tab20b_r", "tab20c", "tab20c_r", "terrain", "terrain_r", "twilight", "twilight_r",
         "twilight_shifted", "twilight_shifted_r", "usda-cdl", "usda-cdl-corn", "usda-cdl-cotton",
         "usda-cdl-soybeans", "usda-cdl-wheat", "usgs-lcmap", "viirs-10a1", "viirs-13a1", "viirs-14a1",
         "viirs-15a2H", "viridis", "viridis_r", "winter", "winter_r", "wistia", "wistia_r", "ylgn",
         "ylgn_r", "ylgnbu", "ylgnbu_r", "ylorbr", "ylorbr_r", "ylorrd", and "ylorrd_r". Default value
         is None.
        :paramtype color_map_name: str or ~azure.planetarycomputer.models.ColorMapNames
        :keyword color_map: JSON encoded custom Colormap. Default value is None.
        :paramtype color_map: str
        :keyword return_mask: Add mask to the output data. Default value is None.
        :paramtype return_mask: bool
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_data_get_mosaics_tile_request(
            search_id=search_id,
            tile_matrix_set_id=tile_matrix_set_id,
            z=z,
            x=x,
            y=y,
            scale=scale,
            format=format,
            assets=assets,
            expression=expression,
            asset_band_indices=asset_band_indices,
            asset_as_band=asset_as_band,
            no_data=no_data,
            unscale=unscale,
            scan_limit=scan_limit,
            items_limit=items_limit,
            time_limit=time_limit,
            exit_when_full=exit_when_full,
            skip_covered=skip_covered,
            algorithm=algorithm,
            algorithm_params=algorithm_params,
            buffer=buffer,
            color_formula=color_formula,
            collection=collection,
            resampling=resampling,
            pixel_selection=pixel_selection,
            rescale=rescale,
            color_map_name=color_map_name,
            color_map=color_map,
            return_mask=return_mask,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", True)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_mosaics_wmts_capabilities(  # pylint: disable=too-many-locals
        self,
        search_id: str,
        tile_matrix_set_id: str,
        *,
        assets: Optional[List[str]] = None,
        expression: Optional[str] = None,
        asset_band_indices: Optional[str] = None,
        asset_as_band: Optional[bool] = None,
        no_data: Optional[float] = None,
        unscale: Optional[bool] = None,
        algorithm: Optional[Union[str, _models.TerrainAlgorithm]] = None,
        algorithm_params: Optional[str] = None,
        tile_format: Optional[Union[str, _models.TilerImageFormat]] = None,
        tile_scale: Optional[int] = None,
        min_zoom: Optional[int] = None,
        max_zoom: Optional[int] = None,
        buffer: Optional[str] = None,
        color_formula: Optional[str] = None,
        resampling: Optional[Union[str, _models.Resampling]] = None,
        rescale: Optional[List[str]] = None,
        color_map_name: Optional[Union[str, _models.ColorMapNames]] = None,
        color_map: Optional[str] = None,
        return_mask: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Wmts Tilematrixsetid As Path.

        OGC WMTS endpoint.

        :param search_id: Search Id (pgSTAC Search Hash). Required.
        :type search_id: str
        :param tile_matrix_set_id: Identifier selecting one of the TileMatrixSetId supported. Required.
        :type tile_matrix_set_id: str
        :keyword assets: Asset's names. Default value is None.
        :paramtype assets: list[str]
        :keyword expression: Band math expression between assets. Default value is None.
        :paramtype expression: str
        :keyword asset_band_indices: Per asset band indexes (coma separated indexes, e.g. "image|1,2,3"
         means use the bands 1, 2, and 3 from the asset named "image"). Default value is None.
        :paramtype asset_band_indices: str
        :keyword asset_as_band: Asset as Band. Default value is None.
        :paramtype asset_as_band: bool
        :keyword no_data: Overwrite internal Nodata value. Default value is None.
        :paramtype no_data: float
        :keyword unscale: Apply internal Scale or Offset. Default value is None.
        :paramtype unscale: bool
        :keyword algorithm: Terrain algorithm name. Known values are: "hillshade", "contours",
         "normalizedIndex", "terrarium", and "terrainrgb". Default value is None.
        :paramtype algorithm: str or ~azure.planetarycomputer.models.TerrainAlgorithm
        :keyword algorithm_params: Terrain algorithm parameters. Default value is None.
        :paramtype algorithm_params: str
        :keyword tile_format: Output image type. Default is png. Known values are: "png", "npy", "tif",
         "jpeg", "jpg", "jp2", "webp", and "pngraw". Default value is None.
        :paramtype tile_format: str or ~azure.planetarycomputer.models.TilerImageFormat
        :keyword tile_scale: Tile scale factor affecting output size. Values > 1 produce larger tiles
         (e.g., 1=256x256, 2=512x512). Default value is None.
        :paramtype tile_scale: int
        :keyword min_zoom: Overwrite default minzoom. Default value is None.
        :paramtype min_zoom: int
        :keyword max_zoom: Overwrite default maxzoom. Default value is None.
        :paramtype max_zoom: int
        :keyword buffer: Buffer on each side of the given tile. It must be a multiple of ``0.5``.
         Output
         **tilesize** will be expanded to ``tilesize + 2 * buffer`` (e.g 0.5 = 257x257,
         1.0 = 258x258). Default value is None.
        :paramtype buffer: str
        :keyword color_formula: rio-color formula (info: `https://github.com/mapbox/rio-color
         <https://github.com/mapbox/rio-color>`_). Default value is None.
        :paramtype color_formula: str
        :keyword resampling: Resampling method. Known values are: "nearest", "bilinear", "cubic",
         "cubic_spline", "lanczos", "average", "mode", "gauss", and "rms". Default value is None.
        :paramtype resampling: str or ~azure.planetarycomputer.models.Resampling
        :keyword rescale: comma (',') delimited Min,Max range. Can set multiple time for multiple
         bands. Default value is None.
        :paramtype rescale: list[str]
        :keyword color_map_name: Colormap name. Known values are: "accent", "accent_r", "afmhot",
         "afmhot_r", "ai4g-lulc", "alos-fnf", "alos-palsar-mask", "autumn", "autumn_r", "binary",
         "binary_r", "blues", "blues_r", "bone", "bone_r", "brbg", "brbg_r", "brg", "brg_r", "bugn",
         "bugn_r", "bupu", "bupu_r", "bwr", "bwr_r", "c-cap", "cfastie", "chesapeake-lc-13",
         "chesapeake-lc-7", "chesapeake-lu", "chloris-biomass", "cividis", "cividis_r", "cmrmap",
         "cmrmap_r", "cool", "cool_r", "coolwarm", "coolwarm_r", "copper", "copper_r", "cubehelix",
         "cubehelix_r", "dark2", "dark2_r", "drcog-lulc", "esa-cci-lc", "esa-worldcover", "flag",
         "flag_r", "gap-lulc", "gist_earth", "gist_earth_r", "gist_gray", "gist_gray_r", "gist_heat",
         "gist_heat_r", "gist_ncar", "gist_ncar_r", "gist_rainbow", "gist_rainbow_r", "gist_stern",
         "gist_stern_r", "gist_yarg", "gist_yarg_r", "gnbu", "gnbu_r", "gnuplot", "gnuplot2",
         "gnuplot2_r", "gnuplot_r", "gray", "gray_r", "greens", "greens_r", "greys", "greys_r", "hot",
         "hot_r", "hsv", "hsv_r", "inferno", "inferno_r", "io-bii", "io-lulc", "io-lulc-9-class", "jet",
         "jet_r", "jrc-change", "jrc-extent", "jrc-occurrence", "jrc-recurrence", "jrc-seasonality",
         "jrc-transitions", "lidar-classification", "lidar-hag", "lidar-hag-alternative",
         "lidar-intensity", "lidar-returns", "magma", "magma_r", "modis-10A1", "modis-10A2",
         "modis-13A1|Q1", "modis-14A1|A2", "modis-15A2H|A3H", "modis-16A3GF-ET", "modis-16A3GF-PET",
         "modis-17A2H|A2HGF", "modis-17A3HGF", "modis-64A1", "mtbs-severity", "nipy_spectral",
         "nipy_spectral_r", "nrcan-lulc", "ocean", "ocean_r", "oranges", "oranges_r", "orrd", "orrd_r",
         "paired", "paired_r", "pastel1", "pastel1_r", "pastel2", "pastel2_r", "pink", "pink_r", "piyg",
         "piyg_r", "plasma", "plasma_r", "prgn", "prgn_r", "prism", "prism_r", "pubu", "pubu_r",
         "pubugn", "pubugn_r", "puor", "puor_r", "purd", "purd_r", "purples", "purples_r", "qpe",
         "rainbow", "rainbow_r", "rdbu", "rdbu_r", "rdgy", "rdgy_r", "rdpu", "rdpu_r", "rdylbu",
         "rdylbu_r", "rdylgn", "rdylgn_r", "reds", "reds_r", "rplumbo", "schwarzwald", "seismic",
         "seismic_r", "set1", "set1_r", "set2", "set2_r", "set3", "set3_r", "spectral", "spectral_r",
         "spring", "spring_r", "summer", "summer_r", "tab10", "tab10_r", "tab20", "tab20_r", "tab20b",
         "tab20b_r", "tab20c", "tab20c_r", "terrain", "terrain_r", "twilight", "twilight_r",
         "twilight_shifted", "twilight_shifted_r", "usda-cdl", "usda-cdl-corn", "usda-cdl-cotton",
         "usda-cdl-soybeans", "usda-cdl-wheat", "usgs-lcmap", "viirs-10a1", "viirs-13a1", "viirs-14a1",
         "viirs-15a2H", "viridis", "viridis_r", "winter", "winter_r", "wistia", "wistia_r", "ylgn",
         "ylgn_r", "ylgnbu", "ylgnbu_r", "ylorbr", "ylorbr_r", "ylorrd", and "ylorrd_r". Default value
         is None.
        :paramtype color_map_name: str or ~azure.planetarycomputer.models.ColorMapNames
        :keyword color_map: JSON encoded custom Colormap. Default value is None.
        :paramtype color_map: str
        :keyword return_mask: Add mask to the output data. Default value is None.
        :paramtype return_mask: bool
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_data_get_mosaics_wmts_capabilities_request(
            search_id=search_id,
            tile_matrix_set_id=tile_matrix_set_id,
            assets=assets,
            expression=expression,
            asset_band_indices=asset_band_indices,
            asset_as_band=asset_as_band,
            no_data=no_data,
            unscale=unscale,
            algorithm=algorithm,
            algorithm_params=algorithm_params,
            tile_format=tile_format,
            tile_scale=tile_scale,
            min_zoom=min_zoom,
            max_zoom=max_zoom,
            buffer=buffer,
            color_formula=color_formula,
            resampling=resampling,
            rescale=rescale,
            color_map_name=color_map_name,
            color_map=color_map,
            return_mask=return_mask,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", True)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore


class SharedAccessSignatureOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.planetarycomputer.aio.PlanetaryComputerProClient`'s
        :attr:`shared_access_signature` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: PlanetaryComputerProClientConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get_sign(
        self, *, href: str, duration_in_minutes: Optional[int] = None, **kwargs: Any
    ) -> _models.SharedAccessSignatureSignedLink:
        """sign an HREF in the format of a URL and returns a SharedAccessSignatureSignedHrefResponse.

        Signs a HREF (a link URL) by appending a `SAS Token
        <https://docs.microsoft.com//azure/storage/common/storage-sas-overview#how-a-shared-access-signature-works>`_.
        If the HREF is not a Azure Blob Storage HREF, then pass back the HREF unsigned.

        :keyword href: Href. Required.
        :paramtype href: str
        :keyword duration_in_minutes: Duration. Default value is None.
        :paramtype duration_in_minutes: int
        :return: SharedAccessSignatureSignedLink. The SharedAccessSignatureSignedLink is compatible
         with MutableMapping
        :rtype: ~azure.planetarycomputer.models.SharedAccessSignatureSignedLink
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.SharedAccessSignatureSignedLink] = kwargs.pop("cls", None)

        _request = build_shared_access_signature_get_sign_request(
            href=href,
            duration_in_minutes=duration_in_minutes,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.SharedAccessSignatureSignedLink, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_token(
        self, collection_id: str, *, duration_in_minutes: Optional[int] = None, **kwargs: Any
    ) -> _models.SharedAccessSignatureToken:
        """generate a SAS Token for the given Azure Blob storage account and container.

        Generate a `SAS Token
        <https://docs.microsoft.com//azure/storage/common/storage-sas-overview#how-a-shared-access-signature-works>`_
        for the given storage account and container. The storage account and container must be
        associated with a Planetary Computer dataset indexed by the STAC API.

        :param collection_id: Collection Id. Required.
        :type collection_id: str
        :keyword duration_in_minutes: Duration. Default value is None.
        :paramtype duration_in_minutes: int
        :return: SharedAccessSignatureToken. The SharedAccessSignatureToken is compatible with
         MutableMapping
        :rtype: ~azure.planetarycomputer.models.SharedAccessSignatureToken
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.SharedAccessSignatureToken] = kwargs.pop("cls", None)

        _request = build_shared_access_signature_get_token_request(
            collection_id=collection_id,
            duration_in_minutes=duration_in_minutes,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.SharedAccessSignatureToken, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def revoke_token(self, *, duration_in_minutes: Optional[int] = None, **kwargs: Any) -> None:
        """Revoke SAS token for the managed storage account of this GeoCatalog.

        Revoke a `SAS Token
        <https://docs.microsoft.com//azure/storage/common/storage-sas-overview#how-a-shared-access-signature-works>`_
        for managed storage account of this GeoCatalog.

        :keyword duration_in_minutes: Duration. Default value is None.
        :paramtype duration_in_minutes: int
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_shared_access_signature_revoke_token_request(
            duration_in_minutes=duration_in_minutes,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
