# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class Action(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The action of virtual network rule."""

    ALLOW = "Allow"


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class AutoScalePolicyEnforcement(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enable or Disable scale up setting on Elastic San Appliance."""

    NONE = "None"
    ENABLED = "Enabled"
    DISABLED = "Disabled"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class EncryptionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of key used to encrypt the data of the disk."""

    ENCRYPTION_AT_REST_WITH_PLATFORM_KEY = "EncryptionAtRestWithPlatformKey"
    """Volume is encrypted at rest with Platform managed key. It is the default encryption type."""
    ENCRYPTION_AT_REST_WITH_CUSTOMER_MANAGED_KEY = "EncryptionAtRestWithCustomerManagedKey"
    """Volume is encrypted at rest with Customer managed key that can be changed and revoked by a
    customer."""


class IdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The identity type."""

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"


class OperationalStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Operational status of the resource."""

    INVALID = "Invalid"
    UNKNOWN = "Unknown"
    HEALTHY = "Healthy"
    UNHEALTHY = "Unhealthy"
    UPDATING = "Updating"
    RUNNING = "Running"
    STOPPED = "Stopped"
    STOPPED_DEALLOCATED_ = "Stopped (deallocated)"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class PrivateEndpointServiceConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The private endpoint connection status."""

    PENDING = "Pending"
    APPROVED = "Approved"
    FAILED = "Failed"
    REJECTED = "Rejected"


class ProvisioningStates(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the iSCSI Target."""

    INVALID = "Invalid"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    PENDING = "Pending"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    DELETED = "Deleted"
    RESTORING = "Restoring"


class PublicNetworkAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Allow or disallow public network access to ElasticSan. Value is optional but if passed in, must
    be 'Enabled' or 'Disabled'.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class SkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The sku name."""

    PREMIUM_LRS = "Premium_LRS"
    """Premium locally redundant storage"""
    PREMIUM_ZRS = "Premium_ZRS"
    """Premium zone redundant storage"""


class SkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The sku tier."""

    PREMIUM = "Premium"
    """Premium Tier"""


class StorageTargetType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Storage Target type."""

    ISCSI = "Iscsi"
    NONE = "None"


class VolumeCreateOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This enumerates the possible sources of a volume creation."""

    NONE = "None"
    VOLUME_SNAPSHOT = "VolumeSnapshot"
    DISK_SNAPSHOT = "DiskSnapshot"
    DISK = "Disk"
    DISK_RESTORE_POINT = "DiskRestorePoint"


class XMsDeleteSnapshots(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of XMsDeleteSnapshots."""

    TRUE = "true"
    FALSE = "false"


class XMsForceDelete(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of XMsForceDelete."""

    TRUE = "true"
    FALSE = "false"
