# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerregistrytasks.aio import ContainerRegistryTasksMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerRegistryTasksMgmtTaskRunsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerRegistryTasksMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_task_runs_get(self, resource_group):
        response = await self.client.task_runs.get(
            resource_group_name=resource_group.name,
            registry_name="str",
            task_run_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_task_runs_begin_create(self, resource_group):
        response = await (
            await self.client.task_runs.begin_create(
                resource_group_name=resource_group.name,
                registry_name="str",
                task_run_name="str",
                task_run={
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "properties": {
                        "forceUpdateTag": "str",
                        "provisioningState": "str",
                        "runRequest": "run_request",
                        "runResult": {
                            "id": "str",
                            "name": "str",
                            "properties": {
                                "agentConfiguration": {"cpu": 0},
                                "agentPoolName": "str",
                                "createTime": "2020-02-20 00:00:00",
                                "customRegistries": ["str"],
                                "finishTime": "2020-02-20 00:00:00",
                                "imageUpdateTrigger": {
                                    "id": "str",
                                    "images": [{"digest": "str", "registry": "str", "repository": "str", "tag": "str"}],
                                    "timestamp": "2020-02-20 00:00:00",
                                },
                                "isArchiveEnabled": bool,
                                "lastUpdatedTime": "2020-02-20 00:00:00",
                                "logArtifact": {"digest": "str", "registry": "str", "repository": "str", "tag": "str"},
                                "outputImages": [
                                    {"digest": "str", "registry": "str", "repository": "str", "tag": "str"}
                                ],
                                "platform": {"os": "str", "architecture": "str", "variant": "str"},
                                "provisioningState": "str",
                                "runErrorMessage": "str",
                                "runId": "str",
                                "runType": "str",
                                "sourceRegistryAuth": "str",
                                "sourceTrigger": {
                                    "branchName": "str",
                                    "commitId": "str",
                                    "eventType": "str",
                                    "id": "str",
                                    "providerType": "str",
                                    "pullRequestId": "str",
                                    "repositoryUrl": "str",
                                },
                                "startTime": "2020-02-20 00:00:00",
                                "status": "str",
                                "task": "str",
                                "timerTrigger": {"scheduleOccurrence": "str", "timerTriggerName": "str"},
                                "updateTriggerToken": "str",
                            },
                            "systemData": {
                                "createdAt": "2020-02-20 00:00:00",
                                "createdBy": "str",
                                "createdByType": "str",
                                "lastModifiedAt": "2020-02-20 00:00:00",
                                "lastModifiedBy": "str",
                                "lastModifiedByType": "str",
                            },
                            "type": "str",
                        },
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_task_runs_begin_update(self, resource_group):
        response = await (
            await self.client.task_runs.begin_update(
                resource_group_name=resource_group.name,
                registry_name="str",
                task_run_name="str",
                update_parameters={
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "properties": {"forceUpdateTag": "str", "runRequest": "run_request"},
                    "tags": {"str": "str"},
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_task_runs_delete(self, resource_group):
        response = await self.client.task_runs.delete(
            resource_group_name=resource_group.name,
            registry_name="str",
            task_run_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_task_runs_list(self, resource_group):
        response = self.client.task_runs.list(
            resource_group_name=resource_group.name,
            registry_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_task_runs_get_details(self, resource_group):
        response = await self.client.task_runs.get_details(
            resource_group_name=resource_group.name,
            registry_name="str",
            task_run_name="str",
        )

        # please add some check logic here by yourself
        # ...
