# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.computebulkactions import ComputeBulkActionsMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-computebulkactions
# USAGE
    python bulk_actions_virtual_machines_execute_delete_maximum_set_gen.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ComputeBulkActionsMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.bulk_actions.virtual_machines_execute_delete(
        location="east2us2euap",
        request_body={
            "correlationid": "dfe927c5-16a6-40b7-a0f7-8524975ed642",
            "executionParameters": {"retryPolicy": {"retryCount": 2, "retryWindowInMinutes": 45}},
            "forceDeletion": True,
            "resources": {
                "ids": [
                    "/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.Compute/virtualMachines/testResource3",
                    "/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.Compute/virtualMachines/testResource4",
                ]
            },
        },
    )
    print(response)


# x-ms-original-file: 2026-02-01-preview/BulkActions_VirtualMachinesExecuteDelete_MaximumSet_Gen.json
if __name__ == "__main__":
    main()
