//
//   PsPages.java : This file is part of pstoedit.
//   Java classes needed to run the java code generated by pstoedit -f java
//   
//  
//   Copyright (C) 1998 - 1999 Wolfgang Glunz, wglunz35_AT_pstoedit.net 
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//

import java.awt.*;
import java.util.*;

// the base class for the drawing objects
class PSDrawingObject {
        public PSDrawingObject(Color cp) { c = cp;}
        public void show(Graphics g ) { g.setColor(c);}
        Color c;
}

class FontDesc {
        FontDesc(String n, int s) { name = n; style = s;}
        public String name;
        public int    style;
};

class PSTextObject extends PSDrawingObject {
static FontDesc[] JavaFonts = {
        new FontDesc("Courier",Font.PLAIN),
        new FontDesc("Courier",Font.BOLD),
        new FontDesc("Courier",Font.ITALIC),
        new FontDesc("Courier",Font.BOLD + Font.ITALIC),
        new FontDesc("Helvetica",Font.PLAIN),
        new FontDesc("Helvetica",Font.BOLD),
        new FontDesc("Helvetica",Font.ITALIC),
        new FontDesc("Helvetica",Font.BOLD + Font.ITALIC),
        new FontDesc("TimesRoman",Font.PLAIN),
        new FontDesc("TimesRoman",Font.BOLD),
        new FontDesc("TimesRoman",Font.ITALIC),
        new FontDesc("TimesRoman",Font.BOLD + Font.ITALIC),
        new FontDesc("ZapfDingbats",Font.PLAIN),
        };

        PSTextObject(float r, float g, float b, 
                        String s, int x, int y, 
                        int fontNum, int fsize)
        {
                super(new Color(r,g,b));
                s_=s;
                x_=x;
                y_=y;
                f_=new Font(JavaFonts[fontNum].name, JavaFonts[fontNum].style, fsize);
        }
        PSTextObject(float r, float g, float b, 
                        String s, int x, int y, 
                        String fname, int fstyle, int fsize)
        {
                super(new Color(r,g,b));
                s_=s;
                x_=x;
                y_=y;
                f_=new Font(fname, fstyle, fsize);
        }
        public void show(Graphics g ) {
                super.show(g);
                g.setFont(f_);
                g.drawString(s_,x_,y_);
        }
        Font f_;
        int x_;
        int y_;
        String s_;
}

class PSLinesObject extends PSDrawingObject {
        PSLinesObject(float r, float g, float b) 
        {
                super(new Color(r,g,b));
                points = new Vector();
        }
        public void show(Graphics g ) {
                super.show(g);
                Point lastPoint = null;
                for (Enumeration e = points.elements() ; e.hasMoreElements() ;) {
                                Point currentPoint = (Point)(e.nextElement());
                                if (lastPoint != null) {
                                        g.drawLine( lastPoint.x,lastPoint.y, currentPoint.x,currentPoint.y);
                                }
                                lastPoint = currentPoint;
                } 
        }
        public void addPoint(int x, int y) {
                points.addElement(new Point(x,y));
        }
        Vector points;
}

class PSPolygonObject extends PSDrawingObject {
        public PSPolygonObject(float r, float g, float b) 
        {
                super(new Color(r,g,b));
                p = new Polygon();
        }
        public PSPolygonObject(int [] points,float r, float g, float b) 
        {
                super(new Color(r,g,b));
                p = new Polygon();
        }
        public void show(Graphics g ) {
                super.show(g);
                g.fillPolygon(p);
        }
        public void addPoint(int x, int y) {
                p.addPoint(x,y);
        }
        public Polygon p;
}

// describes a single page
class PageDescription 
{
        public PageDescription() {
                theObjects = new Vector();
        }
        public void showpage(Rectangle r, Graphics g )
        {
                for (Enumeration e = theObjects.elements() ; e.hasMoreElements() ;) {
                        PSDrawingObject current = (PSDrawingObject)(e.nextElement());
                        current.show(g);
                } 
        }
        public Vector theObjects;
}

// describes the set of all pages
public abstract class PsPages 
{

    public void showpage( Rectangle r, int pageNumber, Graphics g ) { 
        System.out.println("showing page #" + pageNumber);
        System.out.println(r);
        g.clearRect(r.x,r.y,r.width,r.height);
        pages[pageNumber-1].showpage(r,g);
    } 

    public abstract int numberOfPages();

    protected PageDescription [] pages;
}

