// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/netapp/v1/common.proto

package netapppb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The service level of a storage pool and its volumes.
type ServiceLevel int32

const (
	// Unspecified service level.
	ServiceLevel_SERVICE_LEVEL_UNSPECIFIED ServiceLevel = 0
	// Premium service level.
	ServiceLevel_PREMIUM ServiceLevel = 1
	// Extreme service level.
	ServiceLevel_EXTREME ServiceLevel = 2
	// Standard service level.
	ServiceLevel_STANDARD ServiceLevel = 3
	// Flex service level.
	ServiceLevel_FLEX ServiceLevel = 4
)

// Enum value maps for ServiceLevel.
var (
	ServiceLevel_name = map[int32]string{
		0: "SERVICE_LEVEL_UNSPECIFIED",
		1: "PREMIUM",
		2: "EXTREME",
		3: "STANDARD",
		4: "FLEX",
	}
	ServiceLevel_value = map[string]int32{
		"SERVICE_LEVEL_UNSPECIFIED": 0,
		"PREMIUM":                   1,
		"EXTREME":                   2,
		"STANDARD":                  3,
		"FLEX":                      4,
	}
)

func (x ServiceLevel) Enum() *ServiceLevel {
	p := new(ServiceLevel)
	*p = x
	return p
}

func (x ServiceLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServiceLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_netapp_v1_common_proto_enumTypes[0].Descriptor()
}

func (ServiceLevel) Type() protoreflect.EnumType {
	return &file_google_cloud_netapp_v1_common_proto_enumTypes[0]
}

func (x ServiceLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServiceLevel.Descriptor instead.
func (ServiceLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_common_proto_rawDescGZIP(), []int{0}
}

// The volume encryption key source.
type EncryptionType int32

const (
	// The source of the encryption key is not specified.
	EncryptionType_ENCRYPTION_TYPE_UNSPECIFIED EncryptionType = 0
	// Google managed encryption key.
	EncryptionType_SERVICE_MANAGED EncryptionType = 1
	// Customer managed encryption key, which is stored in KMS.
	EncryptionType_CLOUD_KMS EncryptionType = 2
)

// Enum value maps for EncryptionType.
var (
	EncryptionType_name = map[int32]string{
		0: "ENCRYPTION_TYPE_UNSPECIFIED",
		1: "SERVICE_MANAGED",
		2: "CLOUD_KMS",
	}
	EncryptionType_value = map[string]int32{
		"ENCRYPTION_TYPE_UNSPECIFIED": 0,
		"SERVICE_MANAGED":             1,
		"CLOUD_KMS":                   2,
	}
)

func (x EncryptionType) Enum() *EncryptionType {
	p := new(EncryptionType)
	*p = x
	return p
}

func (x EncryptionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EncryptionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_netapp_v1_common_proto_enumTypes[1].Descriptor()
}

func (EncryptionType) Type() protoreflect.EnumType {
	return &file_google_cloud_netapp_v1_common_proto_enumTypes[1]
}

func (x EncryptionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EncryptionType.Descriptor instead.
func (EncryptionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_common_proto_rawDescGZIP(), []int{1}
}

// Metadata for a given
// [google.cloud.location.Location][google.cloud.location.Location].
type LocationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Supported service levels in a location.
	SupportedServiceLevels []ServiceLevel `protobuf:"varint,1,rep,packed,name=supported_service_levels,json=supportedServiceLevels,proto3,enum=google.cloud.netapp.v1.ServiceLevel" json:"supported_service_levels,omitempty"`
}

func (x *LocationMetadata) Reset() {
	*x = LocationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_common_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LocationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocationMetadata) ProtoMessage() {}

func (x *LocationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_common_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocationMetadata.ProtoReflect.Descriptor instead.
func (*LocationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_common_proto_rawDescGZIP(), []int{0}
}

func (x *LocationMetadata) GetSupportedServiceLevels() []ServiceLevel {
	if x != nil {
		return x.SupportedServiceLevels
	}
	return nil
}

var File_google_cloud_netapp_v1_common_proto protoreflect.FileDescriptor

var file_google_cloud_netapp_v1_common_proto_rawDesc = []byte{
	0x0a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x61, 0x70, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x77,
	0x0a, 0x10, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x63, 0x0a, 0x18, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x16, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x2a, 0x5f, 0x0a, 0x0c, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x45, 0x52, 0x56, 0x49,
	0x43, 0x45, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x52, 0x45, 0x4d, 0x49, 0x55,
	0x4d, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x58, 0x54, 0x52, 0x45, 0x4d, 0x45, 0x10, 0x02,
	0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x03, 0x12, 0x08,
	0x0a, 0x04, 0x46, 0x4c, 0x45, 0x58, 0x10, 0x04, 0x2a, 0x55, 0x0a, 0x0e, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x45, 0x4e,
	0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x53,
	0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x10, 0x01,
	0x12, 0x0d, 0x0a, 0x09, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x4b, 0x4d, 0x53, 0x10, 0x02, 0x42,
	0xad, 0x01, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x42, 0x0b,
	0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x32, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f,
	0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x70, 0x62, 0x3b, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x70,
	0x62, 0xaa, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x4e, 0x65, 0x74, 0x41, 0x70, 0x70, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x16, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x65, 0x74, 0x41, 0x70, 0x70,
	0x5c, 0x56, 0x31, 0xea, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4e, 0x65, 0x74, 0x41, 0x70, 0x70, 0x3a, 0x3a, 0x56, 0x31, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_netapp_v1_common_proto_rawDescOnce sync.Once
	file_google_cloud_netapp_v1_common_proto_rawDescData = file_google_cloud_netapp_v1_common_proto_rawDesc
)

func file_google_cloud_netapp_v1_common_proto_rawDescGZIP() []byte {
	file_google_cloud_netapp_v1_common_proto_rawDescOnce.Do(func() {
		file_google_cloud_netapp_v1_common_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_netapp_v1_common_proto_rawDescData)
	})
	return file_google_cloud_netapp_v1_common_proto_rawDescData
}

var file_google_cloud_netapp_v1_common_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_netapp_v1_common_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_netapp_v1_common_proto_goTypes = []interface{}{
	(ServiceLevel)(0),        // 0: google.cloud.netapp.v1.ServiceLevel
	(EncryptionType)(0),      // 1: google.cloud.netapp.v1.EncryptionType
	(*LocationMetadata)(nil), // 2: google.cloud.netapp.v1.LocationMetadata
}
var file_google_cloud_netapp_v1_common_proto_depIdxs = []int32{
	0, // 0: google.cloud.netapp.v1.LocationMetadata.supported_service_levels:type_name -> google.cloud.netapp.v1.ServiceLevel
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_google_cloud_netapp_v1_common_proto_init() }
func file_google_cloud_netapp_v1_common_proto_init() {
	if File_google_cloud_netapp_v1_common_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_netapp_v1_common_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LocationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_netapp_v1_common_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_netapp_v1_common_proto_goTypes,
		DependencyIndexes: file_google_cloud_netapp_v1_common_proto_depIdxs,
		EnumInfos:         file_google_cloud_netapp_v1_common_proto_enumTypes,
		MessageInfos:      file_google_cloud_netapp_v1_common_proto_msgTypes,
	}.Build()
	File_google_cloud_netapp_v1_common_proto = out.File
	file_google_cloud_netapp_v1_common_proto_rawDesc = nil
	file_google_cloud_netapp_v1_common_proto_goTypes = nil
	file_google_cloud_netapp_v1_common_proto_depIdxs = nil
}
