//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/timeseriesinsights/armtimeseriesinsights"
	"net/http"
	"net/url"
	"regexp"
)

// EventSourcesServer is a fake server for instances of the armtimeseriesinsights.EventSourcesClient type.
type EventSourcesServer struct {
	// CreateOrUpdate is the fake for method EventSourcesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, environmentName string, eventSourceName string, parameters armtimeseriesinsights.EventSourceCreateOrUpdateParametersClassification, options *armtimeseriesinsights.EventSourcesClientCreateOrUpdateOptions) (resp azfake.Responder[armtimeseriesinsights.EventSourcesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method EventSourcesClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, environmentName string, eventSourceName string, options *armtimeseriesinsights.EventSourcesClientDeleteOptions) (resp azfake.Responder[armtimeseriesinsights.EventSourcesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method EventSourcesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, environmentName string, eventSourceName string, options *armtimeseriesinsights.EventSourcesClientGetOptions) (resp azfake.Responder[armtimeseriesinsights.EventSourcesClientGetResponse], errResp azfake.ErrorResponder)

	// ListByEnvironment is the fake for method EventSourcesClient.ListByEnvironment
	// HTTP status codes to indicate success: http.StatusOK
	ListByEnvironment func(ctx context.Context, resourceGroupName string, environmentName string, options *armtimeseriesinsights.EventSourcesClientListByEnvironmentOptions) (resp azfake.Responder[armtimeseriesinsights.EventSourcesClientListByEnvironmentResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method EventSourcesClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, environmentName string, eventSourceName string, eventSourceUpdateParameters armtimeseriesinsights.EventSourceUpdateParametersClassification, options *armtimeseriesinsights.EventSourcesClientUpdateOptions) (resp azfake.Responder[armtimeseriesinsights.EventSourcesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewEventSourcesServerTransport creates a new instance of EventSourcesServerTransport with the provided implementation.
// The returned EventSourcesServerTransport instance is connected to an instance of armtimeseriesinsights.EventSourcesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewEventSourcesServerTransport(srv *EventSourcesServer) *EventSourcesServerTransport {
	return &EventSourcesServerTransport{srv: srv}
}

// EventSourcesServerTransport connects instances of armtimeseriesinsights.EventSourcesClient to instances of EventSourcesServer.
// Don't use this type directly, use NewEventSourcesServerTransport instead.
type EventSourcesServerTransport struct {
	srv *EventSourcesServer
}

// Do implements the policy.Transporter interface for EventSourcesServerTransport.
func (e *EventSourcesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "EventSourcesClient.CreateOrUpdate":
		resp, err = e.dispatchCreateOrUpdate(req)
	case "EventSourcesClient.Delete":
		resp, err = e.dispatchDelete(req)
	case "EventSourcesClient.Get":
		resp, err = e.dispatchGet(req)
	case "EventSourcesClient.ListByEnvironment":
		resp, err = e.dispatchListByEnvironment(req)
	case "EventSourcesClient.Update":
		resp, err = e.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *EventSourcesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if e.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TimeSeriesInsights/environments/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSources/(?P<eventSourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	raw, err := readRequestBody(req)
	if err != nil {
		return nil, err
	}
	body, err := unmarshalEventSourceCreateOrUpdateParametersClassification(raw)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
	if err != nil {
		return nil, err
	}
	eventSourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventSourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, environmentNameParam, eventSourceNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EventSourceResourceClassification, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EventSourcesServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if e.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TimeSeriesInsights/environments/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSources/(?P<eventSourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
	if err != nil {
		return nil, err
	}
	eventSourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventSourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Delete(req.Context(), resourceGroupNameParam, environmentNameParam, eventSourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EventSourcesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if e.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TimeSeriesInsights/environments/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSources/(?P<eventSourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
	if err != nil {
		return nil, err
	}
	eventSourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventSourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Get(req.Context(), resourceGroupNameParam, environmentNameParam, eventSourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EventSourceResourceClassification, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EventSourcesServerTransport) dispatchListByEnvironment(req *http.Request) (*http.Response, error) {
	if e.srv.ListByEnvironment == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListByEnvironment not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TimeSeriesInsights/environments/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSources`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.ListByEnvironment(req.Context(), resourceGroupNameParam, environmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EventSourceListResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EventSourcesServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if e.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TimeSeriesInsights/environments/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSources/(?P<eventSourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	raw, err := readRequestBody(req)
	if err != nil {
		return nil, err
	}
	body, err := unmarshalEventSourceUpdateParametersClassification(raw)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
	if err != nil {
		return nil, err
	}
	eventSourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventSourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Update(req.Context(), resourceGroupNameParam, environmentNameParam, eventSourceNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EventSourceResourceClassification, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
