//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
)

// SensitivitySettingsServer is a fake server for instances of the armsecurity.SensitivitySettingsClient type.
type SensitivitySettingsServer struct {
	// List is the fake for method SensitivitySettingsClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, options *armsecurity.SensitivitySettingsClientListOptions) (resp azfake.Responder[armsecurity.SensitivitySettingsClientListResponse], errResp azfake.ErrorResponder)
}

// NewSensitivitySettingsServerTransport creates a new instance of SensitivitySettingsServerTransport with the provided implementation.
// The returned SensitivitySettingsServerTransport instance is connected to an instance of armsecurity.SensitivitySettingsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSensitivitySettingsServerTransport(srv *SensitivitySettingsServer) *SensitivitySettingsServerTransport {
	return &SensitivitySettingsServerTransport{srv: srv}
}

// SensitivitySettingsServerTransport connects instances of armsecurity.SensitivitySettingsClient to instances of SensitivitySettingsServer.
// Don't use this type directly, use NewSensitivitySettingsServerTransport instead.
type SensitivitySettingsServerTransport struct {
	srv *SensitivitySettingsServer
}

// Do implements the policy.Transporter interface for SensitivitySettingsServerTransport.
func (s *SensitivitySettingsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SensitivitySettingsClient.List":
		resp, err = s.dispatchList(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SensitivitySettingsServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if s.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	respr, errRespr := s.srv.List(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).GetSensitivitySettingsListResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
