//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// SecureScoresServer is a fake server for instances of the armsecurity.SecureScoresClient type.
type SecureScoresServer struct {
	// Get is the fake for method SecureScoresClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, secureScoreName string, options *armsecurity.SecureScoresClientGetOptions) (resp azfake.Responder[armsecurity.SecureScoresClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method SecureScoresClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armsecurity.SecureScoresClientListOptions) (resp azfake.PagerResponder[armsecurity.SecureScoresClientListResponse])
}

// NewSecureScoresServerTransport creates a new instance of SecureScoresServerTransport with the provided implementation.
// The returned SecureScoresServerTransport instance is connected to an instance of armsecurity.SecureScoresClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSecureScoresServerTransport(srv *SecureScoresServer) *SecureScoresServerTransport {
	return &SecureScoresServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armsecurity.SecureScoresClientListResponse]](),
	}
}

// SecureScoresServerTransport connects instances of armsecurity.SecureScoresClient to instances of SecureScoresServer.
// Don't use this type directly, use NewSecureScoresServerTransport instead.
type SecureScoresServerTransport struct {
	srv          *SecureScoresServer
	newListPager *tracker[azfake.PagerResponder[armsecurity.SecureScoresClientListResponse]]
}

// Do implements the policy.Transporter interface for SecureScoresServerTransport.
func (s *SecureScoresServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SecureScoresClient.Get":
		resp, err = s.dispatchGet(req)
	case "SecureScoresClient.NewListPager":
		resp, err = s.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SecureScoresServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/secureScores/(?P<secureScoreName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	secureScoreNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("secureScoreName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), secureScoreNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SecureScoreItem, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SecureScoresServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := s.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/secureScores`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := s.srv.NewListPager(nil)
		newListPager = &resp
		s.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsecurity.SecureScoresClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		s.newListPager.remove(req)
	}
	return resp, nil
}
