//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhardwaresecuritymodules

import "time"

// APIEntityReference - The API entity reference.
type APIEntityReference struct {
	// The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/…
	ID *string
}

// DedicatedHsm - Resource information with extended details.
type DedicatedHsm struct {
	// REQUIRED; The supported Azure location where the dedicated HSM should be created.
	Location *string

	// REQUIRED; Properties of the dedicated HSM
	Properties *DedicatedHsmProperties

	// SKU details
	SKU *SKU

	// Resource tags
	Tags map[string]*string

	// The Dedicated Hsm zones.
	Zones []*string

	// READ-ONLY; The Azure Resource Manager resource ID for the dedicated HSM.
	ID *string

	// READ-ONLY; The name of the dedicated HSM.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource
	SystemData *SystemData

	// READ-ONLY; The resource type of the dedicated HSM.
	Type *string
}

// DedicatedHsmError - The error exception.
type DedicatedHsmError struct {
	// READ-ONLY; The error detail of the operation if any.
	Error *Error
}

// DedicatedHsmListResult - List of dedicated HSMs
type DedicatedHsmListResult struct {
	// The URL to get the next set of dedicated hsms.
	NextLink *string

	// The list of dedicated HSMs.
	Value []*DedicatedHsm
}

// DedicatedHsmOperation - REST API operation
type DedicatedHsmOperation struct {
	// The display string.
	Display *DedicatedHsmOperationDisplay

	// The name of the Dedicated HSM Resource Provider Operation.
	Name *string

	// READ-ONLY; Gets or sets a value indicating whether it is a data plane action
	IsDataAction *string
}

// DedicatedHsmOperationDisplay - The display string.
type DedicatedHsmOperationDisplay struct {
	// The object that represents the operation.
	Description *string

	// Operation type: Read, write, delete, etc.
	Operation *string

	// The Resource Provider of the operation
	Provider *string

	// Resource on which the operation is performed.
	Resource *string
}

// DedicatedHsmOperationListResult - Result of the request to list Dedicated HSM Provider operations. It contains a list of
// operations.
type DedicatedHsmOperationListResult struct {
	// List of Dedicated HSM Resource Provider operations.
	Value []*DedicatedHsmOperation
}

// DedicatedHsmPatchParameters - Patchable properties of the dedicated HSM
type DedicatedHsmPatchParameters struct {
	// Resource tags
	Tags map[string]*string
}

// DedicatedHsmProperties - Properties of the dedicated hsm
type DedicatedHsmProperties struct {
	// Specifies the management network interfaces of the dedicated hsm.
	ManagementNetworkProfile *NetworkProfile

	// Specifies the network interfaces of the dedicated hsm.
	NetworkProfile *NetworkProfile

	// This field will be used when RP does not support Availability zones.
	StampID *string

	// READ-ONLY; Provisioning state.
	ProvisioningState *JSONWebKeyType

	// READ-ONLY; Resource Status Message.
	StatusMessage *string
}

// EndpointDependency - A domain name that dedicated hsm services are reaching at.
type EndpointDependency struct {
	// The domain name of the dependency.
	DomainName *string

	// The Ports and Protocols used when connecting to domainName.
	EndpointDetails []*EndpointDetail
}

// EndpointDetail - Connect information from the dedicated hsm service to a single endpoint.
type EndpointDetail struct {
	// Description of the detail
	Description *string

	// An IP Address that Domain Name currently resolves to.
	IPAddress *string

	// The port an endpoint is connected to.
	Port *int32

	// The protocol used for connection
	Protocol *string
}

// Error - The key vault server error.
type Error struct {
	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; Contains more specific error that narrows down the cause. May be null.
	InnerError *Error

	// READ-ONLY; The error message.
	Message *string
}

// NetworkInterface - The network interface definition.
type NetworkInterface struct {
	// Private Ip address of the interface
	PrivateIPAddress *string

	// READ-ONLY; The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/…
	ID *string
}

// NetworkProfile - The network profile definition.
type NetworkProfile struct {
	// Specifies the list of resource Ids for the network interfaces associated with the dedicated HSM.
	NetworkInterfaces []*NetworkInterface

	// Specifies the identifier of the subnet.
	Subnet *APIEntityReference
}

// OutboundEnvironmentEndpoint - Egress endpoints which dedicated hsm service connects to for common purpose.
type OutboundEnvironmentEndpoint struct {
	// The category of endpoints accessed by the dedicated hsm service, e.g. azure-resource-management, apiserver, etc.
	Category *string

	// The endpoints that dedicated hsm service connects to
	Endpoints []*EndpointDependency
}

// OutboundEnvironmentEndpointCollection - Collection of OutboundEnvironmentEndpoint
type OutboundEnvironmentEndpointCollection struct {
	// REQUIRED; Collection of resources.
	Value []*OutboundEnvironmentEndpoint

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// Resource - Dedicated HSM resource
type Resource struct {
	// REQUIRED; The supported Azure location where the dedicated HSM should be created.
	Location *string

	// SKU details
	SKU *SKU

	// Resource tags
	Tags map[string]*string

	// The Dedicated Hsm zones.
	Zones []*string

	// READ-ONLY; The Azure Resource Manager resource ID for the dedicated HSM.
	ID *string

	// READ-ONLY; The name of the dedicated HSM.
	Name *string

	// READ-ONLY; The resource type of the dedicated HSM.
	Type *string
}

// ResourceListResult - List of dedicated HSM resources.
type ResourceListResult struct {
	// The URL to get the next set of dedicated HSM resources.
	NextLink *string

	// The list of dedicated HSM resources.
	Value []*Resource
}

// SKU of the dedicated HSM
type SKU struct {
	// SKU of the dedicated HSM
	Name *SKUName
}

// SystemData - Metadata pertaining to creation and last modification of dedicated hsm resource.
type SystemData struct {
	// The timestamp of dedicated hsm resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created dedicated hsm resource.
	CreatedBy *string

	// The type of identity that created dedicated hsm resource.
	CreatedByType *IdentityType

	// The timestamp of dedicated hsm resource last modification (UTC).
	LastModifiedAt *time.Time

	// The identity that last modified dedicated hsm resource.
	LastModifiedBy *string

	// The type of identity that last modified dedicated hsm resource.
	LastModifiedByType *IdentityType
}
