"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TSI5Table = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const ot_vtt_private_1 = require("@ot-builder/ot-vtt-private");
exports.TSI5Table = {
    ...(0, bin_util_1.Read)((view, gOrd) => {
        const table = new ot_vtt_private_1.TSI5.Table();
        for (const glyph of gOrd) {
            table.charGroupFlags.set(glyph, view.uint16());
        }
        return table;
    }),
    ...(0, bin_util_1.Write)((frag, table, gOrd) => {
        for (const glyph of gOrd) {
            frag.uint16(table.charGroupFlags.get(glyph) || 0);
        }
    })
};
//# sourceMappingURL=index.js.map