# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.
"""Catalog of known task tags and task tag prefixes."""

from debusine.utils.tag_utils import ProvenanceRestrictions

#: Tags from database queries
PROVENANCE_SYSTEM = "system"
#: Tags from user data
PROVENANCE_USER = "user"

#: Prefix for scope tags
SCOPE_PREFIX = "task:scope:"
#: Prefix for scope tags
WORKSPACE_PREFIX = "task:workspace:"
#: Prefix for user groups
GROUP_PREFIX = "task:group:"
#: Prefix for source packages
SOURCE_PACKAGE_PREFIX = "task:source-package:"

#: Restrictions applied when adding provided tags
restrictions_when_provided = ProvenanceRestrictions("task-provided")
# task:group:* tags are only allowed to come from database queries
restrictions_when_provided.add_prefix(GROUP_PREFIX, [PROVENANCE_SYSTEM])
# task:scope:* tags are only allowed to come from database queries
restrictions_when_provided.add_prefix(SCOPE_PREFIX, [PROVENANCE_SYSTEM])
# task:workspace:* tags are only allowed to come from database queries
restrictions_when_provided.add_prefix(WORKSPACE_PREFIX, [PROVENANCE_SYSTEM])

#: Restrictions applied when adding required tags
# Use empty restrictions, since adding required tags is not a security
# sensitive operation, but removing them is
restrictions_when_required = ProvenanceRestrictions("task-required")
