
inline MemoryBuf::MemoryBuf(std::string const &bufSize,
                            std::ios::openmode openMode, size_t access)
:
    MemoryBuf(bufSize, false, openMode, access)
{}


inline MemoryBuf::MemoryBuf(int id, std::ios::openmode openMode)
:
    MemoryBuf(id, false, openMode)
{}

inline int MemoryBuf::id() const
{
    return d_bridge.id();
}

inline void MemoryBuf::info(std::ostream &out) const
{
    d_bridge.info(out);
}

    // by X
inline std::streamsize MemoryBuf::maxEnd() const
{
    return d_bridge.maxEnd();
}

    // by memorystream/memorystream.f (setErase)
inline void MemoryBuf::setErase(bool erase)
{
    d_bridge.setErase(erase);
}

inline void MemoryBuf::truncate(std::streamsize size)
{
    d_bridge.truncate(size);
}

    // by sharedstream/writtenuntil.f
inline std::streamsize MemoryBuf::writtenUntil() const
{
    return d_bridge.writtenUntil();
}
