#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2016 Mopi
set -o errexit

###
# Trine
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250612.5

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='trine-1'
GAME_NAME='Trine'

ARCHIVE_BASE_0_NAME='gog_trine_enchanted_edition_2.0.0.2.sh'
ARCHIVE_BASE_0_MD5='0e8d2338b568222b28cf3c31059b4960'
ARCHIVE_BASE_0_SIZE='1500000'
ARCHIVE_BASE_0_VERSION='2.12.508-gog2.0.0.2'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/trine_enchanted_edition'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_LIBS_BIN_RELATIVE_PATH='lib/lib32'
CONTENT_LIBS_BIN_FILES='
libCg.so
libCgGL.so'
CONTENT_GAME_BIN_FILES='
bin/trine1_bin_starter.sh
bin/trine1_linux_32bit
bin/trine1_linux_launcher_32bit'
CONTENT_GAME_DATA_FILES='
data
*.fbq
*.png'
CONTENT_DOC_DATA_FILES='
*.txt'

APP_MAIN_EXE='bin/trine1_linux_launcher_32bit'
APP_MAIN_ICON='trine1.png'
## The game fails to start if the wayland SDL backend is used.
APP_MAIN_PRERUN='
# The game fails to start if the wayland SDL backend is used.
if [ "${SDL_VIDEODRIVER:-}" = "wayland" ]; then
	unset SDL_VIDEODRIVER
fi
'
## Keep hold of the terminal until the game process actually ends,
## instead of returning as soon as the launcher is closed.
APP_MAIN_POSTRUN='
# Keep hold of the terminal until the game process actually ends,
# instead of returning as soon as the launcher is closed.
sleep 3s
pidwait --euid "$USER" --full trine1_linux_32bit
'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libasound.so.2
libc.so.6
libdl.so.2
libfreetype.so.6
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libgdk-x11-2.0.so.0
libglib-2.0.so.0
libGL.so.1
libGLU.so.1
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libogg.so.0
libpango-1.0.so.0
libpng12.so.0
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Set execution permissions on all binaries.
	chmod 755 bin/*
)

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

## Force the use of system-provided SDL
APP_MAIN_PRERUN="$(application_prerun 'APP_MAIN')
$(launcher_tweak_sdl_override)"
PKG_BIN_DEPENDENCIES_LIBRARIES="$(dependencies_list_native_libraries 'PKG_BIN')
libSDL2-2.0.so.0"

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
